/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2FileRetention;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2UpdateFileRetentionRequest {
    @B2Json.required
    public final String fileName;
    @B2Json.required
    public final String fileId;
    @B2Json.optional
    public final boolean bypassGovernance;
    @B2Json.required
    public final B2FileRetention fileRetention;

    @B2Json.constructor(params="fileName, fileId, bypassGovernance, fileRetention")
    private B2UpdateFileRetentionRequest(String fileName, String fileId, boolean bypassGovernance, B2FileRetention fileRetention) {
        B2Preconditions.checkArgument(fileRetention.getMode() == null || "compliance".equals(fileRetention.getMode()) || "governance".equals(fileRetention.getMode()), "Invalid value for file retention mode");
        B2Preconditions.checkArgument(fileRetention.getMode() != null && fileRetention.getRetainUntilTimestamp() != null || fileRetention.getMode() == null && fileRetention.getRetainUntilTimestamp() == null, "Both file retention mode and retainUntilTimestamp are required if either is supplied");
        this.fileName = fileName;
        this.fileId = fileId;
        this.bypassGovernance = bypassGovernance;
        this.fileRetention = fileRetention;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileId() {
        return this.fileId;
    }

    public boolean isBypassGovernance() {
        return this.bypassGovernance;
    }

    public B2FileRetention getFileRetention() {
        return this.fileRetention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2UpdateFileRetentionRequest that = (B2UpdateFileRetentionRequest)o;
        return Objects.equals(this.getFileName(), that.getFileName()) && Objects.equals(this.getFileId(), that.getFileId()) && this.isBypassGovernance() == that.isBypassGovernance() && Objects.equals(this.getFileRetention(), that.getFileRetention());
    }

    public int hashCode() {
        return Objects.hash(this.getFileName(), this.getFileId(), this.isBypassGovernance(), this.getFileRetention());
    }

    public static Builder builder(String fileName, String fileId, B2FileRetention fileRetention) {
        return new Builder(fileName, fileId, fileRetention);
    }

    public static class Builder {
        private final String fileName;
        private final String fileId;
        private final B2FileRetention fileRetention;
        private boolean bypassGovernance;

        public Builder(String fileName, String fileId, B2FileRetention fileRetention) {
            this.fileName = fileName;
            this.fileId = fileId;
            this.fileRetention = fileRetention;
        }

        public Builder setBypassGovernance(boolean bypassGovernance) {
            this.bypassGovernance = bypassGovernance;
            return this;
        }

        public B2UpdateFileRetentionRequest build() {
            return new B2UpdateFileRetentionRequest(this.fileName, this.fileId, this.bypassGovernance, this.fileRetention);
        }
    }
}

