/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2UpdateFileLegalHoldRequest {
    @B2Json.required
    public final String fileName;
    @B2Json.required
    public final String fileId;
    @B2Json.required
    public final String legalHold;

    @B2Json.constructor(params="fileName, fileId, legalHold")
    private B2UpdateFileLegalHoldRequest(String fileName, String fileId, String legalHold) {
        B2Preconditions.checkArgument("on".equals(legalHold) || "off".equals(legalHold), String.format("Invalid legalHold value. Valid values: %s, %s", "on", "off"));
        this.fileName = fileName;
        this.fileId = fileId;
        this.legalHold = legalHold;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getLegalHold() {
        return this.legalHold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2UpdateFileLegalHoldRequest that = (B2UpdateFileLegalHoldRequest)o;
        return Objects.equals(this.getFileName(), that.getFileName()) && Objects.equals(this.getFileId(), that.getFileId()) && Objects.equals(this.getLegalHold(), that.getLegalHold());
    }

    public int hashCode() {
        return Objects.hash(this.getFileName(), this.getFileId(), this.getLegalHold());
    }

    public static Builder builder(String fileName, String fileId, String legalHold) {
        return new Builder(fileName, fileId, legalHold);
    }

    public static class Builder {
        private final String fileName;
        private final String fileId;
        private final String legalHold;

        public Builder(String fileName, String fileId, String legalHold) {
            this.fileName = fileName;
            this.fileId = fileId;
            this.legalHold = legalHold;
        }

        public B2UpdateFileLegalHoldRequest build() {
            return new B2UpdateFileLegalHoldRequest(this.fileName, this.fileId, this.legalHold);
        }
    }
}

