/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2Bucket;
import com.backblaze.b2.client.structures.B2BucketDefaultRetention;
import com.backblaze.b2.client.structures.B2BucketReplicationConfiguration;
import com.backblaze.b2.client.structures.B2BucketServerSideEncryption;
import com.backblaze.b2.client.structures.B2CorsRule;
import com.backblaze.b2.client.structures.B2LifecycleRule;
import com.backblaze.b2.json.B2Json;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class B2UpdateBucketRequest {
    @B2Json.required
    private final String accountId;
    @B2Json.required
    private final String bucketId;
    @B2Json.optional
    private final String bucketType;
    @B2Json.optional
    private final Map<String, String> bucketInfo;
    @B2Json.optional
    private final List<B2CorsRule> corsRules;
    @B2Json.optional
    private final List<B2LifecycleRule> lifecycleRules;
    @B2Json.optional
    private final B2BucketDefaultRetention defaultRetention;
    @B2Json.optional
    private final B2BucketServerSideEncryption defaultServerSideEncryption;
    @B2Json.optional
    private final B2BucketReplicationConfiguration replicationConfiguration;
    @B2Json.optional
    private final Boolean fileLockEnabled;
    @B2Json.optional
    private final Integer ifRevisionIs;

    @B2Json.constructor(params="accountId,bucketId,bucketType,bucketInfo,corsRules,lifecycleRules,defaultRetention,defaultServerSideEncryption,replicationConfiguration,fileLockEnabled,ifRevisionIs")
    private B2UpdateBucketRequest(String accountId, String bucketId, String bucketType, Map<String, String> bucketInfo, List<B2CorsRule> corsRules, List<B2LifecycleRule> lifecycleRules, B2BucketDefaultRetention defaultRetention, B2BucketServerSideEncryption defaultServerSideEncryption, B2BucketReplicationConfiguration replicationConfiguration, Boolean fileLockEnabled, Integer ifRevisionIs) {
        this.accountId = accountId;
        this.bucketId = bucketId;
        this.bucketType = bucketType;
        this.bucketInfo = bucketInfo;
        this.corsRules = corsRules;
        this.lifecycleRules = lifecycleRules;
        this.defaultRetention = defaultRetention;
        this.defaultServerSideEncryption = defaultServerSideEncryption;
        this.replicationConfiguration = replicationConfiguration;
        this.fileLockEnabled = fileLockEnabled;
        this.ifRevisionIs = ifRevisionIs;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBucketType() {
        return this.bucketType;
    }

    public Map<String, String> getBucketInfo() {
        return this.bucketInfo;
    }

    public List<B2CorsRule> getCorsRules() {
        return this.corsRules;
    }

    public List<B2LifecycleRule> getLifecycleRules() {
        return this.lifecycleRules;
    }

    public B2BucketDefaultRetention getDefaultRetention() {
        return this.defaultRetention;
    }

    public B2BucketServerSideEncryption getDefaultServerSideEncryption() {
        return this.defaultServerSideEncryption;
    }

    public B2BucketReplicationConfiguration getReplicationConfiguration() {
        return this.replicationConfiguration;
    }

    public Boolean getFileLockEnabled() {
        return this.fileLockEnabled;
    }

    public Integer getIfRevisionIs() {
        return this.ifRevisionIs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2UpdateBucketRequest that = (B2UpdateBucketRequest)o;
        return Objects.equals(this.getAccountId(), that.getAccountId()) && Objects.equals(this.getBucketId(), that.getBucketId()) && Objects.equals(this.getBucketType(), that.getBucketType()) && Objects.equals(this.getBucketInfo(), that.getBucketInfo()) && Objects.equals(this.getCorsRules(), that.getCorsRules()) && Objects.equals(this.getLifecycleRules(), that.getLifecycleRules()) && Objects.equals(this.getDefaultRetention(), that.getDefaultRetention()) && Objects.equals(this.getDefaultServerSideEncryption(), that.getDefaultServerSideEncryption()) && Objects.equals(this.getReplicationConfiguration(), that.getReplicationConfiguration()) && Objects.equals(this.getFileLockEnabled(), that.getFileLockEnabled()) && Objects.equals(this.getIfRevisionIs(), that.getIfRevisionIs());
    }

    public int hashCode() {
        return Objects.hash(this.getAccountId(), this.getBucketId(), this.getBucketType(), this.getBucketInfo(), this.getCorsRules(), this.getLifecycleRules(), this.getDefaultRetention(), this.getDefaultServerSideEncryption(), this.getReplicationConfiguration(), this.getFileLockEnabled(), this.getIfRevisionIs());
    }

    public static Builder builder(B2Bucket bucket) {
        return new Builder(bucket);
    }

    public static class Builder {
        private final String accountId;
        private final String bucketId;
        private final Integer ifRevisionIs;
        private String bucketType;
        private Map<String, String> bucketInfo;
        private List<B2CorsRule> corsRules;
        private List<B2LifecycleRule> lifecycleRules;
        private B2BucketDefaultRetention defaultRetention;
        private B2BucketServerSideEncryption defaultServerSideEncryption;
        private B2BucketReplicationConfiguration replicationConfiguration;
        private Boolean fileLockEnabled;

        private Builder(B2Bucket bucket) {
            this.accountId = bucket.getAccountId();
            this.bucketId = bucket.getBucketId();
            this.ifRevisionIs = bucket.getRevision();
        }

        public Builder setBucketType(String bucketType) {
            this.bucketType = bucketType;
            return this;
        }

        public Builder setBucketInfo(Map<String, String> bucketInfo) {
            this.bucketInfo = bucketInfo;
            return this;
        }

        public Builder setCorsRules(List<B2CorsRule> corsRules) {
            this.corsRules = corsRules;
            return this;
        }

        public Builder setLifecycleRules(List<B2LifecycleRule> lifecycleRules) {
            this.lifecycleRules = lifecycleRules;
            return this;
        }

        public Builder setDefaultRetention(B2BucketDefaultRetention defaultRetention) {
            this.defaultRetention = defaultRetention;
            return this;
        }

        public Builder setDefaultServerSideEncryption(B2BucketServerSideEncryption defaultServerSideEncryption) {
            this.defaultServerSideEncryption = defaultServerSideEncryption;
            return this;
        }

        public Builder setReplicationConfiguration(B2BucketReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        public Builder setFileLockEnabled(Boolean fileLockEnabled) {
            this.fileLockEnabled = fileLockEnabled;
            return this;
        }

        public B2UpdateBucketRequest build() {
            return new B2UpdateBucketRequest(this.accountId, this.bucketId, this.bucketType, this.bucketInfo, this.corsRules, this.lifecycleRules, this.defaultRetention, this.defaultServerSideEncryption, this.replicationConfiguration, this.fileLockEnabled, this.ifRevisionIs);
        }
    }
}

