/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2FileSseForRequest;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2StoreLargeFileRequest {
    @B2Json.required
    private final B2FileVersion fileVersion;
    @B2Json.optional
    private final B2FileSseForRequest serverSideEncryption;

    @B2Json.constructor(params="fileVersion,serverSideEncryption")
    private B2StoreLargeFileRequest(B2FileVersion fileVersion, B2FileSseForRequest serverSideEncryption) {
        B2Preconditions.checkArgumentIsNotNull(fileVersion, "fileVersion");
        B2Preconditions.checkArgument(serverSideEncryption == null || "SSE-C".equals(serverSideEncryption.getMode()));
        this.fileVersion = fileVersion;
        this.serverSideEncryption = serverSideEncryption;
    }

    public B2FileVersion getFileVersion() {
        return this.fileVersion;
    }

    public B2FileSseForRequest getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2StoreLargeFileRequest that = (B2StoreLargeFileRequest)o;
        return Objects.equals(this.getFileVersion(), that.getFileVersion()) && Objects.equals(this.getServerSideEncryption(), that.getServerSideEncryption());
    }

    public int hashCode() {
        return Objects.hash(this.getFileVersion(), this.getServerSideEncryption());
    }

    public static Builder builder(B2FileVersion fileVersion) {
        return new Builder(fileVersion);
    }

    public static class Builder {
        private B2FileVersion fileVersion;
        private B2FileSseForRequest serverSideEncryption;

        Builder(B2FileVersion fileVersion) {
            this.fileVersion = fileVersion;
        }

        public Builder setServerSideEncryption(B2FileSseForRequest serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public B2StoreLargeFileRequest build() {
            return new B2StoreLargeFileRequest(this.fileVersion, this.serverSideEncryption);
        }
    }
}

