/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2ReplicationRule {
    @B2Json.required
    private final String replicationRuleName;
    @B2Json.required
    private final String destinationBucketId;
    @B2Json.required
    private final int priority;
    @B2Json.required
    private final String fileNamePrefix;
    @B2Json.required
    private final boolean isEnabled;
    @B2Json.required
    private final boolean includeExistingFiles;

    @B2Json.constructor(params="replicationRuleName, destinationBucketId, priority, fileNamePrefix, isEnabled, includeExistingFiles")
    public B2ReplicationRule(String replicationRuleName, String destinationBucketId, int priority, String fileNamePrefix, boolean isEnabled, boolean includeExistingFiles) {
        this.replicationRuleName = replicationRuleName;
        this.destinationBucketId = destinationBucketId;
        this.priority = priority;
        this.fileNamePrefix = fileNamePrefix;
        this.isEnabled = isEnabled;
        this.includeExistingFiles = includeExistingFiles;
    }

    public String getReplicationRuleName() {
        return this.replicationRuleName;
    }

    public String getDestinationBucketId() {
        return this.destinationBucketId;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean includeExistingFiles() {
        return this.includeExistingFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2ReplicationRule that = (B2ReplicationRule)o;
        return this.priority == that.priority && this.isEnabled == that.isEnabled && this.includeExistingFiles == that.includeExistingFiles && Objects.equals(this.replicationRuleName, that.replicationRuleName) && Objects.equals(this.destinationBucketId, that.destinationBucketId) && Objects.equals(this.fileNamePrefix, that.fileNamePrefix);
    }

    public int hashCode() {
        return Objects.hash(this.replicationRuleName, this.destinationBucketId, this.priority, this.fileNamePrefix, this.isEnabled, this.includeExistingFiles);
    }

    public String toString() {
        return "B2ReplicationRule{replicationRuleName='" + this.replicationRuleName + '\'' + ", destinationBucketId='" + this.destinationBucketId + '\'' + ", priority=" + this.priority + ", fileNamePrefix='" + this.fileNamePrefix + '\'' + ", isEnabled=" + this.isEnabled + ", includeExistingFiles=" + this.includeExistingFiles + '}';
    }
}

