/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2BucketServerSideEncryption {
    @B2Json.optional
    private final String mode;
    @B2Json.optional
    private final String algorithm;
    private static final B2BucketServerSideEncryption SSE_B2_AES256 = new B2BucketServerSideEncryption("SSE-B2", "AES256");
    private static final B2BucketServerSideEncryption SSE_NONE = new B2BucketServerSideEncryption(null, null);

    @B2Json.constructor(params="mode, algorithm")
    private B2BucketServerSideEncryption(String mode, String algorithm) {
        this.mode = mode;
        this.algorithm = algorithm;
    }

    public static B2BucketServerSideEncryption createSseB2Aes256() {
        return SSE_B2_AES256;
    }

    public static B2BucketServerSideEncryption createSseNone() {
        return SSE_NONE;
    }

    public String getMode() {
        return this.mode;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2BucketServerSideEncryption that = (B2BucketServerSideEncryption)o;
        return Objects.equals(this.mode, that.getMode()) && Objects.equals(this.algorithm, that.getAlgorithm());
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.algorithm);
    }

    public String toString() {
        return "B2BucketServerSideEncryption{mode='" + this.mode + "', algorithm=" + this.algorithm + '}';
    }
}

