/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.exceptions.B2ForbiddenException;
import com.backblaze.b2.client.structures.B2AuthorizationFilteredResponseField;
import com.backblaze.b2.client.structures.B2BucketFileLockConfiguration;
import com.backblaze.b2.client.structures.B2BucketReplicationConfiguration;
import com.backblaze.b2.client.structures.B2BucketServerSideEncryption;
import com.backblaze.b2.client.structures.B2CorsRule;
import com.backblaze.b2.client.structures.B2LifecycleRule;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class B2Bucket {
    @B2Json.required
    private final String accountId;
    @B2Json.required
    private final String bucketId;
    @B2Json.required
    private final String bucketName;
    @B2Json.optional
    private final String bucketType;
    @B2Json.optional
    private final Map<String, String> bucketInfo;
    @B2Json.optional
    private final List<B2CorsRule> corsRules;
    @B2Json.optional
    private final List<B2LifecycleRule> lifecycleRules;
    @B2Json.optional
    private final Set<String> options;
    @B2Json.required
    private final B2AuthorizationFilteredResponseField<B2BucketFileLockConfiguration> fileLockConfiguration;
    @B2Json.required
    private final B2AuthorizationFilteredResponseField<B2BucketServerSideEncryption> defaultServerSideEncryption;
    @B2Json.optional
    private final B2AuthorizationFilteredResponseField<B2BucketReplicationConfiguration> replicationConfiguration;
    @B2Json.required
    private final int revision;

    @B2Json.constructor(params="accountId,bucketId,bucketName,bucketType,bucketInfo,corsRules,lifecycleRules,options,fileLockConfiguration,defaultServerSideEncryption,replicationConfiguration,revision")
    public B2Bucket(String accountId, String bucketId, String bucketName, String bucketType, Map<String, String> bucketInfo, List<B2CorsRule> corsRules, List<B2LifecycleRule> lifecycleRules, Set<String> options, B2AuthorizationFilteredResponseField<B2BucketFileLockConfiguration> fileLockConfiguration, B2AuthorizationFilteredResponseField<B2BucketServerSideEncryption> defaultServerSideEncryption, B2AuthorizationFilteredResponseField<B2BucketReplicationConfiguration> replicationConfiguration, int revision) {
        this.accountId = accountId;
        this.bucketId = bucketId;
        this.bucketName = bucketName;
        this.bucketType = bucketType;
        this.bucketInfo = bucketInfo;
        this.corsRules = corsRules;
        this.lifecycleRules = lifecycleRules;
        this.options = options;
        this.fileLockConfiguration = fileLockConfiguration;
        this.defaultServerSideEncryption = defaultServerSideEncryption;
        this.replicationConfiguration = replicationConfiguration;
        this.revision = revision;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getBucketType() {
        return this.bucketType;
    }

    public Map<String, String> getBucketInfo() {
        return this.bucketInfo;
    }

    public List<B2CorsRule> getCorsRules() {
        return this.corsRules;
    }

    public List<B2LifecycleRule> getLifecycleRules() {
        return this.lifecycleRules;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isClientAuthorizedToReadFileLockConfiguration() {
        B2Preconditions.checkState(this.fileLockConfiguration != null);
        return this.fileLockConfiguration.isClientAuthorizedToRead();
    }

    public B2BucketFileLockConfiguration getFileLockConfiguration() throws B2ForbiddenException {
        B2Preconditions.checkState(this.fileLockConfiguration != null);
        return this.fileLockConfiguration.getValue();
    }

    public boolean isClientAuthorizedToReadDefaultServerSideEncryption() {
        B2Preconditions.checkState(this.defaultServerSideEncryption != null);
        return this.defaultServerSideEncryption.isClientAuthorizedToRead();
    }

    public B2BucketServerSideEncryption getDefaultServerSideEncryption() throws B2ForbiddenException {
        B2Preconditions.checkState(this.defaultServerSideEncryption != null);
        return this.defaultServerSideEncryption.getValue();
    }

    public boolean isClientAuthorizedToReadReplicationConfiguration() {
        B2Preconditions.checkState(this.replicationConfiguration != null);
        return this.replicationConfiguration.isClientAuthorizedToRead();
    }

    public B2BucketReplicationConfiguration getReplicationConfiguration() throws B2ForbiddenException {
        B2Preconditions.checkState(this.replicationConfiguration != null);
        return this.replicationConfiguration.getValue();
    }

    public String toString() {
        return "B2Bucket(" + this.bucketName + "," + this.bucketType + "," + this.bucketId + "," + (this.bucketInfo == null ? 0 : this.bucketInfo.size()) + " infos," + (this.corsRules == null ? 0 : this.corsRules.size()) + " corsRules," + (this.lifecycleRules == null ? 0 : this.lifecycleRules.size()) + " lifecycleRules," + (this.options == null || this.options.isEmpty() ? Integer.valueOf(0) : "[" + String.join((CharSequence)", ", this.options) + "]") + " options," + this.fileLockConfiguration + "," + this.defaultServerSideEncryption + "," + this.replicationConfiguration + ",v" + this.revision + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2Bucket b2Bucket = (B2Bucket)o;
        return this.getRevision() == b2Bucket.getRevision() && Objects.equals(this.getAccountId(), b2Bucket.getAccountId()) && Objects.equals(this.getBucketId(), b2Bucket.getBucketId()) && Objects.equals(this.getBucketName(), b2Bucket.getBucketName()) && Objects.equals(this.getBucketType(), b2Bucket.getBucketType()) && Objects.equals(this.getBucketInfo(), b2Bucket.getBucketInfo()) && Objects.equals(this.getCorsRules(), b2Bucket.getCorsRules()) && Objects.equals(this.getLifecycleRules(), b2Bucket.getLifecycleRules()) && Objects.equals(this.getOptions(), b2Bucket.getOptions()) && Objects.equals(this.fileLockConfiguration, b2Bucket.fileLockConfiguration) && Objects.equals(this.defaultServerSideEncryption, b2Bucket.defaultServerSideEncryption) && Objects.equals(this.replicationConfiguration, b2Bucket.replicationConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.getAccountId(), this.getBucketId(), this.getBucketName(), this.getBucketType(), this.getBucketInfo(), this.getCorsRules(), this.getLifecycleRules(), this.getOptions(), this.getRevision(), this.fileLockConfiguration, this.defaultServerSideEncryption, this.replicationConfiguration);
    }
}

