/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2AuthorizeAccountRequest {
    @B2Json.required
    private final String applicationKeyId;
    @B2Json.required
    private final String applicationKey;

    @B2Json.constructor(params="applicationKeyId,applicationKey")
    public B2AuthorizeAccountRequest(String applicationKeyId, String applicationKey) {
        this.applicationKeyId = applicationKeyId;
        this.applicationKey = applicationKey;
    }

    public static Builder builder(String applicationKeyId, String applicationKey) {
        return new Builder(applicationKeyId, applicationKey);
    }

    public String getApplicationKeyId() {
        return this.applicationKeyId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2AuthorizeAccountRequest that = (B2AuthorizeAccountRequest)o;
        return Objects.equals(this.getApplicationKeyId(), that.getApplicationKeyId()) && Objects.equals(this.getApplicationKey(), that.getApplicationKey());
    }

    public int hashCode() {
        return Objects.hash(this.getApplicationKeyId(), this.getApplicationKey());
    }

    public static class Builder {
        private final String applicationKeyId;
        private final String applicationKey;

        public Builder(String applicationKeyId, String applicationKey) {
            this.applicationKeyId = applicationKeyId;
            this.applicationKey = applicationKey;
        }

        public B2AuthorizeAccountRequest build() {
            return new B2AuthorizeAccountRequest(this.applicationKeyId, this.applicationKey);
        }
    }
}

