/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.contentSources;

import com.backblaze.b2.client.contentSources.B2ContentSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class B2ByteArrayContentSource
implements B2ContentSource {
    private final byte[] source;
    private final String sha1OrNull;
    private final Long srcLastModifiedMillisOrNull;

    private B2ByteArrayContentSource(byte[] source, String sha1OrNull, Long srcLastModifiedMillisOrNull) {
        this.source = source;
        this.sha1OrNull = sha1OrNull;
        this.srcLastModifiedMillisOrNull = srcLastModifiedMillisOrNull;
    }

    public static B2ContentSource build(byte[] bytes) {
        return B2ByteArrayContentSource.builder(bytes).build();
    }

    public static Builder builder(byte[] bytes) {
        return new Builder(bytes);
    }

    @Override
    public String getSha1OrNull() throws IOException {
        return this.sha1OrNull;
    }

    @Override
    public Long getSrcLastModifiedMillisOrNull() throws IOException {
        return this.srcLastModifiedMillisOrNull;
    }

    @Override
    public long getContentLength() throws IOException {
        return this.source.length;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return new ByteArrayInputStream(this.source);
    }

    public static class Builder {
        private final byte[] source;
        private String sha1OrNull;
        private Long srcLastModifiedMillisOrNull;

        public Builder(byte[] source) {
            this.source = source;
        }

        public Builder setSha1OrNull(String sha1OrNull) {
            this.sha1OrNull = sha1OrNull;
            return this;
        }

        public Builder setSrcLastModifiedMillisOrNull(Long srcLastModifiedMillisOrNull) {
            this.srcLastModifiedMillisOrNull = srcLastModifiedMillisOrNull;
            return this;
        }

        public B2ContentSource build() {
            return new B2ByteArrayContentSource(this.source, this.sha1OrNull, this.srcLastModifiedMillisOrNull);
        }
    }
}

