/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2CancellableContentSource;
import com.backblaze.b2.client.B2CancellationToken;
import com.backblaze.b2.client.B2LargeFileStorer;
import com.backblaze.b2.client.B2PartStorer;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2CannotComputeException;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2UploadListener;
import java.io.IOException;
import java.util.Objects;

public class B2UploadingPartStorer
implements B2PartStorer {
    private final int partNumber;
    private final B2ContentSource contentSource;

    public B2UploadingPartStorer(int partNumber, B2ContentSource contentSource) {
        this.partNumber = partNumber;
        this.contentSource = contentSource;
    }

    @Override
    public int getPartNumber() {
        return this.partNumber;
    }

    @Override
    public long getPartSizeOrThrow() throws B2CannotComputeException {
        try {
            return this.contentSource.getContentLength();
        }
        catch (IOException e) {
            throw new B2CannotComputeException("error computing content source's length.");
        }
    }

    @Override
    public B2Part storePart(B2LargeFileStorer largeFileCreationManager, B2UploadListener uploadListener, B2CancellationToken cancellationToken) throws IOException, B2Exception {
        B2CancellableContentSource cancellableContentSource = new B2CancellableContentSource(this.contentSource, cancellationToken);
        return largeFileCreationManager.uploadPart(this.partNumber, cancellableContentSource, uploadListener, cancellationToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2UploadingPartStorer that = (B2UploadingPartStorer)o;
        return this.partNumber == that.partNumber && Objects.equals(this.contentSource, that.contentSource);
    }

    public int hashCode() {
        return Objects.hash(this.partNumber, this.contentSource);
    }
}

