/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizationCache;
import com.backblaze.b2.client.B2BoundedLruMap;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2GetUploadUrlRequest;
import com.backblaze.b2.client.structures.B2UploadUrlResponse;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

class B2UploadUrlCache {
    static final int MAX_BUCKETS = 100;
    private final B2StorageClientWebifier webifier;
    private final B2AccountAuthorizationCache accountAuthCache;
    private final Map<String, Deque<B2UploadUrlResponse>> perBucket;

    B2UploadUrlCache(B2StorageClientWebifier webifier, B2AccountAuthorizationCache accountAuthCache) {
        this.webifier = webifier;
        this.accountAuthCache = accountAuthCache;
        this.perBucket = B2BoundedLruMap.withMax(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    B2UploadUrlResponse get(String bucketId, boolean isRetry) throws B2Exception {
        if (!isRetry) {
            B2UploadUrlCache b2UploadUrlCache = this;
            synchronized (b2UploadUrlCache) {
                B2UploadUrlResponse response;
                Deque<B2UploadUrlResponse> responses = this.perBucket.get(bucketId);
                if (responses != null && (response = responses.pollFirst()) != null) {
                    return response;
                }
            }
        }
        B2GetUploadUrlRequest request = B2GetUploadUrlRequest.builder(bucketId).build();
        return this.webifier.getUploadUrl(this.accountAuthCache.get(), request);
    }

    synchronized void unget(B2UploadUrlResponse response) {
        Deque responses = this.perBucket.computeIfAbsent(response.getBucketId(), k -> new ArrayDeque());
        responses.offerLast(response);
    }
}

