/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2ContentDetailsForUpload;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.contentHandlers.B2ContentSink;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.contentSources.B2Headers;
import com.backblaze.b2.client.contentSources.B2HeadersImpl;
import com.backblaze.b2.client.exceptions.B2BadRequestException;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2UnauthorizedException;
import com.backblaze.b2.client.structures.B2AccountAuthorization;
import com.backblaze.b2.client.structures.B2ApplicationKey;
import com.backblaze.b2.client.structures.B2AuthorizationFilteredResponseField;
import com.backblaze.b2.client.structures.B2AuthorizeAccountRequest;
import com.backblaze.b2.client.structures.B2Bucket;
import com.backblaze.b2.client.structures.B2CancelLargeFileRequest;
import com.backblaze.b2.client.structures.B2CancelLargeFileResponse;
import com.backblaze.b2.client.structures.B2CopyFileRequest;
import com.backblaze.b2.client.structures.B2CopyPartRequest;
import com.backblaze.b2.client.structures.B2CreateBucketRequestReal;
import com.backblaze.b2.client.structures.B2CreateKeyRequestReal;
import com.backblaze.b2.client.structures.B2CreatedApplicationKey;
import com.backblaze.b2.client.structures.B2DeleteBucketRequestReal;
import com.backblaze.b2.client.structures.B2DeleteFileVersionRequest;
import com.backblaze.b2.client.structures.B2DeleteFileVersionResponse;
import com.backblaze.b2.client.structures.B2DeleteKeyRequest;
import com.backblaze.b2.client.structures.B2DownloadAuthorization;
import com.backblaze.b2.client.structures.B2DownloadByIdRequest;
import com.backblaze.b2.client.structures.B2DownloadByNameRequest;
import com.backblaze.b2.client.structures.B2FileRetention;
import com.backblaze.b2.client.structures.B2FileSseForRequest;
import com.backblaze.b2.client.structures.B2FileSseForResponse;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2FinishLargeFileRequest;
import com.backblaze.b2.client.structures.B2GetDownloadAuthorizationRequest;
import com.backblaze.b2.client.structures.B2GetFileInfoByNameRequest;
import com.backblaze.b2.client.structures.B2GetFileInfoRequest;
import com.backblaze.b2.client.structures.B2GetUploadPartUrlRequest;
import com.backblaze.b2.client.structures.B2GetUploadUrlRequest;
import com.backblaze.b2.client.structures.B2HideFileRequest;
import com.backblaze.b2.client.structures.B2ListBucketsRequest;
import com.backblaze.b2.client.structures.B2ListBucketsResponse;
import com.backblaze.b2.client.structures.B2ListFileNamesRequest;
import com.backblaze.b2.client.structures.B2ListFileNamesResponse;
import com.backblaze.b2.client.structures.B2ListFileVersionsRequest;
import com.backblaze.b2.client.structures.B2ListFileVersionsResponse;
import com.backblaze.b2.client.structures.B2ListKeysRequestReal;
import com.backblaze.b2.client.structures.B2ListKeysResponse;
import com.backblaze.b2.client.structures.B2ListPartsRequest;
import com.backblaze.b2.client.structures.B2ListPartsResponse;
import com.backblaze.b2.client.structures.B2ListUnfinishedLargeFilesRequest;
import com.backblaze.b2.client.structures.B2ListUnfinishedLargeFilesResponse;
import com.backblaze.b2.client.structures.B2OverrideableHeaders;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2StartLargeFileRequest;
import com.backblaze.b2.client.structures.B2TestMode;
import com.backblaze.b2.client.structures.B2UpdateBucketRequest;
import com.backblaze.b2.client.structures.B2UpdateFileLegalHoldRequest;
import com.backblaze.b2.client.structures.B2UpdateFileLegalHoldResponse;
import com.backblaze.b2.client.structures.B2UpdateFileRetentionRequest;
import com.backblaze.b2.client.structures.B2UpdateFileRetentionResponse;
import com.backblaze.b2.client.structures.B2UploadFileRequest;
import com.backblaze.b2.client.structures.B2UploadPartRequest;
import com.backblaze.b2.client.structures.B2UploadPartUrlResponse;
import com.backblaze.b2.client.structures.B2UploadUrlResponse;
import com.backblaze.b2.client.webApiClients.B2WebApiClient;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2ByteRange;
import com.backblaze.b2.util.B2Preconditions;
import com.backblaze.b2.util.B2StringUtil;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class B2StorageClientWebifierImpl
implements B2StorageClientWebifier {
    private static String API_VERSION_PATH = "b2api/v2/";
    private final B2WebApiClient webApiClient;
    private final String userAgent;
    private final Base64.Encoder base64Encoder = Base64.getEncoder();
    private final String masterUrl;
    private final B2TestMode testModeOrNull;

    public B2StorageClientWebifierImpl(B2WebApiClient webApiClient, String userAgent, String masterUrl, B2TestMode testModeOrNull) {
        B2StorageClientWebifierImpl.throwIfBadUserAgent(userAgent);
        this.webApiClient = webApiClient;
        this.userAgent = userAgent;
        this.masterUrl = masterUrl.endsWith("/") ? masterUrl : masterUrl + "/";
        this.testModeOrNull = testModeOrNull;
    }

    String getMasterUrl() {
        return this.masterUrl;
    }

    private static void throwIfBadUserAgent(String userAgent) {
        userAgent.chars().forEach(c -> B2Preconditions.checkArgument(c >= 32, "control character in user-agent!"));
    }

    @Override
    public void close() {
        this.webApiClient.close();
    }

    @Override
    public B2AccountAuthorization authorizeAccount(B2AuthorizeAccountRequest request) throws B2Exception {
        B2HeadersImpl.Builder headersBuilder = B2HeadersImpl.builder().set("Authorization", this.makeAuthorizationValue(request));
        this.setCommonHeaders(headersBuilder);
        B2HeadersImpl headers = headersBuilder.build();
        String url = this.masterUrl + API_VERSION_PATH + "b2_authorize_account";
        try {
            return this.webApiClient.postJsonReturnJson(url, headers, new Empty(), B2AccountAuthorization.class);
        }
        catch (B2UnauthorizedException e) {
            e.setRequestCategory(B2UnauthorizedException.RequestCategory.ACCOUNT_AUTHORIZATION);
            throw e;
        }
    }

    private String makeAuthorizationValue(B2AuthorizeAccountRequest request) {
        String value = request.getApplicationKeyId() + ":" + request.getApplicationKey();
        return "Basic " + this.base64Encoder.encodeToString(B2StringUtil.getUtf8Bytes(value));
    }

    @Override
    public B2Bucket createBucket(B2AccountAuthorization accountAuth, B2CreateBucketRequestReal request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_create_bucket"), this.makeHeaders(accountAuth), request, B2Bucket.class);
    }

    @Override
    public B2CreatedApplicationKey createKey(B2AccountAuthorization accountAuth, B2CreateKeyRequestReal request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_create_key"), this.makeHeaders(accountAuth), request, B2CreatedApplicationKey.class);
    }

    @Override
    public B2ListKeysResponse listKeys(B2AccountAuthorization accountAuth, B2ListKeysRequestReal request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_list_keys"), this.makeHeaders(accountAuth), request, B2ListKeysResponse.class);
    }

    @Override
    public B2ApplicationKey deleteKey(B2AccountAuthorization accountAuth, B2DeleteKeyRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_delete_key"), this.makeHeaders(accountAuth), request, B2ApplicationKey.class);
    }

    @Override
    public B2ListBucketsResponse listBuckets(B2AccountAuthorization accountAuth, B2ListBucketsRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_list_buckets"), this.makeHeaders(accountAuth), request, B2ListBucketsResponse.class);
    }

    @Override
    public B2UploadUrlResponse getUploadUrl(B2AccountAuthorization accountAuth, B2GetUploadUrlRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_get_upload_url"), this.makeHeaders(accountAuth), request, B2UploadUrlResponse.class);
    }

    @Override
    public B2UploadPartUrlResponse getUploadPartUrl(B2AccountAuthorization accountAuth, B2GetUploadPartUrlRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_get_upload_part_url"), this.makeHeaders(accountAuth), request, B2UploadPartUrlResponse.class);
    }

    /*
     * Exception decompiling
     */
    @Override
    public B2FileVersion uploadFile(B2UploadUrlResponse uploadUrlResponse, B2UploadFileRequest request) throws B2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public B2FileVersion copyFile(B2AccountAuthorization accountAuth, B2CopyFileRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_copy_file"), this.makeHeaders(accountAuth), request, B2FileVersion.class);
    }

    @Override
    public B2Part uploadPart(B2UploadPartUrlResponse uploadPartUrlResponse, B2UploadPartRequest request) throws B2Exception {
        B2ContentSource source = request.getContentSource();
        try (B2ContentDetailsForUpload contentDetails = new B2ContentDetailsForUpload(source);){
            B2HeadersImpl.Builder headersBuilder = B2HeadersImpl.builder().set("Expect", "100-continue").set("Authorization", uploadPartUrlResponse.getAuthorizationToken()).set("X-Bz-Part-Number", Integer.toString(request.getPartNumber())).set("X-Bz-Content-Sha1", contentDetails.getContentSha1HeaderValue());
            this.setCommonHeaders(headersBuilder);
            if (request.getServerSideEncryption() != null) {
                B2Preconditions.checkArgument(request.getServerSideEncryption().getMode().equals("SSE-C"));
                headersBuilder.set("X-Bz-Server-Side-Encryption-Customer-Algorithm", request.getServerSideEncryption().getAlgorithm());
                headersBuilder.set("X-Bz-Server-Side-Encryption-Customer-Key", request.getServerSideEncryption().getCustomerKey());
                headersBuilder.set("X-Bz-Server-Side-Encryption-Customer-Key-Md5", request.getServerSideEncryption().getCustomerKeyMd5());
            }
            try {
                B2Part b2Part = this.webApiClient.postDataReturnJson(uploadPartUrlResponse.getUploadUrl(), headersBuilder.build(), contentDetails.getInputStream(), contentDetails.getContentLength(), B2Part.class);
                return b2Part;
            }
            catch (B2UnauthorizedException e) {
                e.setRequestCategory(B2UnauthorizedException.RequestCategory.UPLOADING);
                throw e;
            }
        }
    }

    @Override
    public B2Part copyPart(B2AccountAuthorization accountAuth, B2CopyPartRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_copy_part"), this.makeHeaders(accountAuth), request, B2Part.class);
    }

    @Override
    public B2ListFileVersionsResponse listFileVersions(B2AccountAuthorization accountAuth, B2ListFileVersionsRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_list_file_versions"), this.makeHeaders(accountAuth), request, B2ListFileVersionsResponse.class);
    }

    @Override
    public B2ListFileNamesResponse listFileNames(B2AccountAuthorization accountAuth, B2ListFileNamesRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_list_file_names"), this.makeHeaders(accountAuth), request, B2ListFileNamesResponse.class);
    }

    @Override
    public B2ListUnfinishedLargeFilesResponse listUnfinishedLargeFiles(B2AccountAuthorization accountAuth, B2ListUnfinishedLargeFilesRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_list_unfinished_large_files"), this.makeHeaders(accountAuth), request, B2ListUnfinishedLargeFilesResponse.class);
    }

    @Override
    public B2FileVersion startLargeFile(B2AccountAuthorization accountAuth, B2StartLargeFileRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_start_large_file"), this.makeHeaders(accountAuth), request, B2FileVersion.class);
    }

    @Override
    public B2FileVersion finishLargeFile(B2AccountAuthorization accountAuth, B2FinishLargeFileRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_finish_large_file"), this.makeHeaders(accountAuth), request, B2FileVersion.class);
    }

    @Override
    public B2ListPartsResponse listParts(B2AccountAuthorization accountAuth, B2ListPartsRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_list_parts"), this.makeHeaders(accountAuth), request, B2ListPartsResponse.class);
    }

    @Override
    public B2CancelLargeFileResponse cancelLargeFile(B2AccountAuthorization accountAuth, B2CancelLargeFileRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_cancel_large_file"), this.makeHeaders(accountAuth), request, B2CancelLargeFileResponse.class);
    }

    @Override
    public void downloadById(B2AccountAuthorization accountAuth, B2DownloadByIdRequest request, B2ContentSink handler) throws B2Exception {
        this.downloadGuts(accountAuth, this.makeDownloadByIdUrl(accountAuth, request), request.getRange(), request.getServerSideEncryption(), handler);
    }

    @Override
    public String getDownloadByIdUrl(B2AccountAuthorization accountAuth, B2DownloadByIdRequest request) {
        return this.makeDownloadByIdUrl(accountAuth, request);
    }

    @Override
    public void downloadByName(B2AccountAuthorization accountAuth, B2DownloadByNameRequest request, B2ContentSink handler) throws B2Exception {
        this.downloadGuts(accountAuth, this.makeDownloadByNameUrl(accountAuth, request.getBucketName(), request.getFileName(), request), request.getRange(), request.getServerSideEncryption(), handler);
    }

    @Override
    public String getDownloadByNameUrl(B2AccountAuthorization accountAuth, B2DownloadByNameRequest request) {
        return this.makeDownloadByNameUrl(accountAuth, request.getBucketName(), request.getFileName(), request);
    }

    private void downloadGuts(B2AccountAuthorization accountAuth, String url, B2ByteRange rangeOrNull, B2FileSseForRequest serverSideEncryptionOrNull, B2ContentSink handler) throws B2Exception {
        TreeMap<String, String> extras = new TreeMap<String, String>();
        if (rangeOrNull != null) {
            extras.put("Range", rangeOrNull.toString());
        }
        if (serverSideEncryptionOrNull != null) {
            B2Preconditions.checkArgument(serverSideEncryptionOrNull.getMode().equals("SSE-C"));
            extras.put("X-Bz-Server-Side-Encryption-Customer-Algorithm", serverSideEncryptionOrNull.getAlgorithm());
            extras.put("X-Bz-Server-Side-Encryption-Customer-Key", serverSideEncryptionOrNull.getCustomerKey());
            extras.put("X-Bz-Server-Side-Encryption-Customer-Key-Md5", serverSideEncryptionOrNull.getCustomerKeyMd5());
        }
        this.webApiClient.getContent(url, this.makeHeaders(accountAuth, extras), handler);
    }

    @Override
    public B2DeleteFileVersionResponse deleteFileVersion(B2AccountAuthorization accountAuth, B2DeleteFileVersionRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_delete_file_version"), this.makeHeaders(accountAuth), request, B2DeleteFileVersionResponse.class);
    }

    @Override
    public B2DownloadAuthorization getDownloadAuthorization(B2AccountAuthorization accountAuth, B2GetDownloadAuthorizationRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_get_download_authorization"), this.makeHeaders(accountAuth), request, B2DownloadAuthorization.class);
    }

    @Override
    public B2FileVersion getFileInfo(B2AccountAuthorization accountAuth, B2GetFileInfoRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_get_file_info"), this.makeHeaders(accountAuth), request, B2FileVersion.class);
    }

    @Override
    public B2FileVersion getFileInfoByName(B2AccountAuthorization accountAuth, B2GetFileInfoByNameRequest request) throws B2Exception {
        TreeMap<String, String> extras = new TreeMap<String, String>();
        if (request.getServerSideEncryption() != null) {
            B2Preconditions.checkArgument(request.getServerSideEncryption().getMode().equals("SSE-C"));
            extras.put("X-Bz-Server-Side-Encryption-Customer-Algorithm", request.getServerSideEncryption().getAlgorithm());
            extras.put("X-Bz-Server-Side-Encryption-Customer-Key", request.getServerSideEncryption().getCustomerKey());
            extras.put("X-Bz-Server-Side-Encryption-Customer-Key-Md5", request.getServerSideEncryption().getCustomerKeyMd5());
        }
        B2Headers headers = this.webApiClient.head(this.makeGetFileInfoByNameUrl(accountAuth, request.getBucketName(), request.getFileName()), this.makeHeaders(accountAuth, extras));
        B2FileRetention b2FileRetentionOrNull = B2FileRetention.getFileRetentionFromHeadersOrNull(headers);
        String legalHoldOrNull = headers.getFileLegalHoldOrNull();
        List<String> capabilities = accountAuth.getAllowed().getCapabilities();
        B2AuthorizationFilteredResponseField<B2FileRetention> fileRetention = capabilities.contains("readFileRetentions") ? new B2AuthorizationFilteredResponseField<B2FileRetention>(true, b2FileRetentionOrNull) : new B2AuthorizationFilteredResponseField<Object>(false, null);
        B2AuthorizationFilteredResponseField<String> legalHold = capabilities.contains("readFileLegalHolds") ? new B2AuthorizationFilteredResponseField<String>(true, legalHoldOrNull) : new B2AuthorizationFilteredResponseField<Object>(false, null);
        return new B2FileVersion(headers.getValueOrNull("X-Bz-File-Id"), headers.getFileNameOrNull(), headers.getContentLength(), headers.getContentType(), headers.getContentSha1OrNull(), headers.getContentMd5OrNull(), headers.getB2FileInfo(), "upload", headers.getUploadTimestampOrNull(), fileRetention, legalHold, B2FileSseForResponse.getEncryptionFromHeadersOrNull(headers), null);
    }

    @Override
    public B2FileVersion hideFile(B2AccountAuthorization accountAuth, B2HideFileRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_hide_file"), this.makeHeaders(accountAuth), request, B2FileVersion.class);
    }

    @Override
    public B2Bucket updateBucket(B2AccountAuthorization accountAuth, B2UpdateBucketRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_update_bucket"), this.makeHeaders(accountAuth), request, B2Bucket.class);
    }

    @Override
    public B2Bucket deleteBucket(B2AccountAuthorization accountAuth, B2DeleteBucketRequestReal request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_delete_bucket"), this.makeHeaders(accountAuth), request, B2Bucket.class);
    }

    @Override
    public B2UpdateFileLegalHoldResponse updateFileLegalHold(B2AccountAuthorization accountAuth, B2UpdateFileLegalHoldRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_update_file_legal_hold"), this.makeHeaders(accountAuth), request, B2UpdateFileLegalHoldResponse.class);
    }

    @Override
    public B2UpdateFileRetentionResponse updateFileRetention(B2AccountAuthorization accountAuth, B2UpdateFileRetentionRequest request) throws B2Exception {
        return this.webApiClient.postJsonReturnJson(this.makeUrl(accountAuth, "b2_update_file_retention"), this.makeHeaders(accountAuth), request, B2UpdateFileRetentionResponse.class);
    }

    private void addAuthHeader(B2HeadersImpl.Builder builder, B2AccountAuthorization accountAuth) {
        builder.set("Authorization", accountAuth.getAuthorizationToken());
    }

    private B2Headers makeHeaders(B2AccountAuthorization accountAuth) {
        return this.makeHeaders(accountAuth, null);
    }

    private B2Headers makeHeaders(B2AccountAuthorization accountAuth, Map<String, String> extrasPairsOrNull) {
        B2HeadersImpl.Builder builder = B2HeadersImpl.builder();
        this.addAuthHeader(builder, accountAuth);
        if (extrasPairsOrNull != null) {
            extrasPairsOrNull.forEach(builder::set);
        }
        this.setCommonHeaders(builder);
        return builder.build();
    }

    private void setCommonHeaders(B2HeadersImpl.Builder builder) {
        builder.set("User-Agent", this.userAgent);
        if (this.testModeOrNull != null) {
            builder.set("X-Bz-Test-Mode", this.testModeOrNull.getValueForHeader());
        }
    }

    private String makeUrl(B2AccountAuthorization accountAuth, String apiName) {
        String url = accountAuth.getApiUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + API_VERSION_PATH;
        url = url + apiName;
        return url;
    }

    private String makeDownloadByIdUrl(B2AccountAuthorization accountAuth, B2DownloadByIdRequest request) {
        B2Preconditions.checkArgumentIsNotNull(request, "request");
        String downloadUrl = accountAuth.getDownloadUrl();
        StringBuilder uriBuilder = new StringBuilder(downloadUrl);
        if (!downloadUrl.endsWith("/")) {
            uriBuilder.append("/");
        }
        uriBuilder.append(API_VERSION_PATH).append("b2_download_file_by_id?fileId=").append(request.getFileId());
        this.maybeAddOverrideHeadersToUrl(uriBuilder, 1, request);
        return uriBuilder.toString();
    }

    private String makeGetFileInfoByNameUrl(B2AccountAuthorization accountAuth, String bucketName, String fileName) {
        return this.makeDownloadByNameUrl(accountAuth, bucketName, fileName, null);
    }

    private String makeDownloadByNameUrl(B2AccountAuthorization accountAuth, String bucketName, String fileName, B2DownloadByNameRequest request) {
        String downloadUrl = accountAuth.getDownloadUrl();
        StringBuilder uriBuilder = new StringBuilder(downloadUrl);
        if (!downloadUrl.endsWith("/")) {
            uriBuilder.append("/");
        }
        uriBuilder.append("file/").append(bucketName).append("/").append(B2StringUtil.percentEncode(fileName));
        if (request != null) {
            this.maybeAddOverrideHeadersToUrl(uriBuilder, 0, request);
        }
        return uriBuilder.toString();
    }

    private int maybeAddOverrideHeadersToUrl(StringBuilder uriBuilder, int countOfQueryParameters, B2OverrideableHeaders overrideableHeaders) {
        countOfQueryParameters = this.maybeAddQueryParamToUrl(uriBuilder, countOfQueryParameters, "b2ContentDisposition", overrideableHeaders.getB2ContentDisposition());
        countOfQueryParameters = this.maybeAddQueryParamToUrl(uriBuilder, countOfQueryParameters, "b2ContentLanguage", overrideableHeaders.getB2ContentLanguage());
        countOfQueryParameters = this.maybeAddQueryParamToUrl(uriBuilder, countOfQueryParameters, "b2Expires", overrideableHeaders.getB2Expires());
        countOfQueryParameters = this.maybeAddQueryParamToUrl(uriBuilder, countOfQueryParameters, "b2CacheControl", overrideableHeaders.getB2CacheControl());
        countOfQueryParameters = this.maybeAddQueryParamToUrl(uriBuilder, countOfQueryParameters, "b2ContentEncoding", overrideableHeaders.getB2ContentEncoding());
        countOfQueryParameters = this.maybeAddQueryParamToUrl(uriBuilder, countOfQueryParameters, "b2ContentType", overrideableHeaders.getB2ContentType());
        return countOfQueryParameters;
    }

    private int maybeAddQueryParamToUrl(StringBuilder uriBuilder, int countOfQueryParameters, String argName, String argValue) {
        if (argValue != null) {
            char separator = countOfQueryParameters == 0 ? (char)'?' : '&';
            uriBuilder.append(separator).append(argName).append('=').append(B2StringUtil.percentEncode(argValue));
            return countOfQueryParameters + 1;
        }
        return countOfQueryParameters;
    }

    void validateFileInfoName(String name) throws B2BadRequestException {
        for (int i = 0; i < name.length(); ++i) {
            if (this.isLegalInfoNameCharacter(name.charAt(i))) continue;
            throw new B2BadRequestException("bad_request", null, "Illegal file info name: " + name);
        }
    }

    private boolean isLegalInfoNameCharacter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_' || c == '.' || c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c == '\'' || c == '*' || c == '+' || c == '^' || c == '`' || c == '|' || c == '~';
    }

    private static class Empty {
        @B2Json.constructor(params="")
        Empty() {
        }
    }
}

