/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.util.B2Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class B2Sdk {
    private static String version;

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readVersion() {
        try (InputStream in = B2Sdk.class.getClassLoader().getResourceAsStream("b2-sdk-core/version.txt");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                String version = reader.readLine().trim();
                B2Preconditions.checkState(!version.isEmpty());
                string = version;
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read sdk version: " + e, e);
        }
    }

    public static String getName() {
        return "b2-sdk-java";
    }

    public static synchronized String getVersion() {
        if (version == null) {
            version = B2Sdk.readVersion();
        }
        return version;
    }
}

