/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import java.util.Comparator;
import java.util.Objects;

public class B2PartSpec
implements Comparable<B2PartSpec> {
    private static Comparator<B2PartSpec> comparator = Comparator.comparingInt(B2PartSpec::getPartNumber).thenComparing(Comparator.comparingLong(B2PartSpec::getStart)).thenComparing(Comparator.comparingLong(B2PartSpec::getLength));
    final int partNumber;
    final long start;
    final long length;

    B2PartSpec(int partNumber, long start, long length) {
        this.partNumber = partNumber;
        this.start = start;
        this.length = length;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return "B2PartSpec{#" + this.partNumber + ", start=" + this.start + ", pastEnd=" + (this.start + this.length) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2PartSpec partSpec = (B2PartSpec)o;
        return this.partNumber == partSpec.partNumber && this.start == partSpec.start && this.length == partSpec.length;
    }

    public int hashCode() {
        return Objects.hash(this.partNumber, this.start, this.length);
    }

    @Override
    public int compareTo(B2PartSpec o) {
        return comparator.compare(this, o);
    }
}

