/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2ListPartsIterableBase;
import com.backblaze.b2.client.B2StorageClientImpl;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2ListPartsRequest;
import com.backblaze.b2.client.structures.B2ListPartsResponse;
import com.backblaze.b2.client.structures.B2Part;
import java.util.Iterator;

public class B2ListPartsIterableImpl
extends B2ListPartsIterableBase {
    private final B2ListPartsRequest request;

    public B2ListPartsIterableImpl(B2StorageClientImpl b2Client, B2ListPartsRequest request) {
        super(b2Client);
        this.request = request;
    }

    @Override
    Iterator<B2Part> createIter() throws B2Exception {
        return new Iter();
    }

    private class Iter
    extends B2ListPartsIterableBase.IterBase {
        private B2ListPartsResponse currentResponse;

        Iter() throws B2Exception {
            super(B2ListPartsIterableImpl.this);
        }

        @Override
        protected void advance() throws B2Exception {
            B2ListPartsRequest.Builder builder = B2ListPartsRequest.builder(B2ListPartsIterableImpl.this.request);
            if (this.currentResponse != null) {
                builder.setStartPartNumber(this.currentResponse.getNextPartNumber());
            }
            this.currentResponse = B2ListPartsIterableImpl.this.getClient().listParts(builder.build());
        }

        @Override
        protected B2ListPartsResponse getCurrentResponseOrNull() {
            return this.currentResponse;
        }
    }
}

