/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2CancellationToken;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import java.io.IOException;
import java.io.InputStream;

public class B2CancellableContentSource
implements B2ContentSource {
    private final B2ContentSource source;
    private final B2CancellationToken cancellationToken;

    public B2CancellableContentSource(B2ContentSource source, B2CancellationToken cancellationToken) {
        this.source = source;
        this.cancellationToken = cancellationToken;
    }

    @Override
    public long getContentLength() throws IOException {
        return this.source.getContentLength();
    }

    @Override
    public String getSha1OrNull() throws IOException {
        return this.source.getSha1OrNull();
    }

    @Override
    public Long getSrcLastModifiedMillisOrNull() throws IOException {
        return this.source.getSrcLastModifiedMillisOrNull();
    }

    @Override
    public InputStream createInputStream() throws IOException, B2Exception {
        return new CancellableInputStream(this.source.createInputStream(), this.cancellationToken);
    }

    private static class CancellableInputStream
    extends InputStream {
        private final InputStream source;
        private final B2CancellationToken cancellationToken;

        public CancellableInputStream(InputStream source, B2CancellationToken cancellationToken) {
            this.source = source;
            this.cancellationToken = cancellationToken;
        }

        private void throwIfCancelled() throws IOException {
            if (this.cancellationToken.isCancelled()) {
                throw new IOException("Request was cancelled by caller");
            }
        }

        @Override
        public int read() throws IOException {
            this.throwIfCancelled();
            return this.source.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.throwIfCancelled();
            return this.source.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.throwIfCancelled();
            return this.source.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.throwIfCancelled();
            return this.source.skip(n);
        }

        @Override
        public int available() throws IOException {
            this.throwIfCancelled();
            return this.source.available();
        }

        @Override
        public void close() throws IOException {
            this.throwIfCancelled();
            this.source.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.source.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.throwIfCancelled();
            this.source.reset();
        }

        @Override
        public boolean markSupported() {
            return this.source.markSupported();
        }
    }
}

