/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.PipelineRunSourceProperties;
import com.azure.resourcemanager.containerregistry.models.PipelineRunTargetProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class PipelineRunRequest {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PipelineRunRequest.class);
    @JsonProperty(value="pipelineResourceId")
    private String pipelineResourceId;
    @JsonProperty(value="artifacts")
    private List<String> artifacts;
    @JsonProperty(value="source")
    private PipelineRunSourceProperties source;
    @JsonProperty(value="target")
    private PipelineRunTargetProperties target;
    @JsonProperty(value="catalogDigest")
    private String catalogDigest;

    public String pipelineResourceId() {
        return this.pipelineResourceId;
    }

    public PipelineRunRequest withPipelineResourceId(String pipelineResourceId) {
        this.pipelineResourceId = pipelineResourceId;
        return this;
    }

    public List<String> artifacts() {
        return this.artifacts;
    }

    public PipelineRunRequest withArtifacts(List<String> artifacts) {
        this.artifacts = artifacts;
        return this;
    }

    public PipelineRunSourceProperties source() {
        return this.source;
    }

    public PipelineRunRequest withSource(PipelineRunSourceProperties source) {
        this.source = source;
        return this;
    }

    public PipelineRunTargetProperties target() {
        return this.target;
    }

    public PipelineRunRequest withTarget(PipelineRunTargetProperties target) {
        this.target = target;
        return this;
    }

    public String catalogDigest() {
        return this.catalogDigest;
    }

    public PipelineRunRequest withCatalogDigest(String catalogDigest) {
        this.catalogDigest = catalogDigest;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.target() != null) {
            this.target().validate();
        }
    }
}

