/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.ssh.transport.keyformat;

import com.jscape.inet.ssh.transport.keyformat.KeyFormat;
import com.jscape.inet.ssh.transport.keyformat.KeyFormatException;
import com.jscape.inet.ssh.types.SshMpint;
import com.jscape.inet.ssh.types.SshString;
import com.jscape.util.i;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;

public class RSAKeyFormat
extends KeyFormat {
    public static final String ALGORITHM;
    public static final String JAVA_ALGORITHM;
    private static final String c;
    private static final String[] z;

    public RSAKeyFormat() {
        super(ALGORITHM);
    }

    public PublicKey getKeyFrom(byte[] byArray) throws KeyFormatException {
        i.a(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            String string = new String(SshString.readValue(byteArrayInputStream), z[0]);
            i.a(string.equals(ALGORITHM), z[1]);
            BigInteger bigInteger = SshMpint.readBigIntegerFrom(byteArrayInputStream);
            BigInteger bigInteger2 = SshMpint.readBigIntegerFrom(byteArrayInputStream);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            return KeyFactory.getInstance(JAVA_ALGORITHM).generatePublic(rSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new KeyFormatException(exception);
        }
    }

    public byte[] format(PublicKey publicKey) throws KeyFormatException {
        i.a(publicKey instanceof RSAPublicKey, z[2]);
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            SshString.writeValue(ALGORITHM.getBytes(z[0]), byteArrayOutputStream);
            SshMpint.writeBigIntegerTo(rSAPublicKey.getPublicExponent(), byteArrayOutputStream);
            SshMpint.writeBigIntegerTo(rSAPublicKey.getModulus(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new KeyFormatException(exception);
        }
    }

    public byte[] getSignatureFrom(byte[] byArray) throws KeyFormatException {
        i.a(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            String string = new String(SshString.readValue(byteArrayInputStream), z[0]);
            i.a(string.equals(ALGORITHM), z[1]);
            return SshString.readValue(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new KeyFormatException(exception);
        }
    }

    public byte[] sign(byte[] byArray, PrivateKey privateKey) throws KeyFormatException {
        i.a(byArray);
        i.a(privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Signature signature = Signature.getInstance(c);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            SshString.writeValue(ALGORITHM.getBytes(z[0]), byteArrayOutputStream);
            SshString.writeValue(byArray2, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new KeyFormatException(exception);
        }
    }

    public void verifySignature(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws KeyFormatException {
        try {
            Signature signature = Signature.getInstance(c);
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray)) {
                throw new KeyFormatException(z[3]);
            }
        }
        catch (Exception exception) {
            throw new KeyFormatException(exception);
        }
    }

    public KeyPair generateKeyPair() throws KeyFormatException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(JAVA_ALGORITHM);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            throw new KeyFormatException(exception);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block69: {
            int n2;
            int n3;
            block68: {
                char[] cArray2;
                Object var0;
                block67: {
                    int n4;
                    block66: {
                        char[] cArray3;
                        block65: {
                            int n5;
                            block64: {
                                char[] cArray4;
                                block63: {
                                    int n6;
                                    block62: {
                                        char[] cArray5;
                                        block61: {
                                            int n7;
                                            block60: {
                                                char[] cArray6;
                                                block59: {
                                                    int n8;
                                                    block58: {
                                                        char[] cArray7;
                                                        block57: {
                                                            int n9;
                                                            block56: {
                                                                stringArray = new String[4];
                                                                var0 = null;
                                                                char[] cArray8 = "\u0003):+\u007f\u0003;".toCharArray();
                                                                cArray7 = cArray8;
                                                                n9 = cArray8.length;
                                                                n3 = 0;
                                                                if (!true) break block56;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block57;
                                                            }
                                                            do {
                                                                int n10;
                                                                cArray7 = cArray7;
                                                                int n11 = n3;
                                                                char c2 = cArray7[n11];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n10 = 112;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n10 = 90;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n10 = 82;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n10 = 6;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n10 = 13;
                                                                    }
                                                                }
                                                                cArray7[n11] = (char)(c2 ^ n10);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        ALGORITHM = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray9 = "\"\t\u0013".toCharArray();
                                                        cArray6 = cArray9;
                                                        n8 = cArray9.length;
                                                        n3 = 0;
                                                        if (!true) break block58;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block59;
                                                    }
                                                    do {
                                                        int n12;
                                                        cArray6 = cArray6;
                                                        int n13 = n3;
                                                        char c3 = cArray6[n13];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n12 = 112;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n12 = 90;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n12 = 82;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n12 = 6;
                                                                break;
                                                            }
                                                            default: {
                                                                n12 = 13;
                                                            }
                                                        }
                                                        cArray6[n13] = (char)(c3 ^ n12);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                JAVA_ALGORITHM = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray10 = "#\u0012\u00137z\u0019.:T^1".toCharArray();
                                                cArray5 = cArray10;
                                                n7 = cArray10.length;
                                                n3 = 0;
                                                if (!true) break block60;
                                                n7 = n7;
                                                if (n7 <= n3) break block61;
                                            }
                                            do {
                                                int n14;
                                                cArray5 = cArray5;
                                                int n15 = n3;
                                                char c4 = cArray5[n15];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n14 = 112;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n14 = 90;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n14 = 82;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n14 = 6;
                                                        break;
                                                    }
                                                    default: {
                                                        n14 = 13;
                                                    }
                                                }
                                                cArray5[n15] = (char)(c4 ^ n14);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        c = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray11 = "%\t\u007fG^3\u0013\u001b".toCharArray();
                                        cArray4 = cArray11;
                                        n6 = cArray11.length;
                                        n3 = 0;
                                        if (!true) break block62;
                                        n6 = n6;
                                        if (n6 <= n3) break block63;
                                    }
                                    do {
                                        int n16;
                                        cArray4 = cArray4;
                                        int n17 = n3;
                                        char c5 = cArray4[n17];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n16 = 112;
                                                break;
                                            }
                                            case 1: {
                                                n16 = 90;
                                                break;
                                            }
                                            case 2: {
                                                n16 = 82;
                                                break;
                                            }
                                            case 3: {
                                                n16 = 6;
                                                break;
                                            }
                                            default: {
                                                n16 = 13;
                                            }
                                        }
                                        cArray4[n17] = (char)(c5 ^ n16);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[0] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray12 = "\u0012;6&f\u0015#rbl\u0004;".toCharArray();
                                cArray3 = cArray12;
                                n5 = cArray12.length;
                                n3 = 0;
                                if (!true) break block64;
                                n5 = n5;
                                if (n5 <= n3) break block65;
                            }
                            do {
                                int n18;
                                cArray3 = cArray3;
                                int n19 = n3;
                                char c6 = cArray3[n19];
                                switch (n3 % 5) {
                                    case 0: {
                                        n18 = 112;
                                        break;
                                    }
                                    case 1: {
                                        n18 = 90;
                                        break;
                                    }
                                    case 2: {
                                        n18 = 82;
                                        break;
                                    }
                                    case 3: {
                                        n18 = 6;
                                        break;
                                    }
                                    default: {
                                        n18 = 13;
                                    }
                                }
                                cArray3[n19] = (char)(c6 ^ n18);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[1] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray13 = "\u0012;6&f\u0015#".toCharArray();
                        cArray2 = cArray13;
                        n4 = cArray13.length;
                        n3 = 0;
                        if (!true) break block66;
                        n4 = n4;
                        if (n4 <= n3) break block67;
                    }
                    do {
                        int n20;
                        cArray2 = cArray2;
                        int n21 = n3;
                        char c7 = cArray2[n21];
                        switch (n3 % 5) {
                            case 0: {
                                n20 = 112;
                                break;
                            }
                            case 1: {
                                n20 = 90;
                                break;
                            }
                            case 2: {
                                n20 = 82;
                                break;
                            }
                            case 3: {
                                n20 = 6;
                                break;
                            }
                            default: {
                                n20 = 13;
                            }
                        }
                        cArray2[n21] = (char)(c7 ^ n20);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[2] = new String(cArray2).intern();
                var0 = null;
                char[] cArray14 = "\u0012;6&~\u0019=<gy\u0005(7".toCharArray();
                cArray = cArray14;
                n2 = cArray14.length;
                n3 = 0;
                if (!true) break block68;
                n2 = n2;
                if (n2 <= n3) break block69;
            }
            do {
                int n22;
                cArray = cArray;
                int n23 = n3;
                char c8 = cArray[n23];
                switch (n3 % 5) {
                    case 0: {
                        n22 = 112;
                        break;
                    }
                    case 1: {
                        n22 = 90;
                        break;
                    }
                    case 2: {
                        n22 = 82;
                        break;
                    }
                    case 3: {
                        n22 = 6;
                        break;
                    }
                    default: {
                        n22 = 13;
                    }
                }
                cArray[n23] = (char)(c8 ^ n22);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
    }
}

