/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.ssh.transport;

import com.jscape.inet.ssh.transport.AlgorithmFactory;
import com.jscape.inet.ssh.transport.AlgorithmSuite;
import com.jscape.inet.ssh.transport.KeyCreator;
import com.jscape.inet.ssh.transport.Message;
import com.jscape.inet.ssh.transport.MessageReader;
import com.jscape.inet.ssh.transport.MessageWriter;
import com.jscape.inet.ssh.transport.ProtocolVersion;
import com.jscape.inet.ssh.transport.SshLogger;
import com.jscape.inet.ssh.transport.Transport$KexDispatcher;
import com.jscape.inet.ssh.transport.Transport$TransportDispatcher;
import com.jscape.inet.ssh.transport.TransportConfiguration;
import com.jscape.inet.ssh.transport.TransportException;
import com.jscape.inet.ssh.transport.compression.CompressionException;
import com.jscape.inet.ssh.transport.compression.NullCompression;
import com.jscape.inet.ssh.transport.mac.MacException;
import com.jscape.inet.ssh.transport.mac.NullMac;
import com.jscape.inet.ssh.transport.messages.SshMsgDebug;
import com.jscape.inet.ssh.transport.messages.SshMsgDisconnect;
import com.jscape.inet.ssh.transport.messages.SshMsgIgnore;
import com.jscape.inet.ssh.transport.messages.SshMsgKexInit;
import com.jscape.inet.ssh.transport.messages.SshMsgNewKeys;
import com.jscape.inet.ssh.transport.messages.SshMsgServiceAccept;
import com.jscape.inet.ssh.transport.messages.SshMsgServiceRequest;
import com.jscape.inet.ssh.transport.messages.SshMsgUnimplemented;
import com.jscape.inet.ssh.util.HostKeyVerifier;
import com.jscape.util.i;
import java.io.IOException;
import java.net.Socket;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NullCipher;

public abstract class Transport {
    protected long initTimeout;
    protected final ProtocolVersion localVersion;
    protected ProtocolVersion remoteVersion;
    protected final Socket socket;
    protected final MessageReader reader;
    protected final MessageWriter writer;
    protected volatile byte[] sessionId;
    protected Transport$TransportDispatcher dispatcher = new Transport$TransportDispatcher(this);
    protected final SshLogger logger;
    protected volatile boolean closed = false;
    protected final AlgorithmFactory factory;
    protected AlgorithmSuite currentSuite;
    protected HostKeyVerifier hostKeyVerifier;
    private static final String[] z;

    protected Transport(Socket socket, TransportConfiguration transportConfiguration) throws IOException {
        i.a(socket);
        i.a(transportConfiguration);
        this.factory = transportConfiguration.getAlgorithmFactory();
        this.localVersion = transportConfiguration.createProtocolVersion();
        this.socket = socket;
        this.logger = transportConfiguration.createLogger();
        this.reader = new MessageReader(this.socket.getInputStream(), new NullCompression(), new NullCipher(), new NullMac());
        this.reader.setMacCheckAllowed(transportConfiguration.checkMac());
        this.setupMessages();
        this.writer = new MessageWriter(this.socket.getOutputStream(), new NullCompression(), new NullCipher(), new NullMac());
        this.hostKeyVerifier = transportConfiguration.getHostKeyVerifier();
    }

    protected void setupMessages() {
        this.registerMessage(1, SshMsgDisconnect.class);
        this.registerMessage(4, SshMsgDebug.class);
        this.registerMessage(2, SshMsgIgnore.class);
        this.registerMessage(3, SshMsgUnimplemented.class);
        this.registerMessage(20, SshMsgKexInit.class);
        this.registerMessage(21, SshMsgNewKeys.class);
        this.registerMessage(6, SshMsgServiceAccept.class);
        this.registerMessage(5, SshMsgServiceRequest.class);
    }

    public Socket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeKeys() throws IOException {
        SshMsgKexInit sshMsgKexInit = this.factory.createInitMessage();
        MessageReader messageReader = this.reader;
        synchronized (messageReader) {
            MessageWriter messageWriter = this.writer;
            synchronized (messageWriter) {
                this.dispatcher = new Transport$TransportDispatcher(this);
                this.sendMessage(sshMsgKexInit);
                Message message = this.receiveMessage();
                this.assertIsKexInit(message);
                this.exchangeKeys(sshMsgKexInit, (SshMsgKexInit)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exchangeKeys(SshMsgKexInit sshMsgKexInit) throws IOException {
        SshMsgKexInit sshMsgKexInit2 = this.factory.createInitMessage();
        MessageReader messageReader = this.reader;
        synchronized (messageReader) {
            MessageWriter messageWriter = this.writer;
            synchronized (messageWriter) {
                this.dispatcher = new Transport$TransportDispatcher(this);
                this.sendMessage(sshMsgKexInit2);
                this.exchangeKeys(sshMsgKexInit2, sshMsgKexInit);
            }
        }
    }

    protected void exchangeKeys(SshMsgKexInit sshMsgKexInit, SshMsgKexInit sshMsgKexInit2) throws IOException {
        try {
            this.logger.kexStarted();
            this.currentSuite = this.getSuite(sshMsgKexInit, sshMsgKexInit2);
            this.logger.suite(this.currentSuite);
            KeyCreator keyCreator = this.runKeyExchange();
            Transport transport = this;
            if (Message.c == 0) {
                if (transport.sessionId == null) {
                    this.sessionId = keyCreator.getExchangeHash();
                }
                keyCreator.setSessionId(this.sessionId);
                this.sendMessage(new SshMsgNewKeys());
                this.assertIsNewKeys(this.receiveMessage());
                this.setReaderAlgorithms(keyCreator);
                this.setWriterAlgorithms(keyCreator);
                this.dispatcher = new Transport$KexDispatcher(this);
                transport = this;
            }
            transport.logger.kexFinished();
        }
        catch (IOException iOException) {
            this.unrecoverableTransportError(iOException, 3);
            throw iOException;
        }
    }

    protected abstract AlgorithmSuite getSuite(SshMsgKexInit var1, SshMsgKexInit var2) throws TransportException;

    protected abstract KeyCreator runKeyExchange() throws IOException;

    protected abstract void setReaderAlgorithms(KeyCreator var1) throws TransportException;

    protected abstract void setWriterAlgorithms(KeyCreator var1) throws TransportException;

    protected Cipher getClientServerCipher(KeyCreator keyCreator, int n2) throws TransportException {
        String string = this.currentSuite.getClientServerCipher();
        int n3 = this.factory.getCipherKeyLength(string);
        byte[] byArray = keyCreator.createClientServerCipherKey(n3);
        int n4 = this.factory.getCipherBlockLength(string);
        byte[] byArray2 = keyCreator.createClientServerIV(n4);
        return this.factory.getCipher(string, byArray, byArray2, n2);
    }

    protected Cipher getServerClientCipher(KeyCreator keyCreator, int n2) throws TransportException {
        String string = this.currentSuite.getClientServerCipher();
        int n3 = this.factory.getCipherKeyLength(string);
        byte[] byArray = keyCreator.createServerClientCipherKey(n3);
        int n4 = this.factory.getCipherBlockLength(string);
        byte[] byArray2 = keyCreator.createServerClientIV(n4);
        return this.factory.getCipher(string, byArray, byArray2, n2);
    }

    protected Mac getClientServerMac(KeyCreator keyCreator) throws TransportException {
        String string = this.currentSuite.getClientServerMac();
        int n2 = this.factory.getMacKeyLength(string);
        byte[] byArray = keyCreator.createClientServerMacKey(n2);
        return this.factory.getMac(string, byArray);
    }

    protected Mac getServerClientMac(KeyCreator keyCreator) throws TransportException {
        String string = this.currentSuite.getClientServerMac();
        int n2 = this.factory.getMacKeyLength(string);
        byte[] byArray = keyCreator.createServerClientMacKey(n2);
        return this.factory.getMac(string, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Transport transport = this;
        if (Message.c == 0) {
            if (transport.isClosed()) {
                return;
            }
            this.closed = true;
            try {
                this.reader.close();
                this.writer.close();
                this.socket.close();
                transport = this;
            }
            catch (Exception exception) {
                this.logger.a(z[2], exception);
                return;
            }
        }
        transport.logger.closed();
        return;
        finally {
            this.logger.closed();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message) throws IOException {
        try {
            MessageWriter messageWriter = this.writer;
            synchronized (messageWriter) {
                this.writer.writeMessage(message);
                this.logger.messageSent(message);
            }
        }
        catch (IOException iOException) {
            this.unrecoverableError(iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveMessage() throws IOException {
        int n2 = Message.c;
        try {
            Message message = null;
            MessageReader messageReader = this.reader;
            synchronized (messageReader) {
                message = this.reader.readMessage();
                while (message != null) {
                    this.logger.messageReceived(message);
                    if (n2 == 0) {
                        Transport transport = this;
                        if (n2 == 0) {
                            if (!transport.dispatcher.dispatch(message)) break;
                            transport = this;
                        }
                        message = transport.reader.readMessage();
                        if (n2 == 0) continue;
                    }
                    break;
                }
                return message;
            }
        }
        catch (CompressionException compressionException) {
            this.unrecoverableTransportError(compressionException, 6);
            throw compressionException;
        }
        catch (MacException macException) {
            this.unrecoverableTransportError(macException, 5);
            throw macException;
        }
        catch (IOException iOException) {
            this.unrecoverableError(iOException);
            throw iOException;
        }
    }

    protected void assertIsKexInit(Message message) throws TransportException {
        if (message instanceof SshMsgKexInit) {
            return;
        }
        throw new TransportException(z[1] + message);
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public long getSentBytesCount() {
        return this.writer.getBytesCount();
    }

    public long getReceivedBytesCount() {
        return this.reader.getBytesCount();
    }

    public AlgorithmSuite getCurrentSuite() {
        return this.currentSuite;
    }

    public void registerMessage(int n2, Class clazz) {
        this.reader.registerMessage(n2, clazz);
    }

    public void unregisterMessage(int n2) {
        this.reader.unregisterMessage(n2);
    }

    public boolean knowsMessage(int n2) {
        return this.reader.knowsMessage(n2);
    }

    public abstract ProtocolVersion getClientVersion();

    public abstract ProtocolVersion getServerVersion();

    protected void initProtocol() throws IOException {
        try {
            int n2 = this.socket.getSoTimeout();
            this.socket.setSoTimeout((int)this.initTimeout);
            this.localVersion.writeTo(this.socket.getOutputStream());
            this.logger.localVersion(this.localVersion);
            this.remoteVersion = ProtocolVersion.readFrom(this.socket.getInputStream());
            this.socket.setSoTimeout(n2);
        }
        catch (IOException iOException) {
            this.unrecoverableError(iOException);
            throw iOException;
        }
        this.logger.remoteVersion(this.remoteVersion);
        this.assertVersionsCompatible();
    }

    protected void assertVersionsCompatible() throws IOException {
        if (this.localVersion.isCompatible(this.remoteVersion)) {
            return;
        }
        String string = z[0] + this.localVersion.getVersion() + "/" + this.remoteVersion.getVersion();
        TransportException transportException = new TransportException(string);
        this.unrecoverableTransportError(transportException, 8);
        throw transportException;
    }

    protected void assertIsNewKeys(Message message) throws TransportException {
        if (message instanceof SshMsgNewKeys) {
            return;
        }
        throw new TransportException(z[1] + message);
    }

    protected void unrecoverableError(Exception exception) {
        Transport transport = this;
        if (Message.c == 0) {
            if (transport.isClosed()) {
                return;
            }
            this.logger.a(z[3], exception);
            transport = this;
        }
        transport.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void unrecoverableTransportError(IOException iOException, int n2) throws IOException {
        block6: {
            Transport transport = this;
            if (Message.c == 0) {
                if (transport.isClosed()) {
                    return;
                }
                this.sendMessage(new SshMsgDisconnect(n2, iOException.getMessage(), ""));
                transport = this;
            }
            transport.unrecoverableError(iOException);
            break block6;
            catch (Exception exception) {
                this.unrecoverableError(iOException);
                catch (Throwable throwable) {
                    this.unrecoverableError(iOException);
                    throw throwable;
                }
            }
        }
    }

    public HostKeyVerifier getHostKeyVerifier() {
        return this.hostKeyVerifier;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block39: {
            int n2;
            int n3;
            block38: {
                char[] cArray2;
                Object var0;
                block37: {
                    int n4;
                    block36: {
                        char[] cArray3;
                        block35: {
                            int n5;
                            block34: {
                                char[] cArray4;
                                block33: {
                                    int n6;
                                    block32: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray5 = "8Q\u0010}\u0003!^\u0007{\f=ZSb\u001c>K\u001cq\u0001=\u001f\u0005w\u001c\"V\u001c|\u001dk\u001f".toCharArray();
                                        cArray4 = cArray5;
                                        n6 = cArray5.length;
                                        n3 = 0;
                                        if (!true) break block32;
                                        n6 = n6;
                                        if (n6 <= n3) break block33;
                                    }
                                    do {
                                        int n7;
                                        cArray4 = cArray4;
                                        int n8 = n3;
                                        char c2 = cArray4[n8];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n7 = 81;
                                                break;
                                            }
                                            case 1: {
                                                n7 = 63;
                                                break;
                                            }
                                            case 2: {
                                                n7 = 115;
                                                break;
                                            }
                                            case 3: {
                                                n7 = 18;
                                                break;
                                            }
                                            default: {
                                                n7 = 110;
                                            }
                                        }
                                        cArray4[n8] = (char)(c2 ^ n7);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[0] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray6 = "$Q\u0016j\u001e4\\\u0007w\nqR\u0016a\u001d0X\u0016(N".toCharArray();
                                cArray3 = cArray6;
                                n5 = cArray6.length;
                                n3 = 0;
                                if (!true) break block34;
                                n5 = n5;
                                if (n5 <= n3) break block35;
                            }
                            do {
                                int n9;
                                cArray3 = cArray3;
                                int n10 = n3;
                                char c3 = cArray3[n10];
                                switch (n3 % 5) {
                                    case 0: {
                                        n9 = 81;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 63;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 115;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 18;
                                        break;
                                    }
                                    default: {
                                        n9 = 110;
                                    }
                                }
                                cArray3[n10] = (char)(c3 ^ n9);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[1] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray7 = "\u0014M\u0001}\u001cq\\\u001f}\u001d8Q\u00142=\u0002wSf\u001c0Q\u0000b\u0001#K]".toCharArray();
                        cArray2 = cArray7;
                        n4 = cArray7.length;
                        n3 = 0;
                        if (!true) break block36;
                        n4 = n4;
                        if (n4 <= n3) break block37;
                    }
                    do {
                        int n11;
                        cArray2 = cArray2;
                        int n12 = n3;
                        char c4 = cArray2[n12];
                        switch (n3 % 5) {
                            case 0: {
                                n11 = 81;
                                break;
                            }
                            case 1: {
                                n11 = 63;
                                break;
                            }
                            case 2: {
                                n11 = 115;
                                break;
                            }
                            case 3: {
                                n11 = 18;
                                break;
                            }
                            default: {
                                n11 = 110;
                            }
                        }
                        cArray2[n12] = (char)(c4 ^ n11);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[2] = new String(cArray2).intern();
                var0 = null;
                char[] cArray8 = "\u0004Q\u0001w\r>I\u0016`\u000f3S\u00162\u000b#M\u001c`@".toCharArray();
                cArray = cArray8;
                n2 = cArray8.length;
                n3 = 0;
                if (!true) break block38;
                n2 = n2;
                if (n2 <= n3) break block39;
            }
            do {
                int n13;
                cArray = cArray;
                int n14 = n3;
                char c5 = cArray[n14];
                switch (n3 % 5) {
                    case 0: {
                        n13 = 81;
                        break;
                    }
                    case 1: {
                        n13 = 63;
                        break;
                    }
                    case 2: {
                        n13 = 115;
                        break;
                    }
                    case 3: {
                        n13 = 18;
                        break;
                    }
                    default: {
                        n13 = 110;
                    }
                }
                cArray[n14] = (char)(c5 ^ n13);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
    }
}

