/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.sftp;

import com.jscape.inet.file.JAcl$Mask;
import com.jscape.inet.file.JFile;
import com.jscape.inet.file.JFileOpenFlags;
import com.jscape.inet.file.JFileSystem;
import com.jscape.inet.sftp.BadVersionException;
import com.jscape.inet.sftp.PacketReader;
import com.jscape.inet.sftp.PacketWriter;
import com.jscape.inet.sftp.RequestException;
import com.jscape.inet.sftp.SftpConfiguration;
import com.jscape.inet.sftp.SftpConfiguration$SftpLogger;
import com.jscape.inet.sftp.SftpException;
import com.jscape.inet.sftp.SftpExceptionFactory;
import com.jscape.inet.sftp.SftpFile;
import com.jscape.inet.sftp.SftpPacket;
import com.jscape.inet.sftp.packets.SftpFileAttributes;
import com.jscape.inet.sftp.packets.SftpName;
import com.jscape.inet.sftp.packets.SshFxpAttrs;
import com.jscape.inet.sftp.packets.SshFxpClose;
import com.jscape.inet.sftp.packets.SshFxpData;
import com.jscape.inet.sftp.packets.SshFxpFsetstat;
import com.jscape.inet.sftp.packets.SshFxpFstat;
import com.jscape.inet.sftp.packets.SshFxpHandle;
import com.jscape.inet.sftp.packets.SshFxpInit;
import com.jscape.inet.sftp.packets.SshFxpLstat;
import com.jscape.inet.sftp.packets.SshFxpMkdir;
import com.jscape.inet.sftp.packets.SshFxpName;
import com.jscape.inet.sftp.packets.SshFxpOpen;
import com.jscape.inet.sftp.packets.SshFxpOpendir;
import com.jscape.inet.sftp.packets.SshFxpRead;
import com.jscape.inet.sftp.packets.SshFxpReaddir;
import com.jscape.inet.sftp.packets.SshFxpRealpath;
import com.jscape.inet.sftp.packets.SshFxpRemove;
import com.jscape.inet.sftp.packets.SshFxpRmdir;
import com.jscape.inet.sftp.packets.SshFxpSetstat;
import com.jscape.inet.sftp.packets.SshFxpStat;
import com.jscape.inet.sftp.packets.SshFxpStatus;
import com.jscape.inet.sftp.packets.SshFxpVersion;
import com.jscape.inet.sftp.packets.SshFxpWrite;
import com.jscape.inet.util.connection.Connection;
import com.jscape.util.i;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SftpClient
implements JFileSystem {
    private static final Class[] a;
    public static final int VERSION = 1;
    protected int version = 0;
    protected Connection connection = null;
    protected PacketReader reader = null;
    protected PacketWriter writer = null;
    protected Map serverExtensions = Collections.synchronizedMap(new HashMap());
    private String b = z[2];
    protected final SftpConfiguration$SftpLogger logger;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SftpClient create(Class clazz, Connection connection, SftpConfiguration sftpConfiguration) throws SftpException {
        int n2 = SftpPacket.c;
        try {
            Object[] objectArray = new Object[]{connection, sftpConfiguration};
            Constructor constructor = clazz.getConstructor(a);
            return (SftpClient)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable;
            connection.close();
            Throwable throwable2 = throwable = invocationTargetException.getTargetException();
            if (n2 != 0) throw (BadVersionException)throwable2;
            if (!(throwable2 instanceof BadVersionException)) throw new SftpException(invocationTargetException.getMessage(), invocationTargetException);
            throwable2 = throwable;
            throw (BadVersionException)throwable2;
        }
        catch (Exception exception) {
            connection.close();
            Exception exception2 = null;
            Exception exception3 = exception;
            if (n2 == 0) {
                if (exception3 instanceof SftpException) {
                    exception2 = ((SftpException)exception).getException();
                    throw new SftpException(exception.getMessage(), exception2);
                }
                exception3 = exception;
            }
            exception2 = exception3;
            throw new SftpException(exception.getMessage(), exception2);
        }
    }

    public SftpClient(Connection connection, SftpConfiguration sftpConfiguration) throws IOException {
        this(1, connection, sftpConfiguration);
        this.setupReader();
        this.initProtocol();
    }

    protected SftpClient(int n2, Connection connection, SftpConfiguration sftpConfiguration) throws IOException {
        i.a(connection);
        this.version = n2;
        this.connection = connection;
        this.reader = new PacketReader(this.connection.getInputStream());
        this.writer = new PacketWriter(this.connection.getOutputStream());
        this.logger = sftpConfiguration.createLogger();
        this.logger.started();
    }

    protected void setupReader() {
        this.registerPacket(105, SshFxpAttrs.class);
        this.registerPacket(103, SshFxpData.class);
        this.registerPacket(102, SshFxpHandle.class);
        this.registerPacket(104, SshFxpName.class);
        this.registerPacket(101, SshFxpStatus.class);
        this.registerPacket(2, SshFxpVersion.class);
    }

    public void registerPacket(int n2, Class clazz) {
        this.reader.registerPacket(n2, clazz);
    }

    public void unregisterPacket(int n2) {
        this.reader.unregisterPacket(n2);
    }

    public boolean knowsPacket(int n2) {
        return this.reader.knowsPacket(n2);
    }

    protected void initProtocol() throws SftpException {
        SftpPacket sftpPacket;
        SshFxpInit sshFxpInit = new SshFxpInit(this.version);
        SftpPacket sftpPacket2 = sftpPacket = this.sendRequest(sshFxpInit);
        if (SftpPacket.c == 0) {
            if (!(sftpPacket2 instanceof SshFxpVersion)) {
                this.close();
                throw new RequestException(z[1], sshFxpInit, sftpPacket);
            }
            sftpPacket2 = sftpPacket;
        }
        SshFxpVersion sshFxpVersion = (SshFxpVersion)sftpPacket2;
        this.assertCompatibleVersion(sshFxpVersion.getVersion());
        this.serverExtensions.putAll(sshFxpVersion.getExtensions());
    }

    protected void assertCompatibleVersion(int n2) throws BadVersionException {
        block3: {
            SftpClient sftpClient;
            block2: {
                sftpClient = this;
                if (SftpPacket.c != 0) break block2;
                if (sftpClient.version == n2) break block3;
                sftpClient = this;
            }
            sftpClient.close();
            throw new BadVersionException(this.version, n2);
        }
    }

    protected void finalize() throws Throwable {
        SftpClient sftpClient = this;
        if (SftpPacket.c == 0) {
            if (!sftpClient.isClosed()) {
                this.close();
            }
            sftpClient = this;
        }
        super.finalize();
    }

    public synchronized void close() {
        SftpClient sftpClient = this;
        if (SftpPacket.c == 0) {
            if (sftpClient.isClosed()) {
                return;
            }
            this.reader.close();
            this.writer.close();
            this.connection.close();
            sftpClient = this;
        }
        sftpClient.logger.closed();
    }

    public synchronized boolean isClosed() {
        return this.connection.isClosed();
    }

    public int getVersion() {
        return this.version;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean containsExtension(String string) {
        return this.serverExtensions.containsKey(string);
    }

    public byte[] getExtension(String string) {
        return (byte[])this.serverExtensions.get(string);
    }

    public String getStringExtension(String string) {
        byte[] byArray = this.getExtension(string);
        return byArray != null ? new String(byArray) : null;
    }

    public JFile getFile(String string) {
        i.a((Object)string);
        return new SftpFile(string, this);
    }

    public JFile getFile(JFile jFile, String string) {
        i.a(jFile);
        i.a((Object)string);
        i.a(jFile instanceof SftpFile, z[5]);
        return new SftpFile((SftpFile)jFile, string, this);
    }

    public JFile getFile(JFile jFile, String string, SftpFileAttributes sftpFileAttributes) {
        i.a(jFile);
        i.a((Object)string);
        i.a(jFile instanceof SftpFile, z[5]);
        return new SftpFile((SftpFile)jFile, string, sftpFileAttributes, this);
    }

    public synchronized SftpPacket sendRequest(SftpPacket sftpPacket) throws SftpException {
        i.a(sftpPacket);
        this.sendPacket(sftpPacket);
        return this.receivePacket();
    }

    protected synchronized void sendStatusRequest(SftpPacket sftpPacket) throws SftpException {
        SftpPacket sftpPacket2 = this.sendRequest(sftpPacket);
        this.assertStatusOK(sftpPacket, sftpPacket2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendPacket(SftpPacket sftpPacket) throws SftpException {
        try {
            this.logger.packetSent(sftpPacket);
            this.writer.writePacket(sftpPacket, this.b);
            return;
        }
        catch (Exception exception) {
            SftpException sftpException;
            this.logger.a(z[6], exception);
            Exception exception2 = exception;
            if (SftpPacket.c == 0) {
                if (!(exception2 instanceof SftpException)) {
                    sftpException = new SftpException(exception.getMessage(), exception);
                    throw sftpException;
                }
                exception2 = exception;
            }
            sftpException = (SftpException)exception2;
            throw sftpException;
        }
    }

    protected SftpPacket receivePacket() throws SftpException {
        try {
            SftpPacket sftpPacket = this.reader.readPacket(this.b);
            this.logger.packetReceived(sftpPacket);
            return sftpPacket;
        }
        catch (IOException iOException) {
            this.logger.a(z[3], iOException);
            throw new SftpException(iOException.getMessage(), iOException);
        }
    }

    public byte[] open(String string, JFileOpenFlags jFileOpenFlags, JAcl$Mask jAcl$Mask, SftpFileAttributes sftpFileAttributes) throws SftpException {
        return this.open(new SshFxpOpen(string, jFileOpenFlags, jAcl$Mask, sftpFileAttributes));
    }

    protected byte[] open(SshFxpOpen sshFxpOpen) throws SftpException {
        SftpPacket sftpPacket = this.sendRequest(sshFxpOpen);
        this.assertNoError(sshFxpOpen, sftpPacket);
        SftpPacket sftpPacket2 = sftpPacket;
        if (SftpPacket.c == 0) {
            if (!(sftpPacket2 instanceof SshFxpHandle)) {
                throw new RequestException(z[1], sshFxpOpen, sftpPacket);
            }
            sftpPacket2 = sftpPacket;
        }
        return ((SshFxpHandle)sftpPacket2).getHandle();
    }

    public void close(byte[] byArray) throws SftpException {
        this.sendStatusRequest(new SshFxpClose(byArray));
    }

    public byte[] read(byte[] byArray, long l2, int n2) throws SftpException {
        SftpPacket sftpPacket;
        block6: {
            boolean bl;
            SftpPacket sftpPacket2;
            SshFxpRead sshFxpRead;
            block5: {
                int n3 = SftpPacket.c;
                sshFxpRead = new SshFxpRead(byArray, l2, n2);
                sftpPacket2 = this.sendRequest(sshFxpRead);
                bl = sftpPacket2 instanceof SshFxpStatus;
                if (n3 != 0) break block5;
                if (bl) {
                    this.assertEofReached(sshFxpRead, sftpPacket2);
                    return null;
                }
                sftpPacket = sftpPacket2;
                if (n3 != 0) break block6;
                bl = sftpPacket instanceof SshFxpData;
            }
            if (!bl) {
                throw new RequestException(z[1], sshFxpRead, sftpPacket2);
            }
            sftpPacket = sftpPacket2;
        }
        return ((SshFxpData)sftpPacket).getData();
    }

    public void write(byte[] byArray, long l2, byte[] byArray2) throws SftpException {
        this.sendStatusRequest(new SshFxpWrite(byArray, l2, byArray2));
    }

    public void remove(String string) throws SftpException {
        try {
            this.sendStatusRequest(new SshFxpRemove(string));
        }
        catch (RequestException requestException) {
            throw SftpExceptionFactory.getException(requestException, string);
        }
    }

    public void mkdir(String string, SftpFileAttributes sftpFileAttributes) throws SftpException {
        this.sendStatusRequest(new SshFxpMkdir(string, sftpFileAttributes));
    }

    public void rmdir(String string) throws SftpException {
        this.sendStatusRequest(new SshFxpRmdir(string));
    }

    public byte[] opendir(String string) throws SftpException {
        SshFxpOpendir sshFxpOpendir = new SshFxpOpendir(string);
        SftpPacket sftpPacket = this.sendRequest(sshFxpOpendir);
        this.assertNoError(sshFxpOpendir, sftpPacket);
        SftpPacket sftpPacket2 = sftpPacket;
        if (SftpPacket.c == 0) {
            if (!(sftpPacket2 instanceof SshFxpHandle)) {
                throw new RequestException(z[1], sshFxpOpendir, sftpPacket);
            }
            sftpPacket2 = sftpPacket;
        }
        return ((SshFxpHandle)sftpPacket2).getHandle();
    }

    public SftpName[] readdir(byte[] byArray) throws SftpException {
        SftpPacket sftpPacket;
        block6: {
            boolean bl;
            SftpPacket sftpPacket2;
            SshFxpReaddir sshFxpReaddir;
            block5: {
                int n2 = SftpPacket.c;
                sshFxpReaddir = new SshFxpReaddir(byArray);
                sftpPacket2 = this.sendRequest(sshFxpReaddir);
                bl = sftpPacket2 instanceof SshFxpStatus;
                if (n2 != 0) break block5;
                if (bl) {
                    this.assertEofReached(sshFxpReaddir, sftpPacket2);
                    return null;
                }
                sftpPacket = sftpPacket2;
                if (n2 != 0) break block6;
                bl = sftpPacket instanceof SshFxpName;
            }
            if (!bl) {
                throw new RequestException(z[1], sshFxpReaddir, sftpPacket2);
            }
            sftpPacket = sftpPacket2;
        }
        return ((SshFxpName)sftpPacket).getNames();
    }

    public SftpFileAttributes stat(String string) throws SftpException {
        return this.getStat(new SshFxpStat(string));
    }

    public SftpFileAttributes lstat(String string) throws SftpException {
        return this.getStat(new SshFxpLstat(string));
    }

    public SftpFileAttributes fstat(byte[] byArray) throws SftpException {
        return this.getStat(new SshFxpFstat(byArray));
    }

    protected SftpFileAttributes getStat(SftpPacket sftpPacket) throws SftpException {
        SftpPacket sftpPacket2 = this.sendRequest(sftpPacket);
        this.assertNoError(sftpPacket, sftpPacket2);
        SftpPacket sftpPacket3 = sftpPacket2;
        if (SftpPacket.c == 0) {
            if (!(sftpPacket3 instanceof SshFxpAttrs)) {
                throw new RequestException(z[1], sftpPacket, sftpPacket2);
            }
            sftpPacket3 = sftpPacket2;
        }
        return ((SshFxpAttrs)sftpPacket3).getAttrs();
    }

    public void setStat(String string, SftpFileAttributes sftpFileAttributes) throws SftpException {
        this.sendStatusRequest(new SshFxpSetstat(string, sftpFileAttributes));
    }

    public void setFstat(byte[] byArray, SftpFileAttributes sftpFileAttributes) throws SftpException {
        this.sendStatusRequest(new SshFxpFsetstat(byArray, sftpFileAttributes));
    }

    public String realPath(String string) throws SftpException {
        SftpName[] sftpNameArray;
        int n2 = SftpPacket.c;
        SshFxpRealpath sshFxpRealpath = new SshFxpRealpath(string);
        SftpPacket sftpPacket = this.sendRequest(sshFxpRealpath);
        this.assertNoError(sshFxpRealpath, sftpPacket);
        SftpPacket sftpPacket2 = sftpPacket;
        if (n2 == 0) {
            if (!(sftpPacket2 instanceof SshFxpName)) {
                throw new RequestException(z[1], sshFxpRealpath, sftpPacket);
            }
            sftpPacket2 = sftpPacket;
        }
        SftpName[] sftpNameArray2 = sftpNameArray = ((SshFxpName)sftpPacket2).getNames();
        if (n2 == 0) {
            if (sftpNameArray2.length == 0) {
                throw new SftpException(z[0]);
            }
            sftpNameArray2 = sftpNameArray;
        }
        return sftpNameArray2[0].getFileName(this.b);
    }

    protected void assertNoError(SftpPacket sftpPacket, SftpPacket sftpPacket2) throws RequestException {
        block3: {
            SftpPacket sftpPacket3;
            block2: {
                sftpPacket3 = sftpPacket2;
                if (SftpPacket.c != 0) break block2;
                if (!(sftpPacket3 instanceof SshFxpStatus)) break block3;
                sftpPacket3 = sftpPacket2;
            }
            SshFxpStatus sshFxpStatus = (SshFxpStatus)sftpPacket3;
            throw new RequestException(z[4] + sshFxpStatus.getCode(), sftpPacket, sftpPacket2);
        }
    }

    protected void assertStatusOK(SftpPacket sftpPacket, SftpPacket sftpPacket2) throws RequestException {
        SshFxpStatus sshFxpStatus;
        int n2;
        SftpPacket sftpPacket3 = sftpPacket2;
        if (SftpPacket.c == 0) {
            if (!(sftpPacket3 instanceof SshFxpStatus)) {
                throw new RequestException(z[1], sftpPacket, sftpPacket2);
            }
            sftpPacket3 = sftpPacket2;
        }
        if ((n2 = (sshFxpStatus = (SshFxpStatus)sftpPacket3).getCode()) != 0) {
            throw new RequestException(z[4] + sshFxpStatus.getCode(), sftpPacket, sftpPacket2);
        }
    }

    protected void assertEofReached(SftpPacket sftpPacket, SftpPacket sftpPacket2) throws RequestException {
        SshFxpStatus sshFxpStatus;
        int n2;
        SftpPacket sftpPacket3 = sftpPacket2;
        if (SftpPacket.c == 0) {
            if (!(sftpPacket3 instanceof SshFxpStatus)) {
                throw new RequestException(z[1], sftpPacket, sftpPacket2);
            }
            sftpPacket3 = sftpPacket2;
        }
        if ((n2 = (sshFxpStatus = (SshFxpStatus)sftpPacket3).getCode()) != 1) {
            throw new RequestException(z[4] + n2, sftpPacket, sftpPacket2);
        }
    }

    public String getCharset() {
        return this.b;
    }

    public void setCharset(String string) {
        i.a(string);
        this.b = string;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block69: {
            int n2;
            int n3;
            block68: {
                char[] cArray2;
                Object var0;
                block67: {
                    int n4;
                    block66: {
                        char[] cArray3;
                        block65: {
                            int n5;
                            block64: {
                                char[] cArray4;
                                block63: {
                                    int n6;
                                    block62: {
                                        char[] cArray5;
                                        block61: {
                                            int n7;
                                            block60: {
                                                char[] cArray6;
                                                block59: {
                                                    int n8;
                                                    block58: {
                                                        char[] cArray7;
                                                        block57: {
                                                            int n9;
                                                            block56: {
                                                                stringArray = new String[7];
                                                                var0 = null;
                                                                char[] cArray8 = "m\u0015gg'j\u0006u\"&/\u0006f4$`\u001ap\"".toCharArray();
                                                                cArray7 = cArray8;
                                                                n9 = cArray8.length;
                                                                n3 = 0;
                                                                if (!true) break block56;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block57;
                                                            }
                                                            do {
                                                                int n10;
                                                                cArray7 = cArray7;
                                                                int n11 = n3;
                                                                char c2 = cArray7[n11];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n10 = 15;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n10 = 116;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n10 = 3;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n10 = 71;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n10 = 84;
                                                                    }
                                                                }
                                                                cArray7[n11] = (char)(c2 ^ n10);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[0] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray9 = "z\u001af?$j\u0017w\"0/\u0007f5\"j\u0006#51|\u0004l)'j".toCharArray();
                                                        cArray6 = cArray9;
                                                        n8 = cArray9.length;
                                                        n3 = 0;
                                                        if (!true) break block58;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block59;
                                                    }
                                                    do {
                                                        int n12;
                                                        cArray6 = cArray6;
                                                        int n13 = n3;
                                                        char c3 = cArray6[n13];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n12 = 15;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n12 = 116;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n12 = 3;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n12 = 71;
                                                                break;
                                                            }
                                                            default: {
                                                                n12 = 84;
                                                            }
                                                        }
                                                        cArray6[n13] = (char)(c3 ^ n12);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[1] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray10 = "Z Ejl".toCharArray();
                                                cArray5 = cArray10;
                                                n7 = cArray10.length;
                                                n3 = 0;
                                                if (!true) break block60;
                                                n7 = n7;
                                                if (n7 <= n3) break block61;
                                            }
                                            do {
                                                int n14;
                                                cArray5 = cArray5;
                                                int n15 = n3;
                                                char c4 = cArray5[n15];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n14 = 15;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n14 = 116;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n14 = 3;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n14 = 71;
                                                        break;
                                                    }
                                                    default: {
                                                        n14 = 84;
                                                    }
                                                }
                                                cArray5[n15] = (char)(c4 ^ n14);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[2] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray11 = "J\u0006q(&/\u0006f$1f\u0002j)3/'E\u0013\u0004/\u0004b$?j\u0000-".toCharArray();
                                        cArray4 = cArray11;
                                        n6 = cArray11.length;
                                        n3 = 0;
                                        if (!true) break block62;
                                        n6 = n6;
                                        if (n6 <= n3) break block63;
                                    }
                                    do {
                                        int n16;
                                        cArray4 = cArray4;
                                        int n17 = n3;
                                        char c5 = cArray4[n17];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n16 = 15;
                                                break;
                                            }
                                            case 1: {
                                                n16 = 116;
                                                break;
                                            }
                                            case 2: {
                                                n16 = 3;
                                                break;
                                            }
                                            case 3: {
                                                n16 = 71;
                                                break;
                                            }
                                            default: {
                                                n16 = 84;
                                            }
                                        }
                                        cArray4[n17] = (char)(c5 ^ n16);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[3] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray12 = "l\u001bg\"n/".toCharArray();
                                cArray3 = cArray12;
                                n5 = cArray12.length;
                                n3 = 0;
                                if (!true) break block64;
                                n5 = n5;
                                if (n5 <= n3) break block65;
                            }
                            do {
                                int n18;
                                cArray3 = cArray3;
                                int n19 = n3;
                                char c6 = cArray3[n19];
                                switch (n3 % 5) {
                                    case 0: {
                                        n18 = 15;
                                        break;
                                    }
                                    case 1: {
                                        n18 = 116;
                                        break;
                                    }
                                    case 2: {
                                        n18 = 3;
                                        break;
                                    }
                                    case 3: {
                                        n18 = 71;
                                        break;
                                    }
                                    default: {
                                        n18 = 84;
                                    }
                                }
                                cArray3[n19] = (char)(c6 ^ n18);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[4] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray13 = "m\u0015gg$n\u0006f) /\u0012j+1/\u0000z71".toCharArray();
                        cArray2 = cArray13;
                        n4 = cArray13.length;
                        n3 = 0;
                        if (!true) break block66;
                        n4 = n4;
                        if (n4 <= n3) break block67;
                    }
                    do {
                        int n20;
                        cArray2 = cArray2;
                        int n21 = n3;
                        char c7 = cArray2[n21];
                        switch (n3 % 5) {
                            case 0: {
                                n20 = 15;
                                break;
                            }
                            case 1: {
                                n20 = 116;
                                break;
                            }
                            case 2: {
                                n20 = 3;
                                break;
                            }
                            case 3: {
                                n20 = 71;
                                break;
                            }
                            default: {
                                n20 = 84;
                            }
                        }
                        cArray2[n21] = (char)(c7 ^ n20);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[5] = new String(cArray2).intern();
                var0 = null;
                char[] cArray14 = "J\u0006q(&/\u0007f)0f\u001adg\u0007I Sg$n\u0017h\" !".toCharArray();
                cArray = cArray14;
                n2 = cArray14.length;
                n3 = 0;
                if (!true) break block68;
                n2 = n2;
                if (n2 <= n3) break block69;
            }
            do {
                int n22;
                cArray = cArray;
                int n23 = n3;
                char c8 = cArray[n23];
                switch (n3 % 5) {
                    case 0: {
                        n22 = 15;
                        break;
                    }
                    case 1: {
                        n22 = 116;
                        break;
                    }
                    case 2: {
                        n22 = 3;
                        break;
                    }
                    case 3: {
                        n22 = 71;
                        break;
                    }
                    default: {
                        n22 = 84;
                    }
                }
                cArray[n23] = (char)(c8 ^ n22);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[6] = new String(cArray).intern();
        z = stringArray;
        a = new Class[]{Connection.class, SftpConfiguration.class};
    }
}

