#!/bin/sh

EXE_DIR="`pwd`"
SCRIPT_HOME="`dirname \"${0}\"`"
cd "${SCRIPT_HOME}"
# get APP_HOME from path of this script
APP_HOME="`pwd | sed -E -e \"s:(/[^/]*/[^/]*)/.*:\1:g\"`"
APP_BIN="${APP_HOME}/bin"
cd "${APP_HOME}"

updateProductName() {
    TARGET_FILE="${1}"
    if [ ! -f "${TARGET_FILE}" ]; then
        echo "File ${TARGET_FILE} not exist ..."
        return;
    fi
    SED_TMP="${APP_HOME}/sed_tmp"
    echo "Update path of file ${TARGET_FILE}"
    # fix path /Applications/XXX.app
    sed -e "s:/Applications/[^/]*\.app:${APP_HOME}:g" "${TARGET_FILE}">"${SED_TMP}"
    cp -f "${SED_TMP}" "${TARGET_FILE}"
    rm "${SED_TMP}"
}

# replace scheduler files
cd "${APP_BIN}"
BIN_SUBFOLDERS="`ls -d */ | grep -v help | grep -v images | sed -e s:/::g`"
cd "${APP_HOME}"
OIFS=$IFS
IFS=$'\n'
for word in $BIN_SUBFOLDERS
do
    SUBFOLDER_NAME="${word}"
    if [ -f "${APP_BIN}/${SUBFOLDER_NAME}/StartupParameters.plist" ] && [ -f "${APP_BIN}/${SUBFOLDER_NAME}/${SUBFOLDER_NAME}" ]; then
        # bin/PRODUCT_SHORT_NAME/PRODUCT_SHORT_NAME
        SCH_CONFIG="${APP_BIN}/${SUBFOLDER_NAME}/${SUBFOLDER_NAME}"
        updateProductName "${SCH_CONFIG}"
    fi
done
IFS=$OIFS

# aua/startUpdate.sh
AUA_UPDATE_SCRIPT="${APP_HOME}/aua/startUpdate.sh"
updateProductName "${AUA_UPDATE_SCRIPT}"

# bin/StopScheduler.sh
STOP_SCHEDULER_SCRIPT="${APP_BIN}/StopScheduler.sh"
updateProductName "${STOP_SCHEDULER_SCRIPT}"

# bin/uninstall.sh
UNINSTALL_SCRIPT="${APP_BIN}/uninstall.sh"
updateProductName "${UNINSTALL_SCRIPT}"

# bin/com.cb.scheduler.plist
SCH_PLIST="${APP_BIN}/com.cb.scheduler.plist"
updateProductName "${SCH_PLIST}"

# util/bin/post-update-app.sh
POST_UPDATE_SCRIPT="${APP_HOME}/util/bin/post-update-app.sh"
updateProductName "${POST_UPDATE_SCRIPT}"

# util/bin/post-update-services.sh
POST_UPDATE_SRV_SCRIPT="${APP_HOME}/util/bin/post-update-services.sh"
updateProductName "${POST_UPDATE_SRV_SCRIPT}"

cd "${EXE_DIR}"
exit 0
