#!/bin/bash

# uninstall logic for Ahsay Online Backup Manager 10.1.4.0
# The root privilege is required to uninstall the application

###############################################################################
#             S H U T - D O W N                 S E R V I C E S               #
###############################################################################

# Shutdown Scheduler
if [ -e "/Applications/AhsayOBM.app/ipc/Scheduler/running" ]; then
    echo "Shutdown Scheduler for Ahsay Online Backup Manager"
    touch "/Applications/AhsayOBM.app/ipc/Scheduler/stop"
    echo "Wait 5 seconds before Scheduler exits"
    sleep 5
fi

# Shutdown AutoUpdateAgent
#if [ -e "/Applications/AhsayOBM/aua/bin" ]; then
#    echo "Shutdown AutoUpdateAgent for Ahsay Online Backup Manager"
#    sh "/Applications/AhsayOBM/aua/bin/shutdown.sh"
#    echo "Wait 5 seconds before AutoUpdateAgent exits"
#    sleep 5
#fi

###############################################################################
#        T A S K K I L L       A L L      J A V A       P R O C E S S         #
###############################################################################

# Kill all running process
sh "/Applications/AhsayOBM.app/bin/taskkill" "/Applications/AhsayOBM.app/jvm/bin/bJW"
sh "/Applications/AhsayOBM.app/bin/taskkill" "/Applications/AhsayOBM.app/jvm/bin/bschJW"
sh "/Applications/AhsayOBM.app/bin/taskkill" "/Applications/AhsayOBM.app/jvm/bin/java"


###############################################################################
#                 R E M O V E                   S E R V I C E S               #
###############################################################################

# Remove Scheduler
if [ -e "/Library/StartupItems/AhsayOBM" ]; then
    echo "Remove Scheduler for Ahsay Online Backup Manager from service"
    rm -rf "/Library/StartupItems/AhsayOBM"
fi

# Remove Launch Daemons
if [ -e "/Library/LaunchDaemons/com.AhsayOBM.scheduler.plist" ]; then
    echo "Remove LaunchDaemons for com.AhsayOBM.scheduler from service"
    launchctl unload "/Library/LaunchDaemons/com.AhsayOBM.scheduler.plist"
    rm -f "/Library/LaunchDaemons/com.AhsayOBM.scheduler.plist"
fi
# Remove AutoUpdateAgent
#if [ -e "/Library/StartupItems/AhsayOBM-AutoUpdate" ]; then
#    echo "Remove AutoUpdateAgent for Ahsay Online Backup Manager from service"
#    rm -rf "/Library/StartupItems/AhsayOBM-AutoUpdate"
#fi

###############################################################################
#      R E M O V E        U S E R         D E S K T O P      L I N K          #
###############################################################################

# Remove Desktop Symbolic Link
find /Users -name Desktop -type d -maxdepth 3 -mindepth 2 | while read DESKTOP_PATH;
do
    if [ -e "${DESKTOP_PATH}/AhsayOBM" ]; then
        echo "Remove Desktop Link AhsayOBM from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/AhsayOBM"
        echo "Removed AhsayOBM Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/Ahsay Online Backup Manager" ]; then
        echo "Remove Desktop Link Ahsay Online Backup Manager from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/Ahsay Online Backup Manager"
        echo "Removed Ahsay Online Backup Manager Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/AhsayOBM" ]; then
        echo "Remove Desktop Link AhsayOBM from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/AhsayOBM"
        echo "Removed AhsayOBM Desktop Link"
    fi

done

###############################################################################
#       R E M O V E        F I R E W A L L        R U L E                     #
###############################################################################

echo "Remove firewall rule"
sh "/Applications/AhsayOBM.app/bin/UpdateFirewallRule.sh" "/Applications/AhsayOBM.app/Contents/MacOS/AhsayOBM" false

###############################################################################
#        R E M O V E           A P P L I C A T I O N           H O M E        #
###############################################################################

# Remove Ahsay Online Backup Manager
cd /
if [ -e "/Applications/AhsayOBM.app" ]; then
    echo "Remove AhsayOBM from Your Mac OS X"
    rm -rf "/Applications/AhsayOBM.app"
fi

###############################################################################
#        R E M O V E             M A C     O S        R E C E I P T S         #
###############################################################################

# Remove Mac OS X Receipts
if [ -e "/Library/Receipts/obm-mac.pkg" ]; then
    echo "Remove Mac OS X Receipt for obm-mac.pkg (Path: /Library/Receipts/obm-mac.pkg)"
    rm -rf "/Library/Receipts/obm-mac.pkg"
fi