#!/bin/sh

################################################################################
#      R E T R I E V E            A P P _ H O M E           P A T H            #
################################################################################

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

################################################################################
#      R E T R I E V E           J A V A _ H O M E           P A T H           #
################################################################################

if [ "Darwin" = `uname` ]; then
    JAVA_HOME="/System/Library/Frameworks/JavaVM.framework/Home"
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "'$APP_HOME/jvm' does not exist!"
    if [ ! -n "$JAVA_HOME" ]; then
        echo "Please set JAVA_HOME!"
        exit 0
    else
        ln -sf "$JAVA_HOME" "$APP_HOME/jvm"
        echo "Created JAVA_HOME symbolic link at '$APP_HOME/jvm'"
    fi
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "Please create symbolic link for '$JAVA_HOME' to '$APP_HOME/jvm'"
    exit 0
fi

JAVA_HOME="$APP_HOME/jvm"

# Use alternative executable name to define the GUI execution
if [ "Darwin" = `uname` ]; then
    JAVA_EXE="$JAVA_HOME/bin/java"
else
    JAVA_EXE="$JAVA_HOME/bin/bschJW"
fi

# Create the binary file for GUI, Scheduler, AutoUpdate
if [ ! -x "$APP_HOME/jvm/bin/bschJW" ]; then
  echo "Create Scheduler Service JVM, Path: $APP_HOME/jvm/bin/bschJW"
  ln -sf "$APP_HOME/jvm/bin/java" "$APP_HOME/jvm/bin/bschJW"
  chmod 755 "$APP_HOME/jvm/bin/bschJW"
fi

################################################################################
#                  J A V A                 E X E C U T I O N                   #
################################################################################

# Current directory has been changed to APP_HOME

LD_LIBRARY_PATH="$APP_BIN:$APP_BIN/../mbs/bin/MacX84"
DYLD_FALLBACK_LIBRARY_PATH="$APP_BIN/../mbs/bin/MacX84"
SHLIB_PATH="$LD_LIBRARY_PATH"
SCHEDULER_MODE="TRUE"
export LD_LIBRARY_PATH DYLD_FALLBACK_LIBRARY_PATH SHLIB_PATH SCHEDULER_MODE

# Change to APP_BIN for JAVA execution
cd "${APP_BIN}"

mkdir -p "${APP_HOME}/log"
mkdir -p "${APP_HOME}/log/Scheduler"

# Do not include double-quote for java options, jni path, classpath and
# main class.
# Only apply double-quote for path to java executable and execution arguments
"${APP_HOME}/Contents/MacOS/AhsayOBM" > "${APP_HOME}/log/Scheduler/console.log" 2>&1 &

################################################################################
#                   R E S E T          A N D          E X I T                  #
################################################################################

cd "${EXE_DIR}"
exit 0
