@ECHO OFF
REM -------------------------------  REMINDER  ---------------------------------
REM | Some special characters inside the parameters need to be escaped.        |
REM | e.g. % => %% | " => \" | \ => \\ | ! => ^!                               |
REM ----------------------------------------------------------------------------

REM -------------------------------  BACKUP_SET  -------------------------------
REM | The name or ID of the backup set that you want to restore.               |
REM | If backup set name is not in English, please use ID instead.             |
REM | e.g. SET BACKUP_SET="1119083740107"                                      |
REM |  or  SET BACKUP_SET="FileBackupSet-1"                                    |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 backup set.        |
REM ----------------------------------------------------------------------------
SET BACKUP_SET=""

REM ------------------------------  DESTINATION  -------------------------------
REM | The name or ID of the backup destination that you want to restore from.  |
REM | If backup destination name is not in English, please use ID instead.     |
REM | e.g. SET DESTINATION="1740107119083"                                     |
REM |  or  SET DESTINATION="Destination-1"                                     |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 destination.       |
REM ----------------------------------------------------------------------------
SET DESTINATION=""

REM ------------------------------  RESTORE_FROM  ------------------------------
REM | Files/Directories on the backup server that you would like to restore    |
REM | Use "|" to separate multiple                                             |
REM | e.g. SET RESTORE_FROM="C:\Data"                                          |
REM |      SET RESTORE_FROM="C:\Data\dump.sql|D:\Backup\dump1.sql"             |
REM ----------------------------------------------------------------------------
SET RESTORE_FROM=""

REM -----------------------------  POINT_IN_TIME  ------------------------------
REM | The point-in-time snapshot (successful backup) that you want to restore  |
REM | from the backup server. Use "Current" for the latest backup snapshot     |
REM | e.g. SET POINT_IN_TIME="2006-10-04-12-57-13"                             |
REM |  or  SET POINT_IN_TIME="Current"                                         |
REM |                                                                          |
REM | You can retrieve the point in time by using the ListBackupJob.bat        |
REM ----------------------------------------------------------------------------
SET POINT_IN_TIME="Current"

REM ----------------------------  RESTORE_TYPE  --------------------------------
REM | Type of Restore you want to perform                                      |
REM | set to "" to restore files to original location                          |
REM | e.g. SET RESTORE_TYPE="Original"                                         |
REM |   or SET RESTORE_TYPE="Alternate"                                        |
REM |   or SET RESTORE_TYPE="Raw"                                              |
REM ----------------------------------------------------------------------------
SET RESTORE_TYPE=""

REM ----------------------------  HOST_TYPE  -----------------------------------
REM | Host type of the target database server.                                 |
REM | set to "" to restore files to original location                          |
REM | e.g. SET HOST_TYPE="Self-hosted"                                         |
REM |   or SET HOST_TYPE="Google Cloud SQL"                                    |
REM |   or SET HOST_TYPE="Azure Database"                                      |
REM |   or SET HOST_TYPE="Amazon RDS"                                          |
REM ----------------------------------------------------------------------------
SET HOST_TYPE=""

REM ----------------------------  REGION  --------------------------------------
REM | Only used if Amazon RDS is the selected host type.                       |
REM | The RDS region where the database server is hosted.                      |
REM | See https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html
REM | for full list                                                            |
REM | e.g. SET REGION="us-east-1" [US East (N.Virginia)]                       |
REM |   or SET REGION="us-east-2" [US East (Ohio)]                             |
REM |   or SET REGION="us-west-1" [US West (Northern California)]              |
REM |   ...                                                                    |
REM ----------------------------------------------------------------------------
SET REGION=""

REM --------------------  RESTORE_ALTERNATE_CONNECTION  ------------------------
REM | Database server connection information for Alternate Restore             |
REM | e.g. SET HOST_TYPE="Self-hosted"                                         |
REM |      SET HOST="localhost"                                                |
REM |      SET PORT="3306"                                                     |
REM |      SET USERNAME="root"                                                 |
REM |      SET PASSWORD=""                                                     |
REM ----------------------------------------------------------------------------
SET HOST=""
SET PORT=""
SET USERNAME=""
SET PASSWORD=""

REM ------------------------  EXECUTABLE_LOCATION  -----------------------------
REM | Location of sqldump executable (Optional)                                |
REM | e.g.                                                                     |
REM | SET SQLDUMP="C:\Program Files\MySQL\MySQL Server 9.0\bin\mysqldump.exe"  |
REM | SET SQLDUMP="C:\Program Files\PostgreSQL\16\bin\pg_dump.exe"             |
REM ----------------------------------------------------------------------------
SET SQLDUMP=""

REM ------------------  RESTORE_ALTERNATE_RESTORE_TO  --------------------------
REM | Database mapping for alternate restore                                   |
REM | Use ">" to map original database name to new alternate database name     |
REM | Use "|" to separate multiple mappings                                    |
REM | e.g. SET RESTORE_TO="oldDb>newDb"                                        |
REM |      SET RESTORE_TO="oldDb1>newDb1|oldDb2>newDb2"                        |
REM ----------------------------------------------------------------------------
SET RESTORE_TO=""

REM ----------------  RESTORE_RAW_REPLACE_EXISTING_FILE  -----------------------
REM | set to "--all" to replace all existing file(s) of the same filename      |
REM | set to "--none" to skip all existing file(s) with the same filename      |
REM | set to "" to prompt for selection                                        |
REM ----------------------------------------------------------------------------
SET REPLACE_EXISTING_FILE="--all"

REM ------------------------------  SETTING_HOME  ------------------------------
REM | Directory to your setting home. Default to                               |
REM | "C:\Users\USER\.@win.app.product.id@" when not set.                      |
REM | e.g. SET SETTING_HOME="C:\Users\John\.@win.app.product.id@"              |
REM ----------------------------------------------------------------------------
SET SETTING_HOME=""

REM -----------------------------  VERIFY_CHKSUM  ------------------------------
REM | set to "Y" if you want to verify in-file delta file checksum during      |
REM | restore                                                                  |
REM | set to "N" if you do NOT want to verify in-file delta file checksum      |
REM | during restore                                                           |
REM ----------------------------------------------------------------------------
SET VERIFY_CHKSUM="N"
REM --------------------------------  TEMP_DIR  --------------------------------
REM | Directory to where you want to store restore files temporarily           |
REM | Use "\\\\" instead of "\\" when you specify a UNC path                   |
REM | set to "" to use the temporary directory in the backup set               |
REM | e.g. SET TEMP_DIR="C:\Temp"                                              |
REM ----------------------------------------------------------------------------
SET TEMP_DIR=""

REM -----------------------------  VERIFY_CHKSUM  ------------------------------
REM | set to "Y" if you want to verify in-file delta file checksum during      |
REM | restore                                                                  |
REM | set to "N" if you do NOT want to verify in-file delta file checksum      |
REM | during restore                                                           |
REM ----------------------------------------------------------------------------
SET VERIFY_CHKSUM="N"

REM ####################  END: User Defined Section  ###########################

SET APP_HOME=..
SET JAVA_HOME=%APP_HOME%\jvm
SET JAVA_EXE=%JAVA_HOME%\bin\bJW.exe
SET JAVA_LIB_PATH=-Djava.library.path=%APP_HOME%\bin
SET PATH=%JAVA_HOME%\bin;%PATH%
SET CLASSPATH=%APP_HOME%\bin;%APP_HOME%\bin\cb.jar

SET "DEP_LIB_PATH=X64"
SET INI_FILE=cb.ini
SETLOCAL enabledelayedexpansion
SET JAVA_OPTS=
for /f "tokens=* delims=" %%A in ('findstr /V /R "^[#]" "%INI_FILE%"') do (
  set "line=%%A"
  if not "!line!"=="" set JAVA_OPTS=!JAVA_OPTS! !line!
)

SET PATH=%CD%\%APP_HOME%\bin\%DEP_LIB_PATH%;%PATH%
SET JAVA_LIB_PATH=%JAVA_LIB_PATH%;%APP_HOME%\bin\%DEP_LIB_PATH%

REM #############################################################################
ECHO - 
ECHO APP_HOME=%APP_HOME%
ECHO SETTING_HOME=%SETTING_HOME%
ECHO JAVA_HOME=%JAVA_HOME%
ECHO JAVA_EXE=%JAVA_EXE%
ECHO JAVA_OPTS=%JAVA_OPTS%
ECHO JAVA_LIB_PATH=%JAVA_LIB_PATH%
ECHO PATH=%PATH%
ECHO CLASSPATH=%CLASSPATH%
ECHO - 

@ECHO ON
%JAVA_EXE% %JAVA_LIB_PATH% -cp %CLASSPATH% %JAVA_OPTS% RestoreSQLDump --to=%RESTORE_TO% --from=%RESTORE_FROM% --backup-set=%BACKUP_SET% --backup-dest=%DESTINATION% %REPLACE_EXISTING_FILE% --date=%POINT_IN_TIME% --restore-type=%RESTORE_TYPE% --host-type=%HOST_TYPE% --region=%REGION% --host=%HOST% --port=%PORT% --username=%USERNAME% --password=%PASSWORD% --sqldump=%SQLDUMP% --skip-invalid-key=%SKIP_INVALID_KEY% --sync=%SYNC_OPTION% --filter=%FILTER% --temp-dir=%TEMP_DIR% --verify-delta-file-chksum=%VERIFY_CHKSUM% --app-home=%APP_HOME% --setting-home=%SETTING_HOME%
@ECHO OFF
CD %APP_HOME%
IF "%APP_HOME%"==".." PAUSE
@ECHO ON