<%@ page language="java" %>
<%@ page contentType="text/html; charset=utf-8" %>
<%@ taglib uri="/WEB-INF/tlds/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/tlds/struts-bean.tld" prefix="bean" %>
<!DOCTYPE HTML>
<bean:define id="DownloadBean" name="DownloadBean" type="com.ahsay.pns.www.bean.DownloadBean" />
<html xmlns:th="http://www.thymeleaf.org">
	<head>
		<title>Download</title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<script>
			const APPLE_APP_STORE_URL = '<bean:write name="DownloadBean" property="iosDownloadPath"/>';
			const GOOGLE_PLAY_STORE_URL = '<bean:write name="DownloadBean" property="androidDownloadPath"/>';
			const QR_CODE = '<bean:write name="DownloadBean"  property="qrCode"/>';

			function redirect() {
				var appVersion = navigator.appVersion;
				var isAndroid = appVersion.indexOf('Android') > 0;

				var storeUrl;
				if (isAndroid) {
					storeUrl = GOOGLE_PLAY_STORE_URL;
				} else if (isIos()) {
					storeUrl = APPLE_APP_STORE_URL;
				} else {
					storeUrl = "https://www.cloudbacko.com";
				}

				if (QR_CODE === null || QR_CODE === undefined || QR_CODE === '') {
					window.location = storeUrl;
				} else {
					// try to go launch the installed app first, user will be redirected to store after 3 seconds if the app cannot be launched
					setTimeout(function () { 
						window.location = storeUrl;
					}, 3000);

					window.location = QR_CODE;
				}
			}

			function isIos() {
				if (/iPad|iPhone|iPod/.test(navigator.platform)) {
					return true;
				} else {
					return navigator.maxTouchPoints && navigator.maxTouchPoints > 2 && /MacIntel/.test(navigator.platform);
				}
			}
		</script>
	</head>
	<body onload="redirect()">
		<div>Redirecting...</div>
	</body>
</html>