<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>


<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Custom Backup Schedule</h1>

<P>A custom backup schedule defines the date, time and time period that a backup job will run once automatically.
</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>Schedule task name.
        </td>
      </tr>
      <tr>
        <td width="20%">Type</td>
        <td>Type of backup schedule, which is "Custom".
        </td>
      </tr>
	  <tr>
        <td width="20%">Backup on the following day once</td>
        <td>The specific date when backup job will run. 
        </td>
      </tr>
      <tr>
        <td width="20%">Start backup at</td>
        <td>Start backup time.
        </td>
      </tr>
      <tr>
        <td width="20%">Stop</td>
        <td>Stop backup time. The backup schedule can be set to stop either
		    <LI>Full backup is completed regardless of how much time it takes. (default)</LI> 
			<b>or</b>
			<LI>After the backup has started for the set time (1-24 hr) regardless if the backup is done.</LI>
        </td>
      </tr>
	  
</table>
<BR><BR>

<H3>To set up a backup schedule:</H3>
<OL>
<LI>Configure a meaningful backup schedule name if necessary. </LI>
<LI>Select the type of backup schedule.</LI>
<LI>Select the date that you want the backup to run.</LI>
<LI>Configure the start time according to your requirement.</LI>
<LI>Configure the stop option according to your requirement.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<H3>To modify an existing backup schedule:</H3>
<OL>
<LI>Configure a meaningful backup schedule name if necessary.  </LI>
<LI>The type of the backup schedule cannot be modified. If you need another type of schedule, you need to create a new schedule type. </LI>
<LI>Select the date that you want the backup to run.</LI>
<LI>Configure the start time according to your requirement.</LI>
<LI>Configure the stop option according to your requirement.</LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<h3>Example:</h3>
<P>To configure a Custom backup schedule where backup job will run on February 15th of 2021 (2021-02-15) at 8:00pm until full backup is complete:</P>
<OL>
<LI>Enter name of the backup schedule.</LI>
<LI>Select "Custom" from the schedule [Type] dropdown menu.</LI>
<LI>Enter the date when the backup should be performed eg: Year 2021 , Month February and Day 15.</LI>
<LI>Configure start time to 20:00 from the dropdown menu.</LI>
<LI>Select "until full backup completed" from the [Stop] dropdown menu.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<H3>To delete an existing backup schedule:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI> 
<LI>Click on <img src="../images/save.png"> to continue.</LI>
</OL>
<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>

