<!DOCTYPE html>
<html>
<!-- Modified: 2022-04-27 -->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Manage Backup Set</h1>

<P>Here is a listing of the user's backup set, you can manage the backup set here.</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>Backup set name and Backup set ID, e.g. Weekly File Backup (1573037574817)  
        </td>
      </tr>
      <tr>
        <td width="20%">Type</td>
        <td>Backup set type.  
        </td>
      </tr>
      <tr>
        <td width="20%">Version</td>
        <td>Version of the backup application.
		</td>
      </tr>
      <tr>
        <td width="20%">Owner</td>
        <td>Hostname of the device where the backup set is run. 
        </td>
      </tr>
      <tr>
        <td width="20%">Timezone</td>
        <td>Timezone information will be automatically updated when user login <%=HelpManager.getObmShortName(request)%> or perform backup job to avoid the false alarm of missed backup job.
        </td>
      </tr>	  
      <tr>
        <td width="20%">Execute Job</td>
        <td>If the backup set type is Cloud File Backup or Microsoft 365 Backup, and it is set to Run on Server, you will see five choices under Execute Job.  They are: <b>Backup</b>, <b>Restore</b>, <b>Data Integrity Check</b>, <b>Space Freeing Up</b>, <b>Delete Backup Data</b>.
        </td>
      </tr>
</table>
<BR><BR>


<h3>To add a backup set:</h3>
<OL>
<LI>Click on the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Type in a meaningful backup set name.</LI> 
<LI>Enter correct backup set type. </LI>
<LI>Select the platform, Windows, Mac or Linux. (Select Linux for backup sets on FreeBSD, Synology or QNAP) </LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Add items/folder for backup.</LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Configure the backup schedule </LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Select the backup mode. </LI>
<LI> Add a destination by clicking the <img src="../images/round_add.png"> button.  Select the destination and click <img src="../images/add.png"></LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Option: Enable OpenDirect by checking the checkbox. (Applicable only to File backup sets on Windows) </LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Configure Windows User Authentication credentials. (Applicable to all backup sets on Windows) </LI>
<LI>Click <img src="../images/save.png"> to save.</LI>

</OL> 
<BR><BR>

<H3>To delete an existing backup set:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
</OL>
<BR><BR>
<BR><BR>

<!--Backup-->
<hr>
<h2 class="colorUserManagement">Backup</h2>
<P>You can run backup jobs for backup sets of Cloud File or Microsoft 365 files which includes the mailbox, OneDrive, Teams, Sharepoint and Public Folders. Below are the items you can configure before starting the backup.</P> 
<BR><BR>

    
<!--H3>In-File Delta type</H3>
<P>In-File delta technology is an advanced data block matching algorithm with the intelligence to pick up changes (delta) of file content between two files.
<p>Using this algorithm, daily backup of large files over low-speed internet connection is made possible because it requires only the changes of information since the last backup to be sent over (assumming that the full backup of the file has been saved on the storage already).</P> 
<BR><BR>
    
<H4>Full file backup</H4>
<p>A full backup backs up all files in full, providing the fastest restore time as the restore would only require one set of data. But it is the most time-consuming, storage space-demanding and the least flexibility compared with delta backup.</p>
<BR><BR>
    
<H4>Differential In-File delta</H4>
<p>The delta is generated by comparing with the last uploaded full file only. Delta generated with this method will grow daily and uses more bandwidth. However, for restoration, only the full file and a single delta are required to be restored and merged.</p>
<BR><BR>
    
<H4>Incremental In-File delta</H4>
<p>The delta is generated by comparing with the last uploaded full or delta file. Delta generated with this method is smaller and uses the least bandwidth. However, for restoration, the full file and all deltas chain up to the required point-in-time are required to be restored and merged. This is prone to data lost (e.g. broken delta chain).</p>
<BR><BR>
    
<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="40%">Full</td>
        <td>Full file backup.
        </td>
      </tr>
     <tr>
        <td width="40%">Differential</td>
        <td>Differential In-File delta.
        </td>
      </tr>
      <tr>
        <td width="40%">Incremental</td>
        <td>Incremental In-File delta.
        </td>
      </tr>
</table>
<BR><BR>
<BR><BR-->
    

<!--Migrate Data-->

<H3>Migrate Data</H3>
<P>The migrate data option will only affect pre-<%=HelpManager.getCbsShortName(request)%> v9 backup data if ticked. All previously backed up data (v8 or earlier) will be re-uploaded and migrated to the latest version, which is v9. </p>
<P>This will not affect backup data which is already in v9 even if the checkbox is ticked. </P>
<BR><BR>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="40%">Migrate existing data to latest version</td>
        <td>Check this box to migrate data to the latest version.
        </td>
      </tr>
</table>
<BR><BR>
<BR><BR>

	
<!--Retention Policy-->

<H3>Retention Policy</H3>
<P>Retention policy defines the policies of persistent data management for meeting business data archival requirements.
<p>When a backup job is performed, data that is modified or deleted on your computer, as well as the previously backed up files on the backup storage will be moved to the retention area, while newly backed up file will be placed in the current data area.
<p>Specifically, retention policy setting defines how long are these data kept within the retention area before they are deleted permanently from the backup storage.</P> 
<BR><BR>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="40%">Run retention policy after backup</td>
        <td>Check this box to run retention policy after backup.
        </td>
      </tr>
</table>
<BR><BR>
<BR><BR>
    
<!--Restore -->
<hr>
<h2>Restore</h2>
<p>You can select what to restore on this page. </p>

<BR><BR>
    
<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Restore items from</td>
        <td>You can either select <b>Users</b>, <b>Teams</b>, <b>SharePoint Sites</b> or <b>Public Folders</b>. This option is only available for Microsoft 365 backup.
        </td>
      </tr>
      <tr>
        <td width="20%">Select What To Restore</td>
        <td>You can either select <b>Choose from files as of job</b> or <b>Choose from ALL files</b>. In addition, you can select the date and time from the dropdown lists.
        </td>
      </tr>
      <tr>
        <td width="20%">Left hand side folder hierarchy</td>
        <td>The tree structure on the left hand side of page displays the folder structure of your restore source.
        </td>
      </tr>
      <tr>
        <td width="20%">Right hand side list of files</td>
        <td>The files on the right hand side of the page displays a list of files that you have chosen to be your restore source.
        </td>
      </tr>
      <tr>
        <td width="20%">Show filter</td>
        <td>Allows filtering of files to narrow down the list of files.
        </td>
      </tr>
</table>
<BR><BR>
    
<h3>To select the restore source:</h3>
<OL>
<LI>Check the folders on the left that you want to restore.</LI>
<LI>Check the files on the right that you want to restore.</LI> 
<LI>Click <img src="../images/next.png"> to continue.</LI>
</OL> 

<BR><BR>

<!--h3>To filter the restore source:</h3>
<OL>
<LI>Click on 'Show Filter'.</LI>
<LI>Select where items can be searched from the 'Kind' drop down box.  You have the option to search from <b>Files and Folders</b>, <b>Files only</b>, <b>Folders only</b>, <b>Mail-Subject</b>, <b>Mail-From</b>, <b>Mail-To</b>, <b>Mail-CC</b>, <b>Mail-BCC</b>, <b>Mail-Received Date</b> and <b>Mail-Sent Date</b>.  </LI>
<LI>Select how the pattern will be matched from the 'Type' drop down box.  You can select whether it <b>contains</b>, <b>exact</b>, <b>starts with</b> and <b>ends with</b> the pattern.  </LI>
<LI>Specify the pattern that will be used for comparison.  </LI> 
<LI>Check the 'Match case' checkbox if you want to exactly match the case of the pattern.</LI>
<LI>Click [Apply] once done. </LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
</OL--> 

<BR><BR>
<BR><BR>
<!--Restore Destination-->
<hr>
<h2>Restore Destination</h2>
<p>You can restore your files or folders to the original location or to an alternate location. </p>
<BR><BR>


<H3>Key:</H3>
<h4><I>Restore File To</I></h4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="60%">Field</td>
        <td class="titles">Description</td>
      </tr>
     <tr>
        <td width="60%">Original location</td>
        <td>Restore backup file to original location.
        </td>
      </tr>
      <tr>
        <td width="60%">Alternate location</td>
        <td>Restore backup file to an alternate location.
        </td>
      </tr>
</table>

<BR><BR>
<H3>Overwrite when exist</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
     <tr>
        <td width="20%">Verify checksum of in-file delta files during restore</td>
        <td>Check this box to overwrite your existing files during restore.
        </td>
      </tr>
</table>
<BR><BR>


<BR><BR>
<H3>Verify checksum of in-file delta files</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
     <tr>
        <td width="20%">Verify checksum of in-file delta files during restore</td>
        <td>Check this box to verify the checksum of in-file delta files while performing the restore.
        </td>
      </tr>
</table>
<BR><BR>
    
<h3>To select the restore destination:</h3>
<OL>
<LI>Select either <b>Original location</b> or <b>Alternate location</b></LI>
<LI>If you select Alternate location, you need to enter the location you want in the text box.</LI> 
<LI>Check the box next to Verify checksum of in-file delta files during restore if you want the checksum of in-file delta files verified while performing the restore.</LI>
<LI>Click <img src="../images/ico_24_restore.png" width="20" height="20"> to continue.</LI>
</OL> 

<BR><BR>
<BR><BR>

<!--Data Integrity Check-->
<hr>
<h2>Data Integrity Check</h2>
<P>The Data Integrity Check will check all files on selected destination that has been backed up by <%=HelpManager.getCbsShortName(request)%>. Regular Cyclic Redundancy Check (CRC) is recommended to ensure data integrity.
<p>During the checking, it will check the size of the backup file and the CRC value of the backup file. Files will be deleted if it is found to be invalid or corrupt in the retained area and current folder. Other affected files in the delta chain may also be deleted.<p>
</p>
<BR><BR>
    
<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="60%">Field</td>
        <td class="titles">Description</td>
      </tr>
     <tr>
        <td width="60%">Run Cyclic Redundancy Check (CRC) during data integrity check</td>
        <td>Check this box to run CRC during data integrity check.
        </td>
      </tr>
      <tr>
        <td width="60%">Rebuild index</td>
        <td>Check this box to rebuild the index.
        </td>
      </tr>
	  <tr>
        <td width="60%">Empty all files in recycle bin</td>
        <td>Check this box to delete all the files in the recycle bin.
        </td>
      </tr>
</table>
<BR><BR>
<BR><BR>
    
<!--Space Freeing Up-->
<hr>
<h2>Space Freeing Up</h2>
<p>In order to free up your storage space, you can remove obsolete files from your backup destination according to your retention policy setting.</p>
<BR><BR>
    
<H3>To perform space freeing up:</H3>
<OL>
<LI>Select 'Space Freeing Up'.</LI>
<LI>Click [Run] to begin.</LI>
<LI>In case you need to stop the progress, press the [Stop] button to quit.</LI>
<!--LI>When the free up storage space has finished, click on the [View log] button to check on the logs.</LI>
<LI>Click [Close] to quit.</LI-->
</OL>
<BR><BR>
<BR><BR>

<!--Delete Backup Data-->
<hr>
    <h2>Delete Backup Data</h2>
<p>You can delete the backup data of a specific backup set. This action will physically delete all the files in the backup set regardless of your retention policy. Make sure you know what you are deleting before you proceed.</p>

<BR><BR>
    
<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="30%">Field</td>
        <td class="titles">Description</td>
      </tr>
     <tr>
        <td width="30%">Delete all backed up data</td>
        <td>You can delete all the data on the selected backup set on the selected destination.
        </td>
      </tr>
      <tr>
        <td width="30%">Choose from files as of job</td>
        <td>You can select the files from a backup snapshot.
        </td>
      </tr>
      <tr>
        <td width="30%">Choose from ALL files</td>
        <td>You can select any files in the backup set.
        </td>
      </tr>
</table>

    
<h3>To delete the backup data:</h3>
<OL>
<LI>Select 'Delete Backup Data'.</LI>
<LI>Click [Run].</LI>
<LI>Select what to delete.</LI>
<!--LI>A warning message will appear, click [Confirm] to delete all files or [Cancel] to cancel operation.</LI-->
<LI>Click <img src="../images/ico_24_delete.png" width="20" height="20"> to start deleting.</LI>
</OL> 
<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>
