<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />

<style>
#warningContainer {
	display:block;
	margin:20px 10% 10px 40px;
	padding:10px;
	width:80%;
	text-align:left;
	border:1px solid #ff0000;
}
#warningContainer p {margin:0 0 0 36px; padding:0; color:#ff0000; text-align:justify; font-weight:bold;}
#warningContainer ol, #warningContainer ul {color:#090; text-align:justify; margin-left:20px;}
#warningContainer .icon {
	display:block;
	float:left;
	color:#FFF;
	font-family:sans-serif, Verdana, Arial;
	font-size:18px;
	line-height:18px;
	background-color:#ff0000;
	padding:2px 10px 5px 10px;
	-moz-border-radius:12px;
	-webkit-border-radius:12px;
	border-radius:12px;
	-moz-box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	-webkit-box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	margin-top:-4px;
}
</style>
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Data Migration</h1>
<P>The data migration is designed to migrate backup sets that were created in v6 backup server to v7 backup set format.</P>
<BR>
<P>In v6 backup set, all the backup files are stored as individual files in the user home. In v7, small files (16MB or smaller) are merged into one 16MB data block, while large file are split into multiple 32MB data blocks and stored in the user home.</P> 
<BR>
<P>The data migration process converts the v6 backup files into v7 backup set format, it will read small files that were stored in v6 backup set, and write a number of small files into a new data blocks. For a large file, the process will read a fixed amount of data which is equals to a data block size from the selected large files, and rewrite the data block in to a new data block file. This process will be continued until the large file has completed to write the data into multiple new data blocks.</P>
<BR>
<P>After the data is migrated to v7 format, the backup set is now compatible with other server functions such as backup, restore and multiple thread replication, and the performance can be run at its optimal speed.</P> 
<div id="warningContainer">
	<div class="icon">!</div>
   <p>Warning: As the migration process is <B>NOT</B> reversible. You will not be able to downgrade to v6. If you downgrade your backup server to v6, the migrated data in v7 will not be able to use. All historical backup are lost and you need to start over the backup again in v6. Please communicate with your clients and check if they are comfortable with this.</p>
</div>
<BR>
<h3>Suggestion and Requirement</h3>
<P>The data migration process will perform the backup set migration one by one. To avoid heavy I/O on the disk/CPU utilization on your backup server, or the user home is stored in network drives/NAS devices. We suggest you to perform the data migration in a small batch of users to test the performance on your environment. This would minimize any possible impact on the I/O usage or affect your current operation. </P>
<BR>
<P>The data migration will be carried out if the following are met: </P>
<OL>
<LI>Both <%=HelpManager.getCbsShortName(request)%> and <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> are upgraded to v7.7 or later version.</LI>
<LI>More than 100GB of free space in each user home on your backup server.</LI>
<LI>For large backup sets that are more than 100GB of total size, please reserve more than 150% of the free space on the user home for the data migration. This is because the migration process will read the v6 backup data and write the v7 format to new location. After the migration, the reserved space will be recovered.<BR><BR>
Free Space = Largest v6 backup set on the user home X 150%
<BR><BR>
For example: A 150GB backup set, please reserve at least 225GB of free space for the migration.
<BR><BR>
</LI>
</OL>
<BR>
<P>If these requirements are not met, the data migration will not be started.</P>
<BR>
<P>If these requirements are not met, the data migration will not be started. You may found the following entry in the [Activities Log] available in your <%=HelpManager.getCbsShortName(request)%> , [Monitoring] -> [Administration Logs] </P>
<BR>
<P>Eg: MigrateV6DataError [Thread][Job][MigrateV6File]Error Migrating v6 data of user ... is too big to be migrated to ...</P>
<BR>
<P>By selecting the filter "MigrateV6DataError" from the filter drop down box, you can collect the errors related to the data migration.</P>
<BR>
<P>Reminder:</P>
<P>If data replication has been turned on, after the v6 data migrated to the v7 format, the replication will start to replicate new v7 format backup set to the replication server or to a predefined destination. You may noticed that the storage of that user will be doubled for a short period of time. For example:  the replicated v6 backup set is 10GB, after the data migration, another 10GB will be used for replicating the new v7 format backup set.  After the synchronization is completed, there is a mechanism to clean up the old migrated v6 data automatically</P>
<BR><BR>

<h3>Limitation</h3>
<P>When the data migration starts, all clients with pending migration status, the activities related to data operation such as space freeing up, data integrity check cannot be performed. </P>
<BR><BR>

<h3>How to perform the data migration</h3>
<OL>
<LI>Upgrade both <%=HelpManager.getCbsShortName(request)%> and <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> to version 7.7 or above.</LI>
<LI>Administrator need to enable the data migration feature in <%=HelpManager.getCbsShortName(request)%> &gt; [Backup / Restore] &gt; [Basic] &gt; [Backup Data Migration] .</LI>
<LI>Administrator needs to check if any backup set should be excluded in this data migration operation. <BR>
For example, when we need to limit the number of migration in a small batch of backup sets, we can exclude some of the backup sets from the interface.</LI>
<LI>Once the backup runs on the client machine, the index migration starts on the client machine. </LI>
<LI>When the index migration finished, the <%=HelpManager.getCbsShortName(request)%> will arrange the data migration on the backend. </LI>
<LI>Administrator can check the migration activity through the [Monitoring] &gt; [Administration Logs] &gt; [Activities Log].<BR>
By selecting the filter "MigrateV6DataInfo" or "MigrateV6DataError" from the filter drop down box, you can collect the logs related to the data migration.</LI>
<LI>When the data migration completed on a client's backup set. You will see the following in the activities log. <BR>
<PRE>MigrateV6DataInfo [Thread][Job][MigrateV6File] End: migrate v6 data.</PRE></LI>
<LI>On the next backup, that client will use the new index and new migrated data for the backup operation. This will also trigger the backup server to remove old v6 backup data on an hourly clean up job.<BR>
<PRE>MigrateV6DataInfo [HourlyJob]Start: Remove migrated v6 data
MigrateV6DataInfo [HourlyJob] End: Remove migrated v6 data.</PRE>
</LI>
</OL>
<BR>
<P>Note:</P>
<OL>
<LI>In case the index migration stops for any reason, on the next backup, the index migration can resume from the last recorded progress.</LI>
<LI>For backup sets such as Exchange DAG, when one of the node triggered the index migration when backup runs, all other nodes will wait for the first node to complete the index migration, and all other nodes will reload the new index file. </LI>
<LI>During the old v6 backup data removal, the performance on the user home which stores the v6 backup data could be slow down.</LI>
</OL>
<BR><BR>
<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Migrating File</td>
        <td>Files that is currently converting on the <%=HelpManager.getCbsShortName(request)%>. 
        </td>
      </tr>
      <tr>
        <td width="20%">Number Of Migrated File</td>
        <td>Number of files migrated on the <%=HelpManager.getCbsShortName(request)%>.
        </td>
      </tr>
      <tr>
        <td width="20%">Login Name (Alias)</td>
        <td>Login name of the user that required to exclude the backup set data migration.
        </td>
      </tr>
      <tr>
        <td width="20%">Backup Set</td>
        <td>The backup set that required to be excluded from data migration.
        </td>
      </tr>
</table> 
<BR><BR>
<h3>To add the exclusion of a v6 backup set from the data migration:</h3> 
<OL>
<LI>Click on the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Select the login name and backup set that needs to be excluded from the data migration.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
</OL>
<BR><BR>
<H3>To delete an existing exclusion of a v6 backup set:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>

<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
