<!DOCTYPE html>
<html>
<!-- Modified: 2022-04-27 -->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Backup Client Settings</h1>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Backup Client</td>
        <td>Type of backup user account, <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%>.  
      </td>
      </tr>
</table>
<BR><BR>
<BR><BR>
<hr>
<H3>Add-on Modules</H3>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
		<td class="titles"><%=HelpManager.getObmShortName(request)%></td>
		<td class="titles"><%=HelpManager.getAcbShortName(request)%></td>
      </tr>
	  
	  <tr>
        <td width="20%">Continuous Data Protection</td>
        <td>Module for backing up continuously. Windows only. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr>
	  
	  <tr>
        <td width="20%">Volume Shadow Copy</td>
        <td>Module for backing up open files using volume shadow copy. Windows only. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr>
	  
	  <tr>
        <td width="20%">In-File Delta</td>
        <td>Module for backing up file using In-File Delta. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr>
	  
	   <tr>
        <td width="20%">Deduplication</td>
        <td>Module for backing up file using Deduplication. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr>
	  	  
	  <tr>
        <td width="20%">OpenDirect / Granular Restore</td>
        <td>Module enable file-level restore from guest VMs or compressed/image files. Applicable only to File / Hyper-V / VMware backup sets on Windows platform. </td>
		<td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr>
	  
	  <tr>
        <td width="20%">NAS - QNAP</td>
        <td>Module for backing up QNAP NAS device.  </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	  <tr>
        <td width="20%">NAS - Synology</td>
        <td>Module for backing up Synology NAS device.  </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	  
	  <tr>
        <td width="20%">Mobile</td>
        <td>Module for backing up mobile devices.  </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr>
	  
	  <tr>
        <td width="20%">Windows System Backup</td>
        <td>Module for backing up Windows System.  </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr>
	  <tr>
        <td width="20%">Windows System State Backup</td>
        <td>Module for backing up Windows System State. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	  
	   <tr>
        <td width="20%">Linux Bare Metal Backup</td>
        <td>Module for backing up volume groups in Linux. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
	  </tr>
	  
	  <tr>
        <td width="20%">ShadowProtect System Backup</td>
        <td>Module for backing up with ShadowProtect System Backup. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	  
	  <tr>
        <td width="20%">MySQL Database Server</td>
        <td>Module for backing up MySQL Database Server. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	  
	  <tr>
        <td width="20%">Microsoft SQL Server</td>
        <td>Module for backing up Microsoft SQL Server. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
       </tr>
	  
	   <tr>
        <td width="20%">MariaDB Database Server</td>
        <td>Module for backing up MariaDB Database Server. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
       </tr>
	  
	   <tr>
        <td width="20%">Oracle Database Server</td>
        <td>Module for backing up Oracle Database Server.  </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
       </tr>
	  
	   <tr>
        <td width="20%">Lotus Domino</td>
        <td>Module for backing up Lotus Domino Server. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
       </tr>
	  
	  <tr>
        <td width="20%">Lotus Notes</td>
        <td>Module for backing up Lotus Notes Client.  </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
       </tr>
	  
	   <tr>
        <td width="20%">Tibero Database Server </td>
        <td>Module for backing up Tibero Database Server. </td>
        <td>&#x2714;</td><!-- Tick -->
        <td>&#x2718;</td><!-- Cross -->
       </tr>
	  	  
      <tr>
        <td width="20%">Microsoft Exchange Server</td>
        <td>Module for backing up Microsoft Exchange Server. </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
   	  </tr>
	  
	  <tr>
        <td width="20%">Microsoft Exchange Mailbox</td>
        <td>Module for backing up Microsoft Exchange Mailbox.  </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	  
	  <tr>
        <td width="20%">PostgreSQL Server </td>
        <td>Module for backing up PostgreSQL Server. </td>
        <td>&#x2714;</td><!-- Tick -->
        <td>&#x2718;</td><!-- Cross -->
      </tr>
	  
	   <tr>
        <td width="20%">VMware</td>
        <td>Module for backing up VMware.  
        </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	  
	   <tr>
        <td width="20%">Hyper-V</td>
        <td>Module for backing up Hyper-V.   
        </td>
	    <td>&#x2714;</td><!-- Tick -->
		<td>&#x2718;</td><!-- Cross -->
      </tr>
	        
      <tr>
        <td width="20%">Microsoft 365 Backup</td>
        <td>Module for backing up Microsoft 365 files which includes mailbox, OneDrive and SharePoint. You can define the number of Microsoft 365 accounts that can be backed up. <b>For <%=HelpManager.getAcbShortName(request)%> users the maximum number of Microsoft 365 account allowed is two.</b> 
        </td>
	   <td>&#x2714;</td><!-- Tick -->
		<td>&#x2714;</td><!-- Tick -->
      </tr> 
</table>
<BR><BR>
<BR><BR>
<hr>

<H3>Quota</H3>
<P>"Quota" is the storage quota reserved on the user account for all or per backup destination of backup data, both predefined and standard destination.</P> 
<div id="tipsContainer"><div class="icon">!</div>
<p>Please kindly note that:</p>
<OL>
<LI>Quota management for individual predefined destination is only available for <%=HelpManager.getCbsShortName(request)%> version 7.15.6.0 or above</LI>
<LI>For the destination not shown in the Quota table, the storage space is unlimited. </LI>
<LI>If preempted mode is enabled in policy settings, the quota settings here is disabled. </LI>
</OL>
</div>
<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
	  <tr>
        <td width="20%">Quota</td>
        <td>Can be "Total Quota" or "Per Destination Quota".  By default "Per Destination Quota" is selected.  
		</td>
      </tr>
	  <tr>
        <td width="20%">Total Quota</td>
        <td>Total quota for all the backup destination. Will only be displayed if "Total Quota" is selected.
        </td>
      </tr>
      <tr>
        <td width="20%">Destination</td>
        <td>Name of the backup destination. Will only be displayed if "Per Destination Quota" is selected.
      </td>
      </tr>
	  <tr>
        <td width="20%">Quota</td>
        <td>Backup Quota for the backup destination. Will only be displayed if "Per Destination Quota" is selected.
        </td>
      </tr>
</table>

<BR>
<OL>
<LI>Select the quota. </LI>
<LI>The fields displayed will depend on the quota selected:
    <UL>
	    <LI>If "Total Quota" is selected, enter the total quota. </LI>
		<LI>If "Per Destination Quota" is selected. <br>
		Option: Click <img src="../images/round_add.png"> to add the backup destination.<br>
        Option: Enter the "Quota" and select the file size unit.<br>
        Click <img src="../images/add.png"> to continue.</LI>
	</UL> </LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>

<BR><BR>
<BR><BR>
<hr>

<!--Client Host Limit-->
<H3>Client Host Limit</H3>
<P>This is to limit the maximum number of host allowed in a client's backup account.</P>
<BR><BR>
<OL>
<LI>Enable the client host limit by checking the checkbox for this option. </LI>
<LI>Change the maximum client host allowed in the field.</LI>   
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>
<BR><BR>
<hr>
<!--Run Direct-->
<H3>Run Direct</H3>
<P>This is to limit the maximum number of concurrent Run Direct VMs on <%=HelpManager.getCbsShortName(request)%>.</P>
<BR><BR>
<OL>
<LI>Enable the run direct limit by checking the checkbox for this option. </LI>
<LI>Change the maximum number of Run Direct VMs allowed in the field.</LI>   
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
    
<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>
