<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">In-File Delta</h1>

<P>In-File delta technology is an advanced data block matching algorithm with the intelligence to pick up changes (delta) of file content between two files.
</P>
<P>Using this algorithm, daily backup of large files over low-speed internet connection is made possible because it requires only the changes of information since the last backup to be sent over (assuming that the full backup of the file has been saved on the storage already).
</P>
<BR><BR>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Default type</td>
        <td>Two types of In-File delta setting, "Incremental" and "Differential".
        </td>
      </tr>
      <tr>
        <td width="20%">In-File Delta block size</td>
        <td>Block size for the In-File delta, default "Auto". 
        </td>
      </tr>
	  <tr>
        <td width="20%">Only apply In-File Delta to files larger than</td>
        <td>By default, In-file delta logic will apply to the files that are larger than 25 MB.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Upload full file when either of these conditions is met</td>
        <td>There are 3 criteria that can trigger a full file upload instead of uploading a delta file, which can decrease the chance of broken chain.  
		    <UL>
		       <LI>The number of delta size is over 100 (by default), to avoid keeping a large number of delta chain.</LI>
			   <LI>The delta ratio is over 50% (by default).</LI>
			   <LI>Delta file failed to generate.</LI>
			</UL>
        </td>
      </tr>
	  <tr>
        <td width="20%">Weekly variations for overriding default type</td>
        <td>You can choose different In-File delta setting to override the default. For example, you can set Sunday to perform a full backup while the rest of the weekdays to perform the backup base on the default In-File delta type.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Yearly variations for overriding default type and weekly variations</td>
        <td>You can choose different In-File delta setting to override the default and weekly variations. For example, you can set a particular day in January to perform a full backup while the rest of the year to perform the backup base on the default In-File delta type.    
        </td>
      </tr>	  
	  <tr>
        <td width="20%">Day of the selected months in yearly variations</td>
        <td>This option is to work with the yearly variation, so that you will be able to select eg: 1st of January, March, May... to override the default In-File delta setting. 
        </td>
      </tr>		  
</table>
<BR><BR>

<H3>To enable In-File Delta:</H3>
<OL>
<LI>Slide the switch to right hand side to turn on the In-File delta option.</LI>
<LI>Select the delta option from the default type drop down. </LI>
<LI>Option: Click on the advanced option if you want to modify the advance In-File delta setting. </LI>
<LI>Option: Configure the In-File delta block size, default type is auto. </LI>
<LI>Option: Configure the apply In-File delta to files settings. Default is 25MB. </LI>
<LI>Option: Configure to upload full file according to the following creteria:</LI>
<UL>
<LI>When the number of delta is over the set value.</LI>
<LI>When the delta ratio (delta file size / full file size) is over the selected percentage.</LI>
<LI>When delta file cannot be generated.</LI>
</UL>
<LI>Option: Configure the weekly variation for overriding default In-File delta type. </LI>
<LI>Option: Configure the monthly variation for overriding default type and weekly variation setting.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<P>
<div id="tipsContainer"><div class="icon">!</div>
<p>In some cases, you can setup the basic settings to incremental and modify the weekly variation on Saturday to 'Full' and Wednesday as 'Differential', so that the In-File delta settings over the week will be shown as below. 
</p></div>
<BR>
<TABLE cellspacing="0" cellpadding="4">
<TR ALIGN=CENTER>
<TD class="firstTitles">Days:</TD><TD class="titles">Sat</TD><TD class="titles">Sun</TD><TD class="titles">Mon</TD><TD class="titles">Tue</TD><TD class="titles">Wed</TD><TD class="titles">Thu</TD><TD class="titles">Fri</TD><TD class="titles">Sat</TD>
</TR>
<TR ALIGN=CENTER>
<TD>&nbsp;</TD><TD>F</TD><TD>I</TD><TD>I</TD><TD>I</TD><TD>D</TD><TD>I</TD><TD>I</TD><TD>F</TD>
</TR>
<TR>
<TD COLSPAN=9>F = Full, D = Differential, I = Incremental.</TD>
</TR>
</TABLE>
<BR>
<P>		  
This is one of the method to leverage the backup time and restore time. If today is Friday, and you need to restore a file on Thursday, we need to download the Full backup on last Saturday, differential delta on Wednesday and incremental delta on Thursday. In this approach, we only requires to download 3 delta files to generate the file version on Thursday.  
</P>
<P>
<FONT COLOR=RED><Strong>Do not risk your data by enabling a large number of delta.</Strong></FONT> Long delta chain requires more time to download and merge on your machine, and in case there is a broken chain. The delta files cannot be merged, and cannot generate the file that you need.  
</P>
<BR><BR>

<h2>Background information</h2>
<h3>Full file backup</h3>
<P>A full backup backs up all files in full, providing the fastest restore time as the restore would only require one set of data. But it is the most time-consuming, storage space-intensive and the least flexible then delta backup. 
</P>
<BR>
<h3>Incremental In-File delta</h3>
<P>The delta is generated by comparing with the last uploaded full or delta file. Delta generated with this method is smaller and uses the least bandwidth. However, for restoration, the full file and all deltas chain up to the required point-in-time are required to be restored and merged. This is prone to data lost (e.g. broken delta chain).
</P>
<BR>
<h3>Differential In-File delta</h3>
<P>The delta is generated by comparing with the last uploaded full file only. Delta generated with this method will grow daily and uses more bandwidth. However, for restoration, the full file and a single delta is required to be restored and merged.
</P>
<BR>
<P>The following table summarizes the benefits and drawbacks of the 3 backup types:
</P>

<TABLE cellspacing="0" cellpadding="4">
<TR>
<TD class="firstTitles">Type</TD><TD class="titles">Benefits</TD><TD class="titles">Drawbacks</TD>
</TR>
<TR>
<TD VALIGN=TOP>Full</TD>
<TD VALIGN=TOP>Restoration is the fastest of all three types.</TD>
<TD VALIGN=TOP>Backup process is the slowest of all three types.<BR><BR>
Highest storage requirement.</TD>
</TR>
<TR>
<TD VALIGN=TOP>Differential</TD>
<TD VALIGN=TOP>Backup speed is faster than full backup.<BR><BR>
Restoration is faster than data backup with incremental In-File delta.<BR><BR>
Less storage space is need than a full backup.</TD>
<TD VALIGN=TOP>Restoration is slower than data backup with full backup.<BR><BR>
Backup process is slower than incremental In-file delta backup.</TD>
</TR>
<TR>
<TD VALIGN=TOP>Incremental</TD>
<TD VALIGN=TOP>Backup process is fastest of all three types.<BR><BR>
Least storage space is required.</TD>
<TD VALIGN=TOP>Restoration is the slowest of all three types.<BR><BR>
Prone to data lost.</TD>
</TR>
</TABLE>
<P>

<div id="tipsContainer"><div class="icon">!</div>
<p>For a small file eg: several megabytes, there is not much difference on running a full file backup or In-File delta backup. For a large file, eg: 10GB file, full file backup takes more time to finish and require more storage space. With in-file delta technology, we can pick up the delta change with intelligence and allow the backup to run faster with minimal storage required for storing backup snapshots.</p></div>
<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>
