<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
<link rel="stylesheet" type="text/css" href="lib/help.css" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Manage Backup Users</h1>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Login Name (Alias) </td>
        <td>The <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> account name.  
      </td>
      </tr>
	  <tr>
        <td width="20%">Owner</td>
        <td>The owner of the user account. 
        </td>
      </tr>
          <tr>
        <td width="20%">Client Version</td>
        <td>The version of the <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> used. This will only be visible if Default view is selected. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Add-on Modules</td>
        <td>User subscribed add-on modules. This will only be visible if Default view is selected.
        </td>
      </tr>
	  <tr>
        <td width="20%">Used / Client Host Limit</td>
        <td>The number of host used and maximum number of host allowed in the user's backup account. This will only be visible if Default view is selected. 
        </td>
      </tr>
	  
	  <!--tr>
	    <td width="20%">Destination</td>
        <td>The backup destination available in the user's backup account.  This will only be visible if Quota view is selected. 
        </td>
      </tr-->
	  <tr>
	    <td width="20%">Used/Quota/Deduped/Recycle Bin</td>
        <td>The used storage, storage quota, deduped storage and recycle bin storage per backup destination.  This will only be visible if Default view is selected. 
        </td>
      </tr>
	  <!--tr>
	    <td width="20%">Compressed</td>
        <td>If the backup data is compressed or not.  This will only be visible if Quota view is selected. 
        </td>
      </tr-->
	  <tr>
	    <td width="20%">Legacy Client</td>
        <td>If the user backup account is a legacy client or not.  This will only be visible if 2FA view is selected. 
        </td>
      </tr>
	  <tr>
	    <td width="20%">Two-Factor Authentication</td>
        <td>Whether two-factor authentication is enabled or disabled.  This will only be visible if 2FA view is selected.
        </td>
      </tr>
	  <tr>
        <td width="20%">Status</td>
        <td>The account status of this user. 
        </td>
      </tr>
</table>
<BR><BR>

<P>There are eleven (11) functions available for each backup user:</P>
<UL>
<LI><img src="../images/ico_24_add.png" class="round_button"> <b>Create</b> - this is used to create a new <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> backup user account.</LI>
<LI><img src="../images/ico_24_delete.png" class="round_button"> <b>Delete</b> - this is used to delete an existing backup user account.</LI>
<LI><img src="../images/ico_24_auto_update.png" class="round_button"> <b>Auto Update</b> - this is used to configure the automatic upgrade for <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> client to the latest version.</LI>
<LI><img src="../images/ico_24_broadcast.png" class="round_button"> <b>Broadcast</b> - this is used to send messages to <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user account.  Message will be sent to the email address that was provided in the contacts for each user account.  This is very useful when there is an announcement that must be sent to users, i.e. backup server system maintenance.</LI>
<LI><img src="../images/ico_24_backup.png" class="round_button"> <b>Initiate Backup Job</b> - this allows for backup jobs to be started remotely without accessing the client machine.</LI>
<LI><img src="../images/ico_24_restore_drill.png" class="round_button"> <b>Run Restore Drill</b> - this is used to run the restore drill manually.</LI>
<LI><img src="../images/ico_24_export.png" class="round_button"> <b>Export Users' Usage Statistic to CSV</b> - this is used to export details of usage of a user to a csv file.</LI>
<LI><img src="../images/ico_24_export_user.png" class="round_button"> <b>Move / Import / Export Users</b> - this is used to migrate backup users from one <%=HelpManager.getCbsShortName(request)%> server to another or from one user home to another. Move the backup user from one owner to another.  It can also be used to import or export a backup user to a zip file.</LI>
<LI><img src="../images/ico_24_stat.png" class="round_button"> <b>Rebuild Storage Statistics</b> - this is only applicable for backup sets created in version 6 which have not been migrated to <%=HelpManager.getCbsShortName(request)%> block storage format.  This is used to enhance the accuracy of its storage statistics.</LI>
<LI><img src="../images/ico_24_rescan_userhome.png" class="round_button"> <b>Rescan all user home directories</b> - this is used to ensure the status of all user home is updated.  This will only list backup sets of available user home which helps to guarantee that backup and restore job will run properly.</LI>
<LI><img src="../images/ico_24_mfa.png" class="round_button"> <b>Enable / Disable Two-Factor Authentication</b> - this is used to enable or disable the 2FA feature for several users all at once.</LI>
</UL>

<BR>

<P>There are seven (7) filters that can be used to narrow down the results and change the displayed information of the backup user:</P>
<UL>
<LI><b>Client Type</b> - backup users can be filtered based on type either <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%> client.  By default, it displays backup users belonging to all client types.</LI>
<LI><b>User</b> - backup users can also be filtered based on the first letter of its login name.  It can also be based on subscription type which is Paid or Trial.  It can also be based on status which is Enable, Suspended or Locked.  Additional criteria are Others and Inactive.  By default, the backup users are displayed alphabetically.</LI>
<LI><b>Registration Date</b> - backup users can be filtered based on the date they were registered.  The choices are Today, Last 7 days, Last 30 days and Last 100 days.  By default, it displays all backup users created.</LI>
<LI><b>User Group</b> - backup users can be filtered based on the user group it belongs to.  By default, it displays all backup users belonging to all user groups.</LI>
<LI><b>Auto Update</b> - backup users can be filtered based on the status of its auto update if it is Enabled or Disabled.  By default, all backup users are displayed.  This is only available in Default view.</LI>
<LI><b>Owner</b> - backup users can be filtered based on the owner of the user account.  By default, all backup users are displayed.</LI>
<LI><b>View</b> - the information displayed regarding the backup user may be changed by changing the view.  There are two (2) views available which are Default or 2FA.  By default, the Default view is displayed.</LI>
</UL>



<h3>To add a new user account:</h3>
<OL>
<LI>Click on the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Enter the "Login Name", "Password" in the boxes.</LI> 
<LI>Select the "Owner" from the dropdown box. </LI>
<LI>Option: Select the user group to join or add a new user group.</LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Enter the "Alias" and select other options such as "Home Directory", "Subscription Type" and other details.</LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Select the "Backup Client" type, "Add-on Modules", assigned "Quota" and "Client host limit" for this user. 
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Click on <img src="../images/round_add.png"> to add contact details for this customer.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 
<BR><BR>
<H3>To modify an existing user account:</H3>
<OL>
<LI>Click on an existing user account.</LI>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>
<H3>To delete an existing user account:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [CONFIRM TO DELETE!] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>
<BR><BR>
<!--hr>
<h3>Export Users' Usage Statistics to CSV</h3>
<P>To export user' usage statistic to a CSV (Comma Separated Values) file. Which you can import to other tools such as Excel or database for further purpose.</P> 
<BR><BR>

<h3>To export users' usage statistics to CSV:</h3>
<OL>
<LI>Select the user(s) that you want to export their usage.</LI>
<LI>Click on the [Export Users' Usage Statistics to CSV] button in this section. </LI>
<LI>Choose what to do with the CSV file e.g. Open or Save</LI> 
</OL--> 

<BR><BR>
<BR><BR>




</div>
<jsp:include page="footer.jsp" />
</body>

</html>
