<!DOCTYPE html>
<html>
<!-- Modified: 2022-04-28; Version: 9.1.6.0 -->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>
--
<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Add New Backup Set</h1>

<P>You can create a Microsoft 365 backup set here in the Backup Server.  It allows you to backup your Outlook, OneDrive, Personal Site, Teams, SharePoint and Public Folders from your Microsoft 365 account.  For more information regarding requirement on the setup, please also refer to the help document for either <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%>.</P>

<h2>Requirements</h2>
<p>You are strongly recommended to configure or check all the settings below to confirm if all the requirements are met before you proceed with the Microsoft 365 backup and restore. </p>
<BR>
<OL>
<LI>Make sure that the latest version of <%=HelpManager.getObmShortName(request)%>, <%=HelpManager.getAcbShortName(request)%> or <%=HelpManager.getCbsShortName(request)%> is installed on your computer with Internet access for connection to your Microsoft 365 account. </LI>

<LI>For Agentless (Run on Server) backups, a valid <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user account is required before you can access the <%=HelpManager.getCbsShortName(request)%> User Web Console. </LI>

<LI>As <%=HelpManager.getObmShortName(request)%> and <%=HelpManager.getAcbShortName(request)%> licenses are calculated on a per device basis:
  <UL>
  <LI>For Agentless (Run on Server), to be able to backup users using <%=HelpManager.getCbsShortName(request)%> User Web Console, one (1) <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%> license is required.</LI>
  <LI>For Agent-based (Run on Client), to backup users with one (1) backup client computer, the number of <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> license required is one (1).  For example, if one <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> is installed, then one (1) <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> license is required. </LI>
  <LI>For Agent-based (Run on Client), to backup users with multiple backup client computers, the number of <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> licenses required is equal to the number of devices.  For example, if there are ten (10) backup sets to backup across three (3) backup client computers, then three (3) <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> licenses are required. </LI>
  </UL>

<LI>Make sure that the Microsoft 365 Backup feature has been enabled as an add-on module in your <%=HelpManager.getObmShortName(request)%> and <%=HelpManager.getAcbShortName(request)%> user account and there is enough Microsoft 365 Backup license quota to cover the backup of your users.
<BR>The license for the Microsoft 365 module are calculated by the number of unique licensed or unlicensed Microsoft 365 user accounts.  If same Microsoft 365 account is backed up on multiple backup sets with an <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user account, it would be counted as one Microsoft 365 license.
	<UL>	
	<LI>Each licensed or unlicensed Microsoft 365 user account selected for backup requires one Microsoft 365 license.</LI>
	<LI>Each Equipment Mailbox, Room Mailbox, or Shared Mailbox selected for backup requires one Microsoft 365 license.</LI>
	<LI> If just only SharePoint Sites under the Site Collections and/or files of folders under Public Folder are selected for backup, this requires only one Microsoft 365 license.</LI>
	</UL>
However, if any items from either Outlook, Items from OneDrive, or Personal Sites under Users are selected for backup, the Microsoft 365 license count will be calculated based on the number of user account selected.</p>
</LI>			
		
<LI><b>Backup Quota Requirement</b> - make sure that your <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%> user account has sufficient quota assigned to accommodate the storage of the Microsoft 365 users for the new backup set and retention policy. </LI>

<LI>A licensed Exchange Administrator or a licensed user with Public Folder permission is required otherwise you will not be able to access the public folder to select items for backup or restore. </LI>

<LI>The default Java heap setting 2048M, is sufficient for Microsoft 365 backups based on the default 4 concurrent backup threads.
<br>The Java heap size should only be increased if the number of current backup threads is increased as more backup threads is expected to consume more memory. But this does not guarantee that the overall backup speed will be faster since there will be an increased chance of throttling.
</LI>
			
<LI>The following subscription plans with Microsoft 365 email services are supported to run backup and restore on <%=HelpManager.getCbsShortName(request)%> User Web Console.
	<table cellspacing="0" cellpadding="4" >
	<tr>
		<td class="firstTitles" width="15%">Microsoft 365 Business</td>
		<td class="titles" width="15">Microsoft 365 Business Essentials</td>				
	</tr>
	<tr>
		<td class="firstTitles" width="15%">Microsoft 365 Business Premium</td>
		<td class="titles" width="15%">Microsoft 365 Entrprise E1</td>
	</tr>
	<tr>
		<td class="firstTitles" width="15%">Microsoft 365 Entrprise E3</td>
		<td class="titles" width="15%">Microsoft 365 Entrprise E4</td>
	</tr>			
	<tr>
		<td class="firstTitles" width="15%">Microsoft 365 Entrprise E5</td>
		<td class="titles" width="15%">Microsoft 365 Education</td>
	</tr>			
</table>
</LI>	
			
<LI>Make sure your Microsoft 365 subscription with Microsoft is active in order to enjoy all privileges that come along with our backup services. If your account has expired, renew it with Microsoft as soon as possible so that you can continue to enjoy the Microsoft 365 backup services.
<BR>When your account is expired, depending on your role, certain access restrictions will be applied to your account.
<BR>Refer to the URL for more details: <a href="https://support.office.com/en-us/article/What-happens-to-my-data-and-access-when-my-Office-365-for-business-subscription-ends-4436582f-211a-45ec-b72e-33647f97d8a3#BKMK_TrialEnds ">Microsoft 365 Subscription Status </a>
</LI>
			
<LI><B>Microsoft 365 Permission Requirements for <%=HelpManager.getObmShortName(request)%></B> - The basic permissions required by a Microsoft user account for authentication of an <%=HelpManager.getObmShortName(request)%> Microsoft 365 backup set is as follows:
<UL>
<LI><B>Global Admin Role</B>
<BR>Starting with <%=HelpManager.getCbsShortName(request)%> v8.3.6.0 or above, the Microsoft 365 account used for authentication must have Global Admin Role, since Modern Authentication will be used.<BR>
This is to ensure that the authorization configuration requirements will be fulfilled (e.g. connect to Microsoft Azure AD to obtain the App Access Token). To assign the role, please refer to <B>Assigning Global Admin Role to Accounts</B>.
</LI>

<LI><B>Term Store Admininistrator Role</B>
<BR>The Term Store Administrator Role may be required for backup and restore of SharePoint items. To assign the role, please refer to <B>Granting Term Store Administrator Role</B>.
</LI>
<LI>A member of <B>Discovery Management</B> security group
<BR>The <B>Discovery Management</B> security group must be assigned the following roles. To assign the role, please refer to <B>Granting Permission to Discovery Management Group</B>.<BR>
 
	<UL>
	<LI>Legal Hold</LI>
	<LI>Mailbox Import Export</LI>
	<LI>Mailbox Search</LI>
	<LI>Public Folders</LI>
	</UL>
	</LI>
</UL>
	
<BR>Otherwise, proceed to grant all necessary permissions to the Microsoft user account as shown in the following instructions.<BR>

<BR><B>Assigning Global Admin Role to Accounts</B><BR>
To assign the Global Admin role to accounts, follow the steps below:
	<OL>
	<LI>Click the App launcher in the upper left side then click <B>Admin</B> to go to the Microsoft 365 admin center.</LI>
	<LI>In the Microsoft 365 admin center, on the left panel click <B>Users</B>. Find the user you want to assign the Global Admin and select <B>Manage roles</B>.</LI>
	<LI>In the Manage roles window, select <B>Admin center access</B> then check the box beside <B>Global admin</B>. Click <B>Save Changes</B> to save the role you assigned.</LI>
	</OL>

<BR><B>Granting Term Store Administrator Role</B><BR>
To add Term Store Administrator role to the Microsoft 365 user account used to authenticate the Microsoft 365 backup set.
	<OL>
	<LI>In the SharePoint admin center, under <B>Content services</B>, click <B>Term store</B>.</LI>
	<LI>In the tree view pane on the left, select the <B>Taxonomy</B>.</LI>
	<LI>In the Term store page, for Admins, select Edit. The <B>Edit term store admins</B> panel appears.</LI>
	<LI>Enter the names or email addresses of the Microsoft 365 user who you want to add as term store admins. Select <B>Save</B>.</LI>
	</OL>
	
	<BR><B>Granting Permission to Discovery Management Group</B><BR>
This permission allows users added under the <B>Members</B> section of the <B>Discovery Management</B> group (refer to <B>Granting Permission to Accounts for Creating Backup Set</B>) to back up and/or restore user item(s) not only for their own account, but also the accounts of other users in the same <B>Members</B> section.
	<OL>
	<LI>Open <a href="https://admin.exchange.microsoft.com">https://admin.exchange.microsoft.com</a>.</LI>
	<LI>Log in to the <B>Microsoft 365</B> as an account administrator.</LI>
	<LI>Select the <B>permissions</B> menu on the left, then double click on <B>Discovery Management</B> on the right.</LI>
	<LI>Click the <B>[+]</B> icon under the <B>Roles</B> section. These are the following roles:</LI>
		<UL>
		<LI>Legal Hold</LI>
		<LI>Mailbox Import Export</LI>
		<LI>Mailbox Search</LI>
		<LI>Public Folders</LI>
		</UL>
	<LI>Click <B>Save</B> to confirm and exit the setting.</LI>
	</UL>
	</OL>
	
	<BR><B>Granting Permission to Accounts for Creating Backup Set</B><BR>
	<OL>
	<LI>Open <a href="https://admin.exchange.microsoft.com">https://admin.exchange.microsoft.com</a>.</LI>
	<LI>Log in to the <B>Microsoft 365</B> as an account administrator.</LI>
	<LI>Select the <B>permissions</B> menu on the left, then double click on <B>Discovery Management</B> on the right.</LI>
	<LI>You can now add users to this group. Click the <B>[+]</B> icon under the <B>Members</B> section.</LI>
	<LI>Look for the username(s) of the account that you would like to add permission for, then click <B>Add</B> > <B>OK</B> to add the corresponding user(s) to the permission group.</LI>
	<LI>Click <B>Save</B> to confirm and exit the setting.</LI>
	</OL>
	
	
	
	<BR><B>Granting Permission to restore all share link types to alternate location in Microsoft 365</B><BR>
To successfully restore all share link types to alternate location of the same organization in Microsoft 365, follow the settings below:
	<UL>
	<LI>Allowing anonymous users to access application pages</LI>
	<OL>
	<LI>Click the App launcher, then click <b>SharePoint</b>. </LI>
	<LI>Click <B>Settings</B> > <B>Site Settings</B>.
	<LI>Under Site Collection Administration, click <B>Site Collection features</B>.</LI>
	<LI>Deactivate "<B>Limited-Access user permission lockdown mode</B>" feature.</LI>
	</OL>

	<LI>Allowing sharing to external users</LI>
	<OL>
	<LI>Go to your <B>Microsoft 365 Admin Center</B> > <B>All admin centers</B> > in the right pane select <B>SharePoint</B>.</LI>
	<LI>Go to <B>Policies</B> > <B>Sharing</B>.</LI>
	<LI>Under <U>External sharing</U> the button must be in line with "<B>Existing guests</B>" and click <B>Save</B>.</LI>
	</OL>
	</UL>
	
	
	
<LI><B>Microsoft 365 Permission Requirements for <%=HelpManager.getAcbShortName(request)%></B> - The basic permissions required by a Microsoft user account for authentication of an <%=HelpManager.getAcbShortName(request)%> Microsoft 365 backup set is as follows:
<UL>
<LI><B>Global Admin Role</B>
<BR>Starting with <%=HelpManager.getCbsShortName(request)%> v8.3.6.0 or above, the Microsoft 365 account used for authentication must have Global Admin Role, since Modern Authentication will be used.<BR>
This is to ensure that the authorization configuration requirements will be fulfilled (e.g. connect to Microsoft Azure AD to obtain the App Access Token). To assign the role, please refer to <B>Assigning Global Admin Role to Accounts</B>.
</LI>

<LI>A member of <B>Discovery Management</B> security group
<BR>The <B>Discovery Management</B> security group must be assigned the following roles. To assign the role, please refer to <B>Granting Permission to Discovery Management Group</B>.<BR>
 
	<UL>
	<LI>Mailbox Search</LI>
	<LI>Public Folders</LI>
	</UL>
	</LI>
</UL>
	
<BR>Otherwise, proceed to grant all necessary permissions to the Microsoft user account as shown in the following instructions.<BR>

<BR><B>Assigning Global Admin Role to Accounts</B><BR>
To assign the Global Admin role to accounts, follow the steps below:
	<OL>
	<LI>Click the App launcher in the upper left side then click <B>Admin</B> to go to the Microsoft 365 admin center.</LI>
	<LI>In the Microsoft 365 admin center, on the left panel click <B>Users</B>. Find the user you want to assign the Global Admin and select <B>Manage roles</B>.</LI>
	<LI>In the Manage roles window, select <B>Admin center access</B> then check the box beside <B>Global admin</B>. Click <B>Save Changes</B> to save the role you assigned.</LI>
	</OL>

<BR><B>Granting Permission to Discovery Management Group</B><BR>
This permission allows users added under the <B>Members</B> section of the <B>Discovery Management</B> group (refer to <B>Granting Permission to Accounts for Creating Backup Set</B>) to back up and/or restore user item(s) not only for their own account, but also the accounts of other users in the same <B>Members</B> section.
	<OL>
	<LI>Open <a href="https://outlook.office365.com/ecp">https://outlook.office365.com/ecp</a>.</LI>
	<LI>Log in to <B>Microsoft 365</B> as an account administrator.</LI>
	<LI>Select the <B>permissions</B> menu on the left, then double click on <B>Discovery Management</B> on the right.</LI>
	<LI>Click the <B>[+]</B> icon under the <B>Roles</B> section. These are the following roles:</LI>
		<UL>
		<LI>Mailbox Search</LI>
		<LI>Public Folders</LI>
		</UL>
	<LI>Click <B>Save</B> to confirm and exit the setting.</LI>
	</OL>
	
	
	<BR><B>Granting Permission to Accounts for Creating Backup Set</B><BR>
	<OL>
	<LI>Open <a href="https://outlook.office365.com/ecp">https://outlook.office365.com/ecp</a>.</LI>
	<LI>Log in to <B>Microsoft 365</B> as an account administrator.</LI>
	<LI>Select the <B>permissions</B> menu on the left, then double click on <B>Discovery Management</B> on the right.</LI>
	<LI>You can now add users to this group. Click the <B>[+]</B> icon under the <B>Members</B> section.</LI>
	<LI>Look for the username(s) of the account that you would like to add permission for, then click <B>Add</B> > <B>OK</B> to add the corresponding user(s) to the permission group.</LI>
	<LI>Click <B>Save</B> to confirm and exit the setting.</LI>
	</OL>
	
	</LI>
	

	

			
<LI><B>Data Synchronization Check (DSC) Setup</B> - To compensate for the significant backup performance increase, there is a tradeoff made by the Change Key API, which skips the checking of de-selected files in the backup source, which over time can result in a discrepancy between the items or files/folders selected in the backup sources and the those in the backup destination(s).	
<br>To overcome this, it is necessary in some cases to run a Data Synchronization Check (DSC) periodically, so that it will synchronize the data in the backup source and backup destination(s) to avoid data build-up and free up storage quota.
	<table cellspacing="0" cellpadding="4" >
	<tr>
		<td class="firstTitles" width="15%"></td>
		<td class="titles" width="30%">Enabled</td>
		<td class="titles" width="30%">Disabled</td>
	</tr>
	<tr>
		<td class="firstTitles" width="15%">Backup Time</td>
		<td width="30%">Since data synchronization check is enabled, it will only run on the set interval. 
		For example, the default number of interval is 60 days.  <br>
		The backup time for the data synchronization job which is triggered every 60 days by default will take longer than the usual backup as it is checking the de-selected files and/or folders in the backup source and data in backup destination(s)
		</td>
		<td width="30%">As data synchronization check is disabled, the backup time will not be affected.</td>
	</tr>
	<tr>
		<td class="firstTitles" width="15%">Storage</td>
		<td width="30%">Management of storage quota will be more efficient as it will detect items that are de-selected and move it to retention and will be removed after it exceeds the retention policy freeing up storage quota.</td>
		<td width="30%">Management of storage quota will be less efficient even though files and/or folders are already de-selected from the backup source, these files will remain in the data area of backup destination(s).</td>
	</tr>
</table>  	
</LI> 

<LI>To comply with Microsoft's product roadmap for Microsoft 365, from <%=HelpManager.getCbsShortName(request)%> v8.3.6.0 or above, Basic Authentication (Authentication using Microsoft 365 login credentials) will no longer be utilized.  Instead all new Microsoft 365 backup sets created will use Modern Authentication. 
<BR>
By second half of 2021, it will be a mandatory requirement for organizations still using Basic Authentication or Hybrid Authentication to migrate to Modern Authentication.
<BR>
Modern Authentication provides a more secure user authentication by using app token for authentication aside from using the Microsoft 365 login credentials.  In order to use Modern Authentication, the Microsoft 365 account is registered under Global region and the Microsoft 365 backup is configured to use Global region.  As both Germany and China region do not support Modern Authentication.
<BR>
Existing backup sets using Basic Authentication created prior to <%=HelpManager.getCbsShortName(request)%> v8.3.6.0 can be migrated to Modern Authentication.  However, once the authentication process is completed, the authentication can never be reverted back to Basic Authentication.  For more information on how to migrate to Hybrid Authentication or Modern Authentication please refer to this link <A HREF="en/BR_UsrGrpPol_BUsr_BSets_AddBSet_General_Office365ExchangeOnline_Migration.jsp">Migrating Authentication of Microsoft 365 Backup Set</A>.  After the upgrade to <%=HelpManager.getObmShortName(request)%> v8.3.6.0 or above, the backup and restore process of existing Microsoft 365 backup sets still using Basic Authentication  will not be affected during this transition period since Modern Authentication  is not yet enforced by Microsoft.<BR>

To check the current authentication being used in your Microsoft 365 backup set, see criteria below:<BR>
	<UL>
	<LI><B>Basic Authentication</B> - If you click on the backup set and a pop up message is displayed, then the backup set is using Basic Authentication.</LI>
	<LI><B>Modern and Hybrid Authentication</B> -  If you click on the backup set there is no pop up message displayed then the backup set is using either Modern or Hybrid Authentication.</LI>
		
	</UL>	
	</LI>		
			
</OL>

<h2>Supported Services</h2>
<p>These are the supported services of Microsoft 365 Backup module</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="15%">Services</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Services</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Outlook</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Yammer</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">OneDrive</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Microsoft Stream</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">SharePoint</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Power BI</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Microsoft Teams</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Microsoft Power Apps</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
	</table>

<BR>

<p>These are the supported Outlook Mailbox types of Microsoft 365</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
		    <td class="firstTitles" width="15%">Item</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Item</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Archive Mailbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Distribution Group</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Dynamic Distribution Group</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Equipment Mailbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Microsoft 365 Group</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Public Folder</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Public Folder Mailbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Room Mailbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Security Group</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Shared Mailbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">User Mailbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<!--td class="titles" width="15%"></td>
			<td class="titles" width="15%"></td-->
		</tr>
	</table>
<BR>

<p>These are the supported items that you can back up and restore from an Outlook Mailbox</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="15%">Item</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Item</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Archive</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Calendar</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Clutter</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Companies</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Contacts</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Conversion History</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Deleted Items</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Drafts</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">External Contacts</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">GAL Contacts</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Inbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Journal</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Junk Emails</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Notes</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Organizational Contacts</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Outbox</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">PeopleCentricConversation Buddies</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">PersonMetaData</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Recipient Cache</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">RS Feed</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Search Folders</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Sent Items</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Social Activity Notifications</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Sync Issues</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Tasks</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Trash</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
	</table>

<BR>

<p>These are the supported items that you can back up and restore from OneDrive</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="15%">Item</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Item</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Folders</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Files</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Access Permissions</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Albums</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Recycle Bin</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Tag</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
	</table>

<BR>

<p>These are the supported SharePoint items that you can back up and restore from a Microsoft 365 backup set</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="15%">Item</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Item</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Announcements</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Assets Libraries</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Bright Banner</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Calendar</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Contacts</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Custom Lists</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Data Connection Libraries</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Discussion Boards</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">External Lists</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Form Libraries</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">General Settings</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Import Spreadsheets</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Issue Tracking</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Links</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Look and Feel</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Manage Site Features</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Newsfeed</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Permissions and Management</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Picture and Libraries</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Report Libraries</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Site Collection Features</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Site Page</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Survey</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Version History</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Wiki / Page Libraries</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
	</table>

<BR>

<p>These are the supported SharePoint Site Collections template that you can back up and restore from a Microsoft 365 backup set</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="15%">Item</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Item</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Team Site</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Team Site (Classic Experience)</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Blog</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Project Site</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Developer Site</td>
			<td class="titles" width="15" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Community Site</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Document Center</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">eDiscovery Center</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Records Center</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Business Intelligence Center</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Compliance Policy Center</td>
			<td class="titles" width="15" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Enterprise Search Center</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Community Portal</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Basic Search Center</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Visio Process Repository</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">My Site Host</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Publishing Portal</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
			<td class="titles" width="15%">Enterprise WIKI</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Modern Team Sites</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Modern Communication Site</td>
			<td class="titles" width="15%" style="text-align:center">&#10006;</td>
		</tr>
	</table>

<BR>

<p>These are the supported Site Column Type that you can back up and restore from a Microsoft 365 backup set</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="15%">Item</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Item</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">CalendarFolderType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">CalendarItemType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">ContactItemType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">ContactsFolderType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">DistributionListType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">FolderType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">MeetingCancellationMessageType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">MeetingMessageType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">MeetingRequestMessageType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">MeetingResponseMessageType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">MessageType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">PostItemType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">SearchFolderType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">TasksFolderType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">TaskType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">UserConfigurationType</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
	</table>

<BR>

<p>These are the supported Items that you can back up and restore from the Public Folder of an Microsoft 365 backup set.</p>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="15%">Item</td>
			<td class="titles" width="15" style="text-align:center">Supported</td>
			<td class="titles" width="15%">Item</td>
			<td class="titles" width="15%" style="text-align:center">Supported</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Folders</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
			<td class="titles" width="15%">Files</td>
			<td class="titles" width="15%" style="text-align:center">&#10004;</td>
		</tr>
	</table>

<BR>

<h2>Supported Backup Source</h2>
<p>Below is the supported backup source for Microsoft 365 Backup and Restore.</p>
<OL>
<LI>Mailbox Level: Outlook, OneDrive and Personal Site.</LI>
<LI>Folder Level: Inbox, Drafts, Sent Items, Deleted Items, Archive, Calendar, Contacts, Junk Email, Notes and Tasks.</LI>
</OL>

<h2>Maximum Supported File Size</h2>
<p>The following table shows the maximum supported file size per item for backup and restore of each service.</p>
<h3><%=HelpManager.getObmShortName(request)%></h3>
	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="30%"><B>Service</B></td>
			<td class="titles"><B>Maximum File Size</B></td>			
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Outlook <BR>-with or without attachments <BR> -(applies to User mailbox, Room mailbox, Shared mailbox, Equipment mailbox)</td>
			<td class="titles"><BR>150 MB</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%"><BR>Public Folders <BR>-with or without attachments </td>
			<td class="titles"><BR>150 MB</td>		
		</tr>
		<tr>
			
			<td class="firstTitles" width="15%"><BR>OneDrive</td>
			<td class="titles"><BR>8 GB</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%"><BR>Personal Site</td>
			<td class="titles"><BR>8 GB</td>	
		</tr>
			<tr>
			<td class="firstTitles" width="15%"><BR>Site Collections</td>
			<td class="titles"><BR>8 GB</td>
		</tr>
	</table>

<h3><%=HelpManager.getAcbShortName(request)%></h3>

	<table cellspacing="0" cellpadding="4" >
		<tr>
			<td class="firstTitles" width="30%"><B>Service</B></td>
			<td class="titles"><B>Maximum File Size</B></td>			
		</tr>
		<tr>
			<td class="firstTitles" width="15%">Outlook <BR>-with or without attachments <BR> -(applies to User mailbox, Room mailbox, Shared mailbox, Equipment mailbox)</td>
			<td class="titles"><BR>150 MB</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%"><BR>Public Folders <BR>-with or without attachments </td>
			<td class="titles"><BR>150 MB</td>		
		</tr>
		<tr>
			
			<td class="firstTitles" width="15%"><BR>OneDrive</td>
			<td class="titles"><BR>8 GB</td>
		</tr>
		<tr>
			<td class="firstTitles" width="15%"><BR>Personal Site</td>
			<td class="titles"><BR>8 GB</td>	
		</tr>
	</table>


<BR>

<h2>Limitations</h2>
<OL>
<LI>Restore filter using <%=HelpManager.getCbsShortName(request)%> User Web Console is not yet supported. </LI>
<LI>Restore to Local Machine is not supported using <%=HelpManager.getCbsShortName(request)%> User Web Console.  It is only available using <%=HelpManager.getObmShortName(request)%> and <%=HelpManager.getAcbShortName(request)%>  </LI>
<LI>For restoration of Microsoft 365 backup set to alternate location, there are some limitations:
	<UL>
	<LI>Only administrator account or user account with administrative authority can restore backup items to an alternate location. </LI>
	<LI>If you will restore item(s) from one user to an alternate location user, <%=HelpManager.getObmShortName(request)%> will restore the item(s) to their respective destination folder(s) with the same name of the original folder(s). 
	<BR><b>Example:</b> Item from Outlook of User-A will be restored to the Outlook of the alternate location User-B; Item from SharePoint of User-A will be restored to the SharePoint of the alternate location User-B.</BR>
	</LI>
	<LI>If you will restore item(s) from several users to an alternate location user, <%=HelpManager.getObmShortName(request)%> will restore the item(s) to their respective destination folder(s) in the alternate location with the same name of the original folder(s). 
	<BR><b>Example:</b> Item from Outlook of User-A and User-B will be restored to the Outlook of the alternate location User-C.</BR>
	</LI>
	<LI>Restore of public folder item(s) to an alternate location public folder is not supported.
	<BR><b>Example:</b> Restore of public folder items from User-A to alternate location User-B is not supported.</BR>
	</LI>
	</UL>
</LI>
<LI>If you will restore item(s) from multiple Microsoft 365 user accounts to an alternate Microsoft 365 user account, <%=HelpManager.getObmShortName(request)%> can only restore one Microsoft 365 user account at a time. </LI>
<LI>If you will restore document library (including OneDrive) items 'Share Link' to an alternate organization, it will trigger a warning message.  Skip to restore People and Groups and Site Permissions to alternate organization. </LI>
<LI>If you will restore item(s) to a destination user which has a different language setting than the original user, <%=HelpManager.getObmShortName(request)%> will restore the item(s) to their respective destination folder based on the translation listed below. <br>
For folders such as 'Calendar' or 'Notes', a new folder 'Calendar' or 'Notes' will be created. <br>
For folders in OneDrive and SharePoint, a new folder will be created.
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="30%">Backup source (English)</td>
        <td class="titles" width="25%">Action</td>
		<td class="titles">Destination mailbox with Chinese as default language settings</td>
      </tr>
      <tr>
        <td class="firstTitles" width="30%">Inbox</td>
        <td class="titles">Merge</td>
		<td class="titles">&#25910;&#20214;&#31665;</td>  
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Outbox</td>
        <td class="titles">Merge</td>
		<td class="titles">&#23492;&#20214;&#21283;</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Sent Items</td>
        <td class="titles">Merge</td>
		<td class="titles">&#23492;&#20214;&#20633;&#20221;</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Deleted Items</td>
        <td class="titles">Merge</td>
		<td class="titles">&#21034;&#38500;&#30340;&#37109;&#20214;</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Drafts</td>
        <td class="titles">Merge</td>
		<td class="titles">&#33609;&#31295;</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Junk E-Mail</td>
        <td class="titles">Merge</td>
		<td class="titles">&#22403;&#22334;&#38651;&#37109;</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Calendar</td>
        <td class="titles">Create new folder</td>
		<td class="titles">Calendar</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Notes</td>
        <td class="titles">Create new folder</td>
		<td class="titles">Notes</td>
      </tr>	
	  <tr>
        <td class="firstTitles" width="30%">OneDrive Folder</td>
        <td class="titles">Create new folder</td>
		<td class="titles">OneDrive Folder</td>
      </tr>	
	  <tr>
        <td class="firstTitles" width="30%">SharePoint Folder</td>
        <td class="titles">Create new folder</td>
		<td class="titles">SharePoint Folder</td>
      </tr>
</table>  	  
</LI>
<LI>Restoring of existing documents in <b>checked out</b> status is supported only when the user who has checked out the file is the same user who is performing the restore.  </LI>
<LI>For the backup destination settings, only the <%=HelpManager.getCbsShortName(request)%> or predefined destination is supported in the <%=HelpManager.getCbsShortName(request)%> Run on Server (Agentless) backup.  <br>
It is not possible to assign other standard destinations such as the customers personal Google Drive, OneDrive, DropBox, Amazon S3, Azure and other storage accounts as the backup destination for a Run on Server backup set. </LI>
<LI>The command line tool feature that allows user to configure a pre and/or post-backup command which can be an operating sytem level command, script or batch file, or third-party utility that will run before and/or after a backup job is only supported in <%=HelpManager.getObmShortName(request)%> Run on Client but not in 
<%=HelpManager.getCbsShortName(request)%> Run on Server (Agentless) backup.  </LI>
<LI>The reminder feature is not supported in the <%=HelpManager.getCbsShortName(request)%> User Web Console.  This is only supported in agent-based backup.  When this feature is enabled, a backup confirmation dialog box will prompt the user to run a backup job during machine log off, restart or shutdown when <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> is installed on a Windows platform.  </LI>
<LI>The IP allowed for restore setting only allows the predefined IP range to perform a restore as configured by the system administrator.  This feature is only applicable in Run on Client Microsoft 365 restore operation and is not supported in Run on Server Microsoft 365 restore.  </LI>
<LI>Decrypt backup data feature is used to restore raw data by using the data encryption key that was set for the backup set.  This feature is only applicable in Run on Client Microsoft 365 backup set and is not supported in Run on Server Microsoft 365 backup.  </LI>
<LI><%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> backup user account does not have access to the system logs related to the following operations through the <%=HelpManager.getCbsShortName(request)%> User Web Console:
   <UL>
   <LI>Data Integrity Check </LI>
   <LI>Space Freeing Up </LI>
   </UL>
Therefore, the backup user does not have the ability to verify the results of these operations without the assistance of the backup service provider. </LI>   
<LI>Modern Authentication is only supported for Microsoft 365 account that is registered in Global region and the Microsoft 365 backup is configured to use Global region. </LI>
<LI>Backup sets using Modern Authentication cannot backup .aspx version file. </LI>
<LI>Due to limitations in Microsoft API, when using Modern Authentication, backup and restore of SharePoint Web Parts and Metadata are not fully supported.  </LI>
<LI>Backup sets using Modern Authentication does not support restore of some list settings, currently known as Survey Options on survey list.  </LI>
</OL> 


<h2>Best Practices and Recommendation</h2>
<p>The following are some best practices and recommendations we strongly recommend you follow before you start any Microsoft 365 Backup and restore. </p>

<UL>
<LI><b>Temporary directory</b> folder is used by <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> for storing backup set index files and any incremental or differential backup files generated during a backup job.  To ensure optimal backup/restoration performance, it is recommended that the temporary directory folder is set to a local drive with sufficient free disk space. </LI>
<LI><b>Performance Recommendation</b>  <br>
Consider the following for optimized performance of the backup operation:
   <UL>
   <LI>Enable scheduled backup jobs when system activity is low to achieve the best possible performance. </LI>
   <LI>Perform test restores periodically to ensure your backup is set up and performed properly.  Performing recovery test can also help identify potential issues or gaps in your recovery plan.  It is important that you do not try to make the test easier, as the objective of a successful test is not to demonstrate that everything is flawless.  There might be flaws identified in the plan throughout the test and it is important to identify those flaws. </LI>
   </UL>  </LI>
<LI><b>Set Backup Destination</b>  <br>
After creating the backup set in Run on Client mode in <%=HelpManager.getCbsShortName(request)%> User Web Console, please remember to login to <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> to set the backup destination if you want the backup destination to be Local/Mapped Drive/Network Drive/Removable Drive.  </LI>
<LI><b>Backup Destination</b>   <br>
For Run on Client backup, to provide maximum data protection and flexible restore options, it is recommended to configure:
<UL>
<LI>At least one offsite or cloud destination </LI>
<LI>At least one local destination for fast recovery </LI>
</UL>
<LI><b>Login to <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> </b>   <br>
After modifying the backup schedule setting of the Run on Client backup set in <%=HelpManager.getCbsShortName(request)%> User Web Console, please remember to login to the <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> client to synchronize the changes immediately. </LI>
<LI><b>Concurrent Backup Thread</b>  <br>
The value of 4 concurrent backup threads is found to be the optimal setting for Microsoft 365 backups to ensure best backup performance, minimal resource usage and lowest probability of throttling of backup requests by Microsoft 365. </LI>
<LI><b>Recommended Number of Microsoft 365 users on a Backup Set </b>  <br>
For Microsoft 365 Run on Server backup set, to ensure that it completes the backup job within 24 hours it is recommended that a single Microsoft 365 Run on Server backup set should not contain more than 2,000 users.  That is assuming that only small incremental daily changes will be made on the Run on Server backup set. </LI>
<LI><b>Large number of Microsoft 365 users to Backup </b>  <br>
It is recommended to divide the users into multiple backup sets.  A single Microsoft 365 backup set should not contain more than 2,000 Microsoft 365 users.  By splitting up the users into separate backup sets, the more backup sets, the faster the backup process can finish.  <br>
It is also a requirement that every split backup set should have its own unique user account for authentication to minimize the probability of throttling from Microsoft.  </LI>
<LI><b>Periodic Backup Schedule </b>   <br>
The periodic backup schedule should be reviewed regularly to ensure that the interval is sufficient to handle the data volume on the machine.  Over time, data usage pattern may change on a production server, e.g. the number of new files created, the number of files which are updated/deleted and new users may be added etc.  </LI>
<LI><b>Authentication</b> <br>
Although Microsoft has moved the enforcement date for Modern Authentication from end of 2020 to the second half of 2021, since this new authentication is already available starting with <%=HelpManager.getObmShortName(request)%> v8.3.6.0 or above, it is recommended that backup sets are migrated to Modern Authentication.  All newly created Microsoft 365 backup sets on <%=HelpManager.getObmShortName(request)%> v8.3.6.0 or above automatically use Modern Authentication. <br>
 </LI>
<LI><b>Backup Source </b> <br>
For Microsoft 365 backup sets there are two approaches for backup source selection. <br>
  <UL>
  <LI><b>All Microsoft 365 Users</b>   <br>
  If you select "All Users", all of the sub Microsoft 365 user accounts will automatically be backed up. </LI>
  <LI><b>Selective Microsoft 365 user </b> <br>
  If you select "Select Specific", you must choose the Microsoft 365 user accounts that will be backed up. </LI>
  </UL>
 </LI> 


<BR>



<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>This is the name of the backup set. You can create a meaningful name for it. 
        </td>
      </tr>
      <tr>
        <td width="20%">Backup set type</td>
        <td>Select the correct backup set type from the drop down box.
        </td>
      </tr>
      <tr>
        <td width="20%">Run on</td>
          <td>You can choose whether to run the backup job on the Client Backup Agent (Client) or the Backup Server (Server).
        </td>
      </tr>
	  <tr>
        <td width="20%">Platform</td>
        <td>Select the correct operating system from the drop down box.  There are three (3) choices which are Windows, Mac or Linux.  Default is Windows. This will only be available if "Client" is selected under "Run on".
        </td>
      </tr>
      <tr>
        <td width="20%">Backup scope</td>
        <td>The Microsoft 365 backup scope (i.e., "Entire organization" or "This Microsoft 365 user only").
        </td>
      </tr>
	  <tr>
        <td width="20%">Region</td>
        <td>The region where the Microsoft 365 account was registered. There are two (2) choices, either Global or China.
        </td>
      </tr>
      <tr>
        <td width="20%">Access the Internet through Proxy</td>
        <td>Option to access the Internet through Proxy. This will only be enabled if "Server" is selected under "Run on".  
        </td>
      </tr>
      <tr>
        <td width="20%">Test</td>
        <td>The Test button is used to verify if the Microsoft 365 username and password are correct.
        </td>
      </tr>
      <tr>
        <td width="20%">Sign up for Microsoft 365 Backup</td>
        <td>This link is used to sign up for a Microsoft 365 account.
        </td>
      </tr>
</table>
<BR>

<H3>To create a Microsoft 365 backup set:</H3>
<OL>
<LI>Select <b>Microsoft 365 Backup</b> in the Backup set type drop down list.</LI>
<LI>Enter the backup set name.</LI> 
<LI>Select where the backup set will be run. 
<BR>If you select <B>Server</B>, the backup set will be run on <%=HelpManager.getCbsShortName(request)%> server. 
<BR>If you select <B>Client</B>, the backup set will be run on the Client Backup Agent which means you cannot trigger the backup from the <%=HelpManager.getCbsShortName(request)%> server. Select the platform.</LI>
<LI>If you don't have a Microsoft 365 account, click the <b>Sign up for Microsoft 365 Backup</b> link to create an account.</LI>
<LI>Select the backup scope.
    <p><B>Note:</B> Select "This Microsoft 365 user only" if you are going to use a personal account for authentication. </p>
</LI>
<LI>Select the region.</LI>
<LI>Option: Tick the "Access the Internet through Proxy" checkbox. </LI>
<LI>Click the <b>[Test]</b> button.</LI> 
<LI>Click the <B>[Authorize]</B> button to start the authentication process.</LI>
<LI>Sign in to your Microsoft account.
<p>If MFA is enforced, select whether to receive a text or call. </p>
<UL>
<LI>If text is selected, enter the code and click the <B>[Verify]</B> button. </LI>
<LI>Otherwise, answer the call and follow the instructions to verify the sign in. </LI>
</UL>
<p><B>Note:</B> Verification is only required if the MFA status of a Microsoft 365 account is enforced. </p></LI>

<LI>Copy the authorization code.</LI>
<LI>Go back to <%=HelpManager.getCbsShortName(request)%> and paste the authorization code then click the <B>[OK]</B> button to proceed.</LI>
<LI>The confirmation message <B>Test completed successfully</B> will be shown when <%=HelpManager.getCbsShortName(request)%> is connected to the Microsoft 365 account successfully.</LI>
<LI>Click the <img src="../images/next.png"> button to proceed.</LI>
</OL> 




<div id="tipsContainer"><div class="icon">!</div>
<UL> 
<LI>Whether you choose to run the backup set on Client or Server, this setting cannot be altered after it is set. The only way to change this setting is to create a new backup set and back up the data all over again.</LI>
<LI>As a backup user, you will not be able to trigger a backup on the <%=HelpManager.getCbsShortName(request)%> server if the backup set is set as <b>Run on Client</b>. Only the system administrator has the permission to do so.</LI>
<LI>For backup sets created in <b>Run on Server</b> backup type, the backup destination is restricted to <%=HelpManager.getCbsShortName(request)%> by default and cannot be altered. If you wish to back up to other destinations, backup sets should be created in <b>Run on Client</b> backup type instead.</LI>
</UL>
</div>

<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>



</div>
<jsp:include page="footer.jsp" />
</body>

</html>
