<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Add New Backup Set</h1>

<P>You can create a Google Workspace backup set here in the Backup Server. It allows you to backup your Gmail, Google Drive, Calendar, Tasks, Contacts, Meet and Shared Drives from your Google account. For more information regarding requirement on the setup, please also refer to the help document for either <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%>.</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>This is the name of the backup set. You can create a meaningful name for it. 
        </td>
      </tr>
      <tr>
        <td width="20%">Backup set type</td>
        <td>Select the correct backup type from the drop down box. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Run On</td>
        <td>You can choose whether to run the backup job on the Client Backup Agent (Client) or the Backup Server (Server). 
        </td>
      </tr>
	  <tr>
        <td width="20%">Platform</td>
        <td>Select the correct operating system from the drop down box. There are three (3) choices which are Windows, Mac or Linux. Default is Windows. This will only be available if "Client" is selected under "Run on".. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Backup scope</td>
        <td>The Google Workspace backup scope (i.e., "Entire organization" or "This Google user only").  
        </td>
      </tr>
	  <tr>
        <td width="20%">Access the Internet through Proxy</td>
        <td>Option to access the Internet through Proxy. This will only be enabled if "Server" is selected under "Run on".  
        </td>
      </tr>
</table>
<BR><BR>

<H3>To create a backup set:</H3>
<OL>
<LI>Select <b>Google Workspace Backup</b> in the Backup set type drop down list.</LI>
<LI>Enter the backup set name.</LI> 
<LI>Select where the backup set will be run. 
<BR>If you select <B>Server</B>, the backup set will be run on <%=HelpManager.getCbsShortName(request)%> server. 
<BR>If you select <B>Client</B>, the backup set will be run on the Client Backup Agent which means you cannot trigger the backup from the <%=HelpManager.getCbsShortName(request)%> server. </LI>
<LI>Select the platform.</LI>
<LI>Select the backup scope.
    <p><B>Note:</B> Select "This Google user only" if you are going to use a personal account for authentication. </p>
</LI>
<LI>Option: Tick the "Access the Internet through Proxy" checkbox. </LI>
<LI>Click the <b>[Test]</b> button.</LI> 
<LI>Click the <B>[Authorize]</B> button to start the authentication process.</LI>
<LI>Sign in to your Google account.
<p>If 2FA is enforced, complete the additional verification steps. </p>
</LI>
<LI>Copy the authorization code.</LI>
<LI>Go back to <%=HelpManager.getCbsShortName(request)%> and paste the authorization code then click the <B>[OK]</B> button to proceed.</LI>
<LI>The confirmation message <B>Test completed successfully</B> will be shown when <%=HelpManager.getCbsShortName(request)%> is connected to the Google account successfully.</LI>
<LI>Click <img src="../images/next.png"> button to continue.</LI>
</OL> 

<div id="tipsContainer"><div class="icon">!</div>
<UL> 
<LI>Whether you choose to run the backup set on Client or Server, this setting cannot be altered after it is set. The only way to change this setting is to create a new backup set and back up the data all over again.</LI>
<LI>As a backup user, you will not be able to trigger a backup on the <%=HelpManager.getCbsShortName(request)%> server if the backup set is set as <b>Run on Client</b>. Only the system administrator has the permission to do so.</LI>
<LI>For backup sets created in <b>Run on Server</b> backup type, the backup destination is restricted to <%=HelpManager.getCbsShortName(request)%> by default and cannot be altered. If you wish to back up to other destinations, backup sets should be created in <b>Run on Client</b> backup type instead.</LI>
</UL>
</div>



<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>
    
</div>
<jsp:include page="footer.jsp" />
</body>

</html>
