// Avoid appending the timestamp to the URL invoked by jQuery
$.ajaxPrefilter(function(options, originalOptions, jqXHR) {
	if (options.dataType == 'script' || originalOptions.dataType == 'script') {
		options.cache = true;
	}
});

function selectAllCheckboxes(tableID) {
	try {
		var table = document.getElementById(tableID);
		var rowCount = table.rows.length;
		// List table use cbs checkbox
		var allchkboxDiv = table.rows[0].cells[0];
		var allchkbox = $(allchkboxDiv).find("input[type='checkbox']");
		for (var i=1; i<rowCount; i++) {
			var row = table.rows[i];
			var chkboxDiv = row.cells[0];
			var chkbox = $(chkboxDiv).find("input[type='checkbox']");
			if (chkbox != null && !chkbox.prop("disabled")) {
				chkbox.prop("checked", allchkbox.prop("checked"));
			}
		}
	} catch (e) {
		alert(e);
	}
}

function deleteRow(tableID) {
	try {
		var table = document.getElementById(tableID);
		var rowCount = table.rows.length;
		for (var i=0; i<rowCount; i++) {
			var row = table.rows[i];
			var chkbox = row.cells[0].childNodes[0];
			if (null != chkbox && true == chkbox.checked) {
				if (rowCount <= 1) {
					alert("Cannot delete all the rows.");
					break;
				}
				table.deleteRow(i);
				rowCount--;
				i--;
			}
		}
	} catch (e) {
		alert(e);
	}
}

function setCallTrigger(input, callTrigger, target) {
	// reset all callTrigger values to empty
	$('input:hidden[name*="callTrigger"]').each(function(index) {
		this.value = "";
	});

	// find the hidden field, e.g. callTrigger, within the same DOM container,
	$(input.parentNode.parentNode).find('input[type="hidden"]').each(function(index) {
		this.value = callTrigger;
	});

	if (target!=null) input.form.target = target;
}

function setNextDivVisible(input, visible) {
	$div = $(input).next('div');
	if (visible) $div.show();
	else $div.hide();
}

function expandTab(tabId, selectindex) {
	$(tabId + " > ul.css-tabs > li > a").each( function(i) {
		if (selectindex!=i) return;
		this.click();
	});
}

function adjustDropDownListCss() {
	$('.ui-widget-content.ui-widget.ui-menu.ui-autocomplete, .ui-widget-content.ui-widget.custom-combobox-input').css({
		'overflow-y': 'auto',
		'overflow-x': 'hidden',
		'max-height': '200px',
		'border': '1px solid #666666',
		'width': '380px'
	});
	$('.custom-combobox-span').css({
		'position': 'absolute',
		'margin-left': '-15px',
		'margin-top': '5px',
		'font-size': '9px'
	});
}

(function($) {
	$.widget("custom.combobox", {
		_create: function() {
			this.wrapper = $("<span>")
				.addClass("custom-combobox")
				.insertAfter(this.element);
			this.element.hide();
			this._createAutocomplete();
			// this._createShowAllButton();
		},
		_createAutocomplete: function() {
			var selected = this.element.children(":selected"),
			value = selected.val() ? selected.text() : "",
			wasOpen = false;
			this.input = $('<input type="text">')
				.appendTo(this.wrapper)
				.val(value)
				.removeAttr('title')
				.addClass("custom-combobox-input ui-widget ui-widget-content ui-state-default ui-corner-left")
				.autocomplete({
					delay: 0,
					minLength: 0,
					source: $.proxy(this, "_source"),
					appendTo: this.wrapper,
					position: { my: "left top", at: "left bottom", collision: "flip" },
					open: function(event, ui) {
						$(this).autocomplete("widget").css({
							'width': $(this).outerWidth()
						});
					}
				})
				.tooltip({
					tooltipClass: "ui-state-highlight"
				})
				// Removed combobox arrow
				.mousedown(function() {
					wasOpen = $(this).autocomplete("widget").is(":visible");
				})
				.click(function() {
					$(this).focus();
					// Close if already visible
					if (wasOpen) return;
					// Pass empty string as value to search for, displaying all results
					$(this).autocomplete("search", "");
				});
			this._on(this.input, {
				autocompleteselect: function(event, ui) {
					ui.item.option.selected = true;
					this.input.change();
					this._trigger("select", event, {
						item: ui.item.option
					});
				},
				autocompletechange: "_removeIfInvalid"
			});
			input = this.input;
			this.span = $('<span>')
				.appendTo(this.wrapper)
				.text("\u25BC")
				.addClass("custom-combobox-span")
				.click(function() {
					$(input).focus();
					// Close if already visible
					if (wasOpen) return;
					// Pass empty string as value to search for, displaying all results
					$(input).autocomplete("search", "");
				});
			adjustDropDownListCss();
		},
		_source: function(request, response) {
			var matcher = new RegExp($.ui.autocomplete.escapeRegex(request.term), "i");
			response(this.element.children("option").map(function() {
				var text = $(this).text();
				if (this.value && (!request.term || matcher.test(text))) {
					return {
						label: text,
						value: text,
						option: this
					};
				}
			}));
		},
		_removeIfInvalid: function(event, ui) {
			// Selected an item, nothing to do
			// Support to show the text in dropdown list
			var isInputInList = false;
			var sInput = this.input.val();
			this.element.find("option").each(function() {
				if (sInput == $(this).text()) {
					isInputInList = true;
					return false;
				}
			});
			if (isInputInList) {
				this.element.attr("name", this.input.attr("name"));
			} else {
				this.element.removeAttr("name");
			}
			if (ui.item) {
				return;
			}
			// Search for a match (case-insensitive)
			var value = this.input.val(),
			valueLowerCase = value.toLowerCase(),
			valid = false;
			this.element.children("option").each(function() {
				if ($(this).text().toLowerCase() === valueLowerCase) {
					this.selected = valid = true;
					return false;
				}
			});
			return;
		},
		_destroy: function() {
			this.wrapper.remove();
			this.element.show();
		},
		// Support the disabled combobox
		disable: function() {
			this.input.prop('disabled', true);
			this.input.autocomplete("disable");
		},
		enable: function() {
			this.input.prop('disabled', false);
			this.input.autocomplete("enable");
		}
	});
}
)(jQuery);

$(function() {
	$(".combobox select").each(function() {
		change2Combobox($(this));
	});
});

function change2Combobox(dropdown) {
	if (dropdown.css("display") == "none") {
		return;
	}
	dropdown.combobox();
	// Support the disabled combobox
	if (dropdown.prop('disabled')) {
		dropdown.combobox('disable');
	}
	// Support to show the text in dropdown list
	setName4Combobox(dropdown.parent(), $("input", dropdown.parent()), $("select", dropdown.parent()));
}

// Support to show the text in dropdown list
function setName4Combobox(combobox, input, dropdown) {
	var isValueInList = false;
	var sValue = combobox.attr("value");
	combobox.find('option').each(function() {
		if (sValue == $(this).attr("value")) {
			isValueInList = true;
			return false;
		}
	});
	input.attr("name", dropdown.attr("name"));
	// Re-fill with selected value only when the original value is empty
	var bListTable = dropdown.attr("name") === 'dummySelect';
	var offFocusColor = bListTable ? '#b7b7b7' : '#000';
	// Using a cache value to store the actual value of the input field, 
	// this value will be updated when the input field is changed.
	var cachedValue = '';
	input.change(function() {
		if (input.val()) {
			cachedValue = input.val();
		}
	});
	input.focusin(function() {
		// Using a cache value to store the actual value of the input field, 
		if (input.val()) {
			cachedValue = input.val();
		}
		if (input.val() === sValue) {
			input.css('color', '#000');
		}
		input.val('');
	});
	input.focusout(function() {
		if (input.val() === '') {
			// Set the input field value according to the priority of different values 
			var selectedValue = combobox.find('option:selected').text();
			input.val(cachedValue && cachedValue !== '' ? cachedValue : (selectedValue ? selectedValue : sValue));
			if (input.val() === sValue) {
				input.css('color', offFocusColor);
			}
		} else {
			input.css('color', '#000');
		}
	});
	// Removal of the property identification name from the dropdown element to avoid duplicated elements with same name
	if (isValueInList) {
		input.val(combobox.find('option:selected').text());
		input.css('color', '#000');
	// Re-fill with selected value only when the original value is empty
	} else if (!sValue) {
		// Select Default label
		input.val(combobox.find('option:selected').text());
	} else {
		input.val(sValue);
		dropdown.removeAttr("name");
	}
	// Re-fill with selected value only when the original value is empty
	if (combobox.find('option:selected').attr('value') === '') {
		input.css('color', offFocusColor);
	}
}

function selectFirstDropdownOption(sSelector) {
	var dropdownBox = $(sSelector);
	if (!dropdownBox || !dropdownBox.is("select")) {
		return;
	}
	$(sSelector + " option:selected").prop("selected", false);
	$(sSelector + " option:first").prop("selected", "selected");
}
