#!/bin/sh

# get application home
EXE_HOME=`pwd`
cd `dirname "$0"`
APP_BIN=`pwd`
APP_HOME=`dirname ${APP_BIN}`
cd "${EXE_HOME}"

# decide executable to use by system architecture
SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`

SYSTEM_IDENTITY=`uname -i`
case "${SYSTEM_OS}" in
  OpenBSD* )
    # OpenBSD does not support "uname -i"
    ;;
  * )
    SYSTEM_IDENTITY=`uname -i`
    ;;
esac

SYSTEM_TYPE=
case "${SYSTEM_OS}" in
  Linux* )
    SYSTEM_TYPE="linux"
    ;;
  *BSD* )
    SYSTEM_TYPE="bsd"
    ;;
  Darwin* )
    SYSTEM_TYPE="macos"
    ;;
  SunOS )
    SYSTEM_TYPE="solaris"
    ;;
  * )
    SYSTEM_TYPE="unknown"
    ;;
esac

NFS_EXE=""
case "${SYSTEM_TYPE}" in
  linux)
    case "${SYSTEM_ARCH}" in
      i[3-6]86)
        NFS_EXE="NfsLinX86"
        ;;
      x86_64 | amd64)
        NFS_EXE="NfsLinX64"
        ;;
      arm*)
        ;;
      ppc*)
        ;;
      *)
        ;;
    esac
    ;;
  bsd)
    case "${SYSTEM_ARCH}" in
      i[3-6]86)
        NFS_EXE="NfsFbdX86"
        ;;
      x86_64 | amd64)
        NFS_EXE="NfsFbdX64"
        ;;
      *)
        ;;
    esac
    ;;
  macos)
    case "${SYSTEM_ARCH}" in
      x86_64 | amd64)
        NFS_EXE="NfsFbdX64"
        ;;
      *)
        NFS_EXE="NfsFbdX86"
        ;;
    esac
    ;;
  solaris)
    IS_32BIT_KERNEL="`isainfo -v | grep -c 64-bit`"
    IS_SPARC_ARCH="`isainfo -v |grep -c sparc*`"
    if [ "$IS_32BIT_KERNEL" != "0" ] && [ "$IS_SPARC_ARCH" = "0" ]; then
        SOLARIS_ARCH="`/usr/bin/isainfo -kv`"
        case "${SOLARIS_ARCH}" in
          64-bit*)
            NFS_EXE="NfsSosX64"
            ;;
          *)
            NFS_EXE="NfsSosX86"
            ;;
        esac
    fi
    ;;
  *)
    ;;
esac

if [ -z "$NFS_EXE" ]; then
    echo "Platform not supported."
    exit 1
fi

# runtime directory
WORKING_HOME="${APP_HOME}"
# Add special handling for UBS instances
if [ "${SYSTEM_IDENTITY}" = "UBS" ]; then
    WORKING_HOME="/ubs/storage/obsr/nfs"
fi

# run execute
TEST_DIR="${WORKING_HOME}"
TEST_SIZE=1048576
"$APP_BIN/$NFS_EXE" -test "${TEST_DIR}=${TEST_SIZE}"

exit 0
