#!/bin/sh
# [Ahsay Cloud Backup Suite] (version 10.1.4.0)

# get application home
EXE_HOME=`pwd`
cd `dirname "$0"`
APP_BIN=`pwd`
APP_HOME=`dirname ${APP_BIN}`
cd "${EXE_HOME}"

# define utility scripts
UTIL_PRIVILEGE=${APP_BIN}/privilege.sh
UTIL_INSTALL_SERVICE=${APP_BIN}/install-service.sh
UTIL_STARTUP=${APP_BIN}/startup.sh
UTIL_SHUTDOWN=${APP_BIN}/shutdown.sh

# verify if the privilege is enough for install
if [ "$1" != "skipVerify" ]; then
    # print Logging Message Header
    echo "Log Time: `date`"

    # verify the privilege if the shell script "privilege.sh" exist.
    echo ""
    if [ -f "${UTIL_PRIVILEGE}" ]; then
        echo "Verifying current user privilege ..."
        "${UTIL_PRIVILEGE}" "install"
        [ $? -ne 0 ] && echo "Exit \"`basename $0`\" now!" && exit 1
    else
        echo "The shell script \"${UTIL_PRIVILEGE}\" is missing."
        echo "Exit \"`basename $0`\" now!" && exit 1
    fi
    echo "Current user has enough privilege to \"install\"."
    echo ""

    # print Logging Message
    OS_IS_LINUX=0
    case `uname` in
        Linux*)
            echo "Start configuration on Generic Linux Platform (`uname`)"
            OS_IS_LINUX=1
        ;;
        Solaris*) echo "Start configuration on Solaris 2.X Platform (`uname`)";;
        SunOS*)   echo "Start configuration on Solaris 5.X Platform (`uname`)";;
        *BSD*)    echo "Start configuration on BSD distribution Platform (`uname`)";;
        **)       echo "This OS `uname` is not supported by this script! Exit `basename $0` now!"
                  exit 1 ;;
    esac
fi

# change script name to cbsnfs for installing as a Service
echo "Installing [ NFS Service (Ahsay Systems Corporation) ]"
SCRIPT_SRC_DIR=${APP_BIN}
SCRIPT_NAME=cbsnfs
SCRIPT_PATH=${APP_BIN}/${SCRIPT_NAME}
SCRIPT_USER=${USER}
CBSNFS_SYSTEMD_SRC=cbsnfs-systemd
CBSNFS_SYSTEMD_SVC=cbsnfs.service
if [ "${SCRIPT_USER}" = "" ] ; then
  # handle the case if environment variable $USER is not defined (e.g. in SunOS 5.11)
  SCRIPT_USER=${LOGNAME}
fi

# create the service script
case "`uname`" in
    Linux*)   SCRIPT_SRC=cbsnfs-sysv ;;
    Solaris*) SCRIPT_SRC=cbsnfs-sysv ;;
    SunOS*)   SCRIPT_SRC=cbsnfs-sysv ;;
    OpenBSD*) SCRIPT_SRC=cbsnfs-openbsd ;;
    *BSD*)    SCRIPT_SRC=cbsnfs-bsd ;;
    **)       echo "This OS `uname` is not supported by this script! Exit `basename $0` now!"
              exit 1 ;;
esac

sed "s|@sed.script.name@|${SCRIPT_NAME}|g" < "${SCRIPT_SRC_DIR}/${SCRIPT_SRC}" | sed "s|@sed.product.util.startup@|${UTIL_STARTUP}|g" | sed "s|@sed.product.util.shutdown@|${UTIL_SHUTDOWN}|g" | sed "s|@sed.user.name@|${SCRIPT_USER}|g" > "${SCRIPT_PATH}"
echo "[ NFS Service (Ahsay Systems Corporation) ] Service Script created at ${SCRIPT_PATH}"

sed "s|@sed.nfs.bin@|${SCRIPT_SRC_DIR}|g" "${SCRIPT_SRC_DIR}/${CBSNFS_SYSTEMD_SRC}" > "${SCRIPT_SRC_DIR}/${CBSNFS_SYSTEMD_SVC}"

# install service
sh "${UTIL_INSTALL_SERVICE}" "${SCRIPT_PATH}" "${SCRIPT_SRC_DIR}/${CBSNFS_SYSTEMD_SVC}"
echo "[ NFS Service (Ahsay Systems Corporation) ] setup completed!"

# startup
echo "Startup [ NFS Service (Ahsay Systems Corporation) ]"
sh "${UTIL_STARTUP}"
echo "Started [ NFS Service (Ahsay Systems Corporation) ]"

exit 0
