#!/bin/sh

##################################################################
# Resolve OBSR based path

if [ -z "$CBS_HOME" ]; then
EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

CBS_HOME=$APP_HOME

export APP_BIN APP_HOME CBS_HOME

cd "$CBS_HOME"
fi

# Define Temporary JAVA_HOME
# JAVA_HOME="../jre-linux-amd64"

##################################################################
# System Debug Flag, enabled by default (0 - Disable, 1 - Enable)
SYSTEM_DEBUG=1

##################################################################
# Since OBSR 5.5.5.0, we have integrated the shell scripts for the following OS-ARCH.
# OS : from `uname`
# ARCH: from `uname -m`

# Linux-i386 | Linux-i486 | Linux-i586 | Linux-i686 | Linux-amd64 | Linux-x86_64 | Linux-arm | Linux-ppc
# FreeBSD-i386 | FreeBSD-amd64
# OpenBSD-i386 | OpenBSD-amd64

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`

SYSTEM_IDENTITY=
case "${SYSTEM_OS}" in
  OpenBSD* )
    # OpenBSD does not support "uname -i"
    ;;
  * )
    SYSTEM_IDENTITY=`uname -i`
    ;;
esac

SYSTEM_TYPE=
case "${SYSTEM_OS}" in
  Linux* )
    SYSTEM_TYPE="linux"
    ;;
  *BSD* )
    SYSTEM_TYPE="bsd"
    ;;
  Darwin* )
    SYSTEM_TYPE="macos"
    ;;
  SunOS )
    SYSTEM_TYPE="solaris"
    ;;
  * )
    SYSTEM_TYPE="unknown"
    ;;
esac


##################################################################
# Unit Functions for all NIX OS

log_message() {
  echo "$1"
}

log_string() {
  case "${SYSTEM_TYPE}" in
    solaris )
      echo "$1\c"
      ;;
    * )
      echo -n "$1"
      ;;
  esac  
}

log_debug_message() {
  [ $SYSTEM_DEBUG -eq 1 ] && log_message "$1"
}

# create_symlink_for_java_home() {
#   if [ ! -n "$JAVA_HOME" ]; then
#     log_message "Please set JAVA_HOME!"
#     exit 1
#   else
#     log_message "Create JAVA_HOME symbolic link at $CBS_HOME/java"
#     cd "$CBS_HOME"
#     ln -sf "${JAVA_HOME}" "java"
#     return 0
#   fi
# }

process_count_with_pid() {
  PID_VALUE=$1
  PS_OPTIONS=" "
  case "${SYSTEM_TYPE}" in
    solaris )
      PS_OPTIONS="-e"
      ;;
    * )
      ;;
  esac
  COUNT=`ps ax $PS_OPTIONS | awk -F" " '{print " "$1" "$2" "}' | grep -c " $PID_VALUE "`
  echo $COUNT
}

##################################################################
# Define "JAVA LIB PATH" /"LD LIB PATH"

case "${SYSTEM_TYPE}" in
  # Modify JRE_HOME for Mac OS X
  # It is required to be here for this file will be used in upgrade patch as well

  linux)
    case "${SYSTEM_ARCH}" in
      i[3-6]86)
        JAVA_THREAD_STACK_IN_KB=256
        # JAVA_HEAP_MAX_IN_MB=$JAVA64_HEAP_MAX_IN_MB
        LD_LIBRARY_PATH=$CBS_HOME/lib/LinX86
        export LD_LIBRARY_PATH
        ;;
      x86_64 | amd64)
        JAVA_THREAD_STACK_IN_KB=256
        # JAVA_HEAP_MAX_IN_MB=$JAVA64_HEAP_MAX_IN_MB
        LD_LIBRARY_PATH=$CBS_HOME/lib/LinX64
        export LD_LIBRARY_PATH
        ;;
      arm*)
        JAVA_EXTRA_OPTS=""
        ;;
      ppc*)
        ;;
      *)
        echo 'do not have set LD path' >> $TEMP_LOG
        ;;
    esac
    ;;
  bsd)
    case "${SYSTEM_ARCH}" in
      amd64)
        JAVA_THREAD_STACK_IN_KB=256
        # JAVA_HEAP_MAX_IN_MB=$JAVA64_HEAP_MAX_IN_MB
        LD_LIBRARY_PATH=$CBS_HOME/lib/FbdX64
        export LD_LIBRARY_PATH
        ;;
      x86_64 | i[3-6]86)
        JAVA_THREAD_STACK_IN_KB=256
        # JAVA_HEAP_MAX_IN_MB=$JAVA64_HEAP_MAX_IN_MB
        LD_LIBRARY_PATH=$CBS_HOME/lib/FbdX86
        export LD_LIBRARY_PATH
        ;;
      *)
        ;;
    esac
    ;;
  macos)
    case "${SYSTEM_ARCH}" in
      x86_64 | amd64)
        JAVA_THREAD_STACK_IN_KB=256
        # JAVA_HEAP_MAX_IN_MB=$JAVA64_HEAP_MAX_IN_MB
        LD_LIBRARY_PATH=$CBS_HOME/lib/FbdX64
        export LD_LIBRARY_PATH
        ;;
      *)
        SYSTEM_MEM_RESERVED_IN_MB=512
        LD_LIBRARY_PATH=$CBS_HOME/lib/FbdX86
        export LD_LIBRARY_PATH
        ;;
    esac
    ;;
  solaris)
    SOLARIS_ARCH="`/usr/bin/isainfo -kv`"
    case "${SOLARIS_ARCH}" in
      64-bit*)
        JAVA_THREAD_STACK_IN_KB=256
        # JAVA_HEAP_MAX_IN_MB=$JAVA64_HEAP_MAX_IN_MB
        JAVA_EXTRA_OPTS="-d64 ${JAVA_EXTRA_OPTS}"
        # set reserved memory here (64-bit)
        SYSTEM_MEM_RESERVED_IN_MB=1024
        LD_LIBRARY_PATH=$CBS_HOME/lib/SosX64
        export LD_LIBRARY_PATH
        ;;
      *)
        JAVA_THREAD_STACK_IN_KB=128
        # set reserved memory here (32-bit)
        SYSTEM_MEM_RESERVED_IN_MB=512
        LD_LIBRARY_PATH=$CBS_HOME/lib/SosX86
        export LD_LIBRARY_PATH
        ;;
    esac
    ;;
  *)
    ;;
esac

##################################################################
# Setup JAVA environment, including JAVA_HOME and the options limit

# Prepare JAVA_HOME

# If $CBS_HOME/java exist, it will always be used as JRE_HOME.
# Otherwise, we have to create symbolic link for the $CBS_HOME/java to the predefined JRE_HOME

if [ -z "$JRE_HOME" ]; then
if [ -d "$CBS_HOME/java" ];then
  JRE_HOME="$CBS_HOME/java"
  # [Start] 41483: Do the java home setting in install.
  CBS_UTIL_BIN="$CBS_HOME/util/bin"
  MINIMUM_SUPPORTED_JVM_VERSION=21.0
  echo "Minimum supported JVM version: $MINIMUM_SUPPORTED_JVM_VERSION"
  [ ! -f "$CBS_UTIL_BIN/verify-jvm-version.sh" ] && echo "The shell script \"$CBS_UTIL_BIN/verify-jvm-version.sh\" is missing." && echo "Exit \"`basename $0`\" now!" && exit 1
  "$CBS_UTIL_BIN/verify-jvm-version.sh" "$CBS_HOME/java" "$MINIMUM_SUPPORTED_JVM_VERSION" 1>"/dev/null" 2>&1
  if [ $? -ne 0 ]
  then
      echo "The JVM version is lower than \"$MINIMUM_SUPPORTED_JVM_VERSION\" which is not supported by the CBS."
      [ -L "$CBS_HOME/java" ] && rm -f "$CBS_HOME/java" && echo "Removed the Symlink \"$CBS_HOME/java\"."
      echo "Java home is not set. Please finish CBS setup by running \"install.sh\"."
      exit 1
  fi
  echo "Current JVM version is supported."
  # [End] 41483
else
  case "${SYSTEM_TYPE}" in
    # Modify JRE_HOME for Mac OS X
    # It is required to be here for this file will be used in upgrade patch as well
    macos)
      JRE_HOME=/System/Library/Frameworks/JavaVM.framework/Home
      ln -sf "$JRE_HOME" "$CBS_HOME/java"
      ;;
    linux)
      # [Start] 41483: Do the java home setting in install.sh
#       #  use bundled java if available
#       case "${SYSTEM_ARCH}" in
#         i[3-6]86)
#           if [ -d $CBS_HOME/java-linux-x86 ]; then
#             JRE_HOME=$CBS_HOME/java-linux-x86
#             cd $CBS_HOME
#             ln -sf "java-linux-x86" "java"
#           else
#             create_symlink_for_java_home
#           fi
#           ;;
#         x86_64 | amd64)
#           # [Start] 41483: Starting v10, java 21 will be used
#           JAVA_DIR="java21-linux-x64"
#           # if [ -d $CBS_HOME/java-linux-x64 ]; then
#           if [ -d "$CBS_HOME/${JAVA_DIR}" ]; then
#             # JRE_HOME=$CBS_HOME/java-linux-x64
#             JRE_HOME="$CBS_HOME/${JAVA_DIR}"
#             # ln -sf "java-linux-x64" "java"
#             ln -sf "${JAVA_DIR}" "java"
#           else
#             create_symlink_for_java_home
#           fi
#           # [End] 41483
#           ;;
#         arm*)
#           ;;
#         ppc*)
#           ;;
#         *)
#           create_symlink_for_java_home
#           ;;
#       esac
      echo "Java home is not set. Please finish CBS setup by running \"install.sh\"."
      exit 1
      # [End] 41483
      ;;
    bsd)
      # [Start] 41483: Do the java home setting in install.sh
#       #  use bundled java if available
#       case "${SYSTEM_ARCH}" in
#         i[3-6]86)
#           if [ -d "$CBS_HOME/java-freebsd-x86" ]; then
#             JRE_HOME=$CBS_HOME/java-freebsd-x86
#           else
#             create_symlink_for_java_home
#           fi
#           ;;
#         x86_64 | amd64)
#           if [ -d "$CBS_HOME/java-freebsd-x64" ]; then
#             JRE_HOME=$CBS_HOME/java-freebsd-x64
#           else
#             create_symlink_for_java_home
#           fi
#           ;;
#         *)
#           create_symlink_for_java_home
#           ;;
#       esac
#       ;;
#     *)
#       create_symlink_for_java_home
      echo "Java home is not set. Please finish CBS setup by running \"install.sh\"."
      exit 1
      # [End] 41483
      ;;
  esac
fi

# Assumed we always have this directory for JAVA_HOME and JRE_HOME at this stage
[ -d "$CBS_HOME/java" ] && JRE_HOME=$CBS_HOME/java
JAVA_HOME=$JRE_HOME
fi

##################################################################
# Define tomcat environment

PATH=$JRE_HOME/bin:$PATH

CATALINA_HOME=$CBS_HOME/tomcat
CATALINA_BASE=$CBS_HOME
[ -z "$CATALINA_PID" ] && CATALINA_PID=/var/run/obsr.pid

[ -z "$TC_HOME" ] && TC_HOME=$CBS_HOME
CATALINA_TMPDIR=$TC_HOME/temp

# Define java environment
JAVA_JNI_OPTS="-Djava.library.path=$LD_LIBRARY_PATH"
JAVA_OPTS="${JAVA_JNI_OPTS} -DCATALINA_PID=$CATALINA_PID";
if [ "${SYSTEM_IDENTITY}" = "UBS" ]; then
    JAVA_OPTS="${JAVA_OPTS} -Dorg.sqlite.lib.path=$LD_LIBRARY_PATH"
fi

JAVA_OPTS_CONF="$CBS_HOME/conf/cbssvc.ini"
if [ "$SYSTEM_TYPE" = "solaris" ]; then
    JAVA_OPTS_TMP="$CBS_HOME/conf/cbssvc.ini.bak"
    if [ -f "${JAVA_OPTS_TMP}" ]; then
        rm "${JAVA_OPTS_TMP}"
    fi
    while read line ; do
        # Tomcat shutdown should take least argument, JAVA_MEMORY_OPTS and JAVA_EXTRA_OPTS should be empty
        # ignore comment lines, non "-D" prefixed lines
        echo "$line" | grep -v "^\(\-D\)" >/dev/null 2>&1 && continue
        # if not empty, append the value to JAVA_OPTS and remove DOS end-of-line characters if found
        if [ ! -z "$line" ]; then
            SED_CMD=`echo "s/\r//"`       
            printf " `echo \"$line\" | sed ${SED_CMD}`" >> "${JAVA_OPTS_TMP}"
        fi
    done < $JAVA_OPTS_CONF
    if [ -f "${JAVA_OPTS_TMP}" ]; then
        JAVA_OPTS="${JAVA_OPTS} `cat ${JAVA_OPTS_TMP}`"
        rm "${JAVA_OPTS_TMP}"
    fi
else
    while read line ; do
        # Tomcat shutdown should take least argument, JAVA_MEMORY_OPTS and JAVA_EXTRA_OPTS should be empty
        # ignore comment lines, non "-D" prefixed lines
        echo "$line" | grep -v "^-D" >/dev/null 2>&1 && continue
        # if not empty, append the value to JAVA_OPTS and remove DOS end-of-line characters if found
        [ ! -z "$line" ] && JAVA_OPTS="${JAVA_OPTS} `echo "$line" | awk '{ sub("\r$", ""); print }'`"
    done < $JAVA_OPTS_CONF
fi

##################################################################
# Export all required environment variables

export CBS_HOME JAVA_HOME JRE_HOME PATH
export CATALINA_HOME CATALINA_BASE CATALINA_PID CATALINA_TMPDIR
export CATALINA_OPTS JAVA_OPTS

# Add UBS Support
if [ "${SYSTEM_IDENTITY}" = "UBS" ];then
  SYSTEM_TYPE="${SYSTEM_TYPE} (UBS)"
fi

##################################################################
# Service shutdown execution detail
OBSR_USER=${USER}
if [ "${OBSR_USER}" = "" ] ; then
  # handle the case if environment variable $USER is not defined (e.g. in SunOS 5.11)
  OBSR_USER=${LOGNAME}
fi

log_debug_message "-----------------------------------------------------------------------"
log_debug_message "You may set SYSTEM_DEBUG=0 to disable the debug message"
log_debug_message "-----------------------------------------------------------------------"
log_debug_message "Current User Name   : $OBSR_USER"
log_debug_message "Using SYSTEM_TYPE   : $SYSTEM_TYPE"
log_debug_message "Using SYSTEM_ARCH   : $SYSTEM_ARCH"
log_debug_message "-----------------------------------------------------------------------"
log_debug_message "Using CBS_HOME      : $CBS_HOME"
log_debug_message "Using JAVA_HOME     : $JAVA_HOME"
log_debug_message "Using CATALINA_HOME : $CATALINA_HOME"
log_debug_message "Using JAVA_OPTS     : $JAVA_OPTS"
log_debug_message "Using CATALINA_OPTS : $CATALINA_OPTS"
log_debug_message "Using CATALINA_PID  : $CATALINA_PID"
log_debug_message "-----------------------------------------------------------------------"

if [ -f "${CATALINA_PID}" ] ; then
  PID=`cat "${CATALINA_PID}"`
fi

log_message "Stopping AhsayCBS service"
[ "$EXE_DIR" ] && cd "$CBS_HOME"
sh "${CATALINA_HOME}/bin/catalina.sh" stop > /dev/null 2>&1

##################################################################
# Wait till process exits
# Wait time in unit of seconds for process to exit
WAIT_EXIT_TIMEOUT=120

if [ -n "$PID" ] ; then
  log_message "Check for CBS process #$PID"
  SLEEP_COUNT=$WAIT_EXIT_TIMEOUT
  PROCESS_COUNT=`process_count_with_pid $PID`
  while [ $PROCESS_COUNT -gt 0 ]
  do
    PROCESS_COUNT=`process_count_with_pid $PID`
    if [ $PROCESS_COUNT -eq 0 ] ; then
      log_message " OK"
      break
    fi
    case $SLEEP_COUNT in
      $WAIT_EXIT_TIMEOUT)
        log_string "Waiting for the AhsayCBS process (PID=$PID) to terminate "
        ;;
      0)
        echo ""
        echo "Waited for $WAIT_EXIT_TIMEOUT seconds"
        log_message "Killing the AhsayCBS process (PID=$PID) ..."
        if kill -9 $PID ; then
           log_message " OK"
        else
           log_message " FAILED"
        fi
        break
        ;;
      *)
        log_string "."      
        ;;
    esac
    sleep 1
    SLEEP_COUNT=`expr $SLEEP_COUNT - 1`
  done
  rm -f "${CATALINA_PID}"
fi
