#!/bin/sh
APP_JVM_HOME="../jvm"
AUA_JVM_HOME="./jvm"
JVM_HOME="$APP_JVM_HOME"

if [ "$4" = "MIGRATE" ]; then
    JVM_HOME="$AUA_JVM_HOME"
elif [ "$3" = "UI" ]; then
    echo "Check if JVM for migration exists"
    # for CloudBacko case, check if update JVM file exists or not
    sh copy-jvm.sh
    result=$?
    if [ "$result" = "1" ]; then
        echo "Cannot extract JVM for migration. Exit now."
        exit 1
    elif [ "$result" = "0" ]; then
        echo "Use JVM home in AUA folder for migration"
        JVM_HOME="$AUA_JVM_HOME"
    else
        echo "No need to migrate JVM"
    fi
else
    # add to support define JVM home on java
    if [ ! -z "$4" ]; then
        JVM_HOME="$4"
    fi
fi

if [ -f "$JVM_HOME/bin/javau" ]; then 
    echo "javau exists. Continue update." 
else 
    # copy java as javau to distinguish update process and other processes
    cp "$JVM_HOME/bin/java" "$JVM_HOME/bin/javau" 
    echo "javau added, continue update."
fi

JAVA_EXE="$JVM_HOME/bin/javau"

# Load aua.ini only if JVM is java 21 or above, which has both conf and legal folders under JVM_HOME
JAVA_OPTS="-Xrs -Xmx128m"
if [ -d "$JVM_HOME/conf" ] && [ -d "$JVM_HOME/legal" ]; then
    INI_FILE="./lib/aua.ini"
    if [ -f "$INI_FILE" ]; then
        JAVA_OPTS=$(grep -vE '^\s*#|^\s*$' "$INI_FILE" | sed 's/^[ \t]*//;s/[ \t]*$//' | tr '\n' ' ')
    fi
fi

echo "JAVA_OPTS=\"$JAVA_OPTS\""

LIB_HOME="./lib"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/MacX84"
# AuaI need jdom.jar because Xml classes likes ConfigXML use jdom to parse xml
CLASSPATH="$LIB_HOME:$LIB_HOME/aua.jar"
MAIN_CLASS=AuaI
"$JAVA_EXE" $JAVA_OPTS "$JNI_PATH" -cp "$CLASSPATH" "$MAIN_CLASS" "$1" "$2" "$3" > ./Update.txt
if [ "$?" != "0" ]; then
    exit
fi
if [ "$3" = "UI" ]; then
    rm -rf $AUA_JVM_HOME
    open '/Applications/AhsayACB.app' &
fi
exit
