#!/bin/sh

############ DEFINE VARIABLES ############
## Variable Defined for Debugging ##
## NOTE: Set "on" to show the debugging messages. ##
_DEBUG="on"

############ GENERAL UTILITY ###########
### Methods for Debugging ###
DEBUG()
{
    [ "$_DEBUG" = "on" ] &&  $@
}

DIRPATH_AUA_HOME=`pwd`
DIRPATH_APP_HOME=`dirname "$DIRPATH_AUA_HOME"`

case `uname -s` in
    ## Mac OS X
    "Darwin")
        if [[ "$DIRPATH_APP_HOME" != *.app ]]
        then
            DIRPATH_APP_HOME="$DIRPATH_APP_HOME.app"
        fi
    ;;
    *)
    ;;
esac

DIRPATH_AUA_JVM_HOME="$DIRPATH_AUA_HOME/jvm"
DIRPATH_AUA_JVM_BIN_DIR="$DIRPATH_AUA_HOME/bin"

FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X64="jre-std-linux-amd64.tar.gz"

FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_MAC="jre-std-mac.tar.gz"

chmod_jvm_home()
{
    [ -d "$DIRPATH_AUA_JVM_HOME" ] && chmod 755 "$DIRPATH_AUA_JVM_HOME" && DEBUG echo "Chmod 755 \"$DIRPATH_AUA_JVM_HOME\"."
    [ -d "$DIRPATH_AUA_JVM_BIN_DIR" ] && chmod -R 755 "$DIRPATH_AUA_JVM_BIN_DIR" && DEBUG echo "Chmod 755 \"$DIRPATH_AUA_JVM_BIN_DIR\" and its files / subdirectories."
}

is_extract_and_update_jvm_done_successfully()
{
    case `uname -s` in
        Linux*)
            case `uname -m` in
                x86_64 | amd64)
                    FILENAME_EXTRACT_JVM_TGZ_ARCHIVE="$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X64"
                ;;
                *)
                    return 1
                ;;
            esac
        ;;
        ## Mac OS X
        "Darwin")
            FILENAME_EXTRACT_JVM_TGZ_ARCHIVE="$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_MAC"
        ;;
        *) 
            return 1
    esac
    
    VERSION=$(
      for dir in "$DIRPATH_AUA_HOME"/*; do
        [ -d "$dir" ] || continue
        # Extract basename
        base=$(basename "$dir")
        echo "$base" | grep -E '^[0-9]+(\.[0-9]+)+$' >/dev/null && echo "$base"
      done | sort -t '.' -k1,1n -k2,2n -k3,3n -k4,4n | tail -n 1
    )

    if [ -z "$VERSION" ]; then
        echo "Cannot find version folder from $DIRPATH_AUA_HOME ..."
        exit 1
    fi

    JVM_FILE_HOME=$DIRPATH_AUA_HOME/$VERSION/upgrade

    FILENAME_JVM_UPDATE_PATCH=$JVM_FILE_HOME/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE

    if [ ! -f "$FILENAME_JVM_UPDATE_PATCH" ]; then
        echo "Cannot copy because JVM update patch \"$FILENAME_JVM_UPDATE_PATCH\" doesn't exist... "
        exit 2
    fi

    # Note: If the old JVM Home exist, remove it and its contents before extracting the JRE archive.
    [ ! -L "$DIRPATH_AUA_JVM_HOME" ] && [ -d "$DIRPATH_AUA_JVM_HOME" ] && rm -rf "$DIRPATH_AUA_JVM_HOME" && DEBUG echo "Removed the directory \"$DIRPATH_AUA_JVM_HOME\" and its contents."
    # Note: If the old JVM Home is symlink, remove it
    [ -L "$DIRPATH_AUA_JVM_HOME" ] && rm -f "$DIRPATH_AUA_JVM_HOME" && DEBUG echo "Removed the symlink \"$DIRPATH_AUA_JVM_HOME\"."
    [ ! -d "$DIRPATH_AUA_JVM_HOME" ] && mkdir -p "$DIRPATH_AUA_JVM_HOME" && DEBUG echo "Created the directory \"$DIRPATH_AUA_JVM_HOME\"."
    [ -f "$FILENAME_JVM_UPDATE_PATCH" ] && tar zxf "$FILENAME_JVM_UPDATE_PATCH" -C "$DIRPATH_AUA_JVM_HOME" && DEBUG echo "Extract the file \"$FILENAME_JVM_UPDATE_PATCH\" to the directory \"$DIRPATH_AUA_JVM_HOME\"."
    return 0
}

## MAIN ##
#########################

eval is_extract_and_update_jvm_done_successfully

result=$?

if [ $result -ne 0 ]   # If jvm extract and update failed
then
    DEBUG echo "JVM migration failed."
else
    DEBUG echo "JVM migration finished."
    chmod_jvm_home
fi

#########################

exit $result
