#!/bin/bash

# This is a script file to be executed after installation

###############################################################################
#       D E F I N E           P A T H       A N D        N A M E S            #
###############################################################################

# $1 is the timestamp
TIMESTAMP_CONFIG=$1

# APP_HOME="/Applications/AhsayOBM.app"
SCRIPT_HOME="`dirname \"${0}\"`"
cd "${SCRIPT_HOME}"
# get APP_HOME from path of this script
APP_HOME="`pwd | sed -E -e \"s:(/[^/]*/[^/]*)/.*:\1:g\"`"

###############################################################################
#       C O F I G U R E         A P P L I C A T I O N        H O M E          #
###############################################################################

echo "Log Time: ${TIMESTAMP_CONFIG}"
echo "Begin Custom Configuration for Ahsay Online Backup Manager"

# for 10.7.3 or later only
echo "Create proper launcher of this application"
if [ -f "${APP_HOME}/Contents/java16.Info.plist" ]; then
    rm -f "${APP_HOME}/Contents/java16.Info.plist"
fi
# if [ -f "${APP_HOME}/Contents/MacOS/JavaApplicationStub" ]; then
#     rm -f "${APP_HOME}/Contents/MacOS/JavaApplicationStub"
# fi
if [ -f "${APP_HOME}/Contents/MacOS/JavaAppLauncher" ]; then
    find "${APP_HOME}/Contents/MacOS" -type f ! -name "JavaAppLauncher" -delete
    mv -f "${APP_HOME}/Contents/MacOS/JavaAppLauncher" "${APP_HOME}/Contents/MacOS/AhsayOBM"
fi

echo "Create user list file at ${APP_HOME}/home.txt"
touch "${APP_HOME}/home.txt"
chmod 777 "${APP_HOME}/home.txt"

echo "Create Scheduler IPC folder"
mkdir "${APP_HOME}/ipc"
chmod 777 "${APP_HOME}/ipc"

echo "Restore ${APP_HOME} folder ownership"
chown -R root:admin "${APP_HOME}"
echo "Restored default ownership root:admin at ${APP_HOME}"

echo "Disable uninstall.sh to non sudo-ers"
chmod 700 "${APP_HOME}/bin/uninstall.sh"
echo "Changed file permission to 700 for ${APP_HOME}/bin/uninstall.sh"

echo "Reset PkgInfo execute file"
chmod +x "${APP_HOME}/Contents/PkgInfo"
echo "Changed file permission to +x for ${APP_HOME}/Contents/PkgInfo"

chmod +x "${APP_HOME}/Contents/MacOS/AhsayOBM"
echo "Changed file permission to +x for ${APP_HOME}/Contents/MacOS/AhsayOBM"

chmod +x "${APP_HOME}/bin/Scheduler.sh"
echo "Changed file permission to +x for ${APP_HOME}/bin/Scheduler.sh"

chmod +x "${APP_HOME}/bin/taskkill"
echo "Changed file permission to +x for ${APP_HOME}/bin/taskkill"

chmod +x "${APP_HOME}/util/bin/taskkill"
echo "Changed file permission to +x for ${APP_HOME}/util/bin/taskkill"

###############################################################################
#           C O F I G U R E          J A V A            H O M E               #
###############################################################################
JVM_LINK="${APP_HOME}/Contents/PlugIns/jvm/Contents/Home/jre"
JVM_PATH="${APP_HOME}/jvm"
if [ -e "${JVM_LINK}" ]; then
    echo "Remove Symbolic Link ${JVM_LINK}"
    rm -rf "${JVM_LINK}"
fi
if [ ! -e "${JVM_LINK}" ]; then
    echo "Create Symbolic Link ${JVM_LINK} to ${JVM_PATH}"
    ln -sf "${JVM_PATH}" "${JVM_LINK}"
fi

###############################################################################
#             E N D            O F            C O N F I G U R A T I O N       #
###############################################################################

echo "Finished Custom Configuration for Ahsay Online Backup Manager"

exit 0
