/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.RefreshInterval;
import biweekly.util.Duration;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

public class RefreshIntervalScribe
extends ICalPropertyScribe<RefreshInterval> {
    public RefreshIntervalScribe() {
        super(RefreshInterval.class, "REFRESH-INTERVAL", ICalDataType.DURATION);
    }

    @Override
    protected String _writeText(RefreshInterval property, WriteContext context) {
        Duration duration = (Duration)property.getValue();
        if (duration != null) {
            return duration.toString();
        }
        return "";
    }

    @Override
    protected RefreshInterval _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        return this.parse(value);
    }

    @Override
    protected void _writeXml(RefreshInterval property, XCalElement element, WriteContext context) {
        String durationStr = null;
        Duration duration = (Duration)property.getValue();
        if (duration != null) {
            durationStr = duration.toString();
        }
        element.append(this.dataType(property, null), durationStr);
    }

    @Override
    protected RefreshInterval _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        String value = element.first(dataType);
        if (value != null) {
            return this.parse(value);
        }
        throw RefreshIntervalScribe.missingXmlElements(dataType);
    }

    @Override
    protected JCalValue _writeJson(RefreshInterval property, WriteContext context) {
        Duration value = (Duration)property.getValue();
        if (value != null) {
            return JCalValue.single(value.toString());
        }
        return JCalValue.single("");
    }

    @Override
    protected RefreshInterval _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        return this.parse(valueStr);
    }

    private RefreshInterval parse(String value) {
        if (value == null) {
            return new RefreshInterval((Duration)null);
        }
        try {
            Duration duration = Duration.parse(value);
            return new RefreshInterval(duration);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(18, new Object[0]);
        }
    }
}

