/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.containerservice.fluent.ContainerServiceManagementClient;
import com.azure.resourcemanager.containerservice.implementation.ContainerServiceManagementClientBuilder;
import com.azure.resourcemanager.containerservice.implementation.KubernetesClustersImpl;
import com.azure.resourcemanager.containerservice.models.KubernetesClusters;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;

public final class ContainerServiceManager
extends Manager<ContainerServiceManagementClient> {
    private KubernetesClustersImpl kubernetesClusters;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ContainerServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
        return ContainerServiceManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static ContainerServiceManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new ContainerServiceManager(httpPipeline, profile);
    }

    private ContainerServiceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new ContainerServiceManagementClientBuilder().endpoint(profile.getEnvironment().getResourceManagerEndpoint()).pipeline(httpPipeline).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public KubernetesClusters kubernetesClusters() {
        if (this.kubernetesClusters == null) {
            this.kubernetesClusters = new KubernetesClustersImpl(this);
        }
        return this.kubernetesClusters;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ContainerServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
            return ContainerServiceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ContainerServiceManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

