/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.Result;

abstract class AbstractResult<K, V>
implements Result<Page<K, V>> {
    private List<Page<K, V>> copiedPages;

    public AbstractResult() {
        this.copiedPages = new ArrayList<Page<K, V>>();
    }

    public AbstractResult(List<Page<K, V>> copiedPages) {
        this.copiedPages = copiedPages;
    }

    @Override
    public List<Page<K, V>> getCopiedPages() {
        return this.copiedPages;
    }

    @Override
    public void addCopiedPage(Page<K, V> page) {
        this.copiedPages.add(page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n    copiedPage = <");
        boolean isFirst = true;
        for (Page<K, V> copiedPage : this.getCopiedPages()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(((AbstractPage)copiedPage).getOffset());
        }
        sb.append(">");
        return sb.toString();
    }
}

