/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.cabParser.structure;

import dorkbox.cabParser.CabException;
import dorkbox.cabParser.Checksum;
import dorkbox.cabParser.CorruptCabException;
import dorkbox.util.bytes.LittleEndian;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class CfDataRecord {
    private int csum;
    public int cbData;
    public int cbUncomp;
    private int sizeOfBlockData;

    public CfDataRecord(int sizeOfBlockData) {
        this.sizeOfBlockData = sizeOfBlockData;
    }

    public void read(InputStream input, byte[] bytes) throws IOException, CabException {
        int read;
        this.csum = LittleEndian.Int_.from((InputStream)input);
        this.cbData = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.cbUncomp = LittleEndian.UShort_.from((InputStream)input).intValue();
        if (this.cbData > bytes.length) {
            throw new CorruptCabException("Corrupt cfData record");
        }
        if (this.sizeOfBlockData != 0) {
            input.skip(this.sizeOfBlockData);
        }
        for (int readTotal = 0; readTotal < this.cbData; readTotal += read) {
            read = input.read(bytes, readTotal, this.cbData - readTotal);
            if (read >= 0) continue;
            throw new EOFException();
        }
    }

    private int checksum(byte[] bytes) {
        byte[] arrayOfByte = new byte[]{(byte)(this.cbData & 0xFF), (byte)(this.cbData >>> 8 & 0xFF), (byte)(this.cbUncomp & 0xFF), (byte)(this.cbUncomp >>> 8 & 0xFF)};
        return Checksum.calculate(bytes, this.cbData, Checksum.calculate(arrayOfByte, 4, 0));
    }

    public boolean validateCheckSum(byte[] bytesToCheck) {
        return this.checksum(bytesToCheck) == this.csum;
    }
}

