/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.cabParser.structure;

import dorkbox.cabParser.CabException;
import dorkbox.cabParser.CorruptCabException;
import dorkbox.util.bytes.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;

public final class CabFileEntry {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    static final int READONLY = 1;
    static final int HIDDEN = 2;
    static final int SYSTEM = 4;
    static final int ARCHIVE = 32;
    static final int NAME_IS_UTF = 128;
    public long cbFile;
    public long offFolderStart;
    public int iFolder;
    public Date date = new Date();
    public int attribs;
    public String szName;
    private Object objectOrSomething;

    public void read(InputStream input) throws IOException, CabException {
        byte[] arrayOfByte = new byte[256];
        this.cbFile = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.offFolderStart = LittleEndian.UInt_.from((InputStream)input).longValue();
        this.iFolder = LittleEndian.UShort_.from((InputStream)input).intValue();
        int timeA = LittleEndian.UShort_.from((InputStream)input).intValue();
        int timeB = LittleEndian.UShort_.from((InputStream)input).intValue();
        this.date = this.getDate(timeA, timeB);
        this.attribs = LittleEndian.UShort_.from((InputStream)input).intValue();
        int i = 0;
        for (i = 0; i < arrayOfByte.length; ++i) {
            int m = input.read();
            if (m == -1) {
                throw new CorruptCabException("EOF reading cffile");
            }
            arrayOfByte[i] = (byte)m;
            if (m == 0) break;
        }
        if (i >= arrayOfByte.length) {
            throw new CorruptCabException("cffile filename not null terminated");
        }
        if ((this.attribs & 0x80) == 128) {
            this.szName = CabFileEntry.readUtfString(arrayOfByte);
            if (this.szName == null) {
                throw new CorruptCabException("invalid utf8 code");
            }
        } else {
            this.szName = new String(arrayOfByte, 0, i, US_ASCII).trim();
        }
    }

    public boolean isReadOnly() {
        return (this.attribs & 1) != 0;
    }

    public void setReadOnly(boolean bool) {
        if (bool) {
            this.attribs |= 1;
            return;
        }
        this.attribs &= 0xFFFFFFFE;
    }

    public boolean isHidden() {
        return (this.attribs & 2) != 0;
    }

    public void setHidden(boolean bool) {
        if (bool) {
            this.attribs |= 2;
            return;
        }
        this.attribs &= 0xFFFFFFFD;
    }

    public boolean isSystem() {
        return (this.attribs & 4) != 0;
    }

    public void setSystem(boolean bool) {
        if (bool) {
            this.attribs |= 4;
            return;
        }
        this.attribs &= 0xFFFFFFFB;
    }

    public boolean isArchive() {
        return (this.attribs & 0x20) != 0;
    }

    public void setArchive(boolean bool) {
        if (bool) {
            this.attribs |= 0x20;
            return;
        }
        this.attribs &= 0xFFFFFFDF;
    }

    public String getName() {
        return this.szName;
    }

    public long getSize() {
        return this.cbFile;
    }

    public void setName(String name) {
        this.szName = name;
    }

    public void setSize(long size) {
        this.cbFile = (int)size;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date paramDate) {
        this.date = paramDate;
    }

    private Date getDate(int dateInfo, int timeInfo) {
        int i = dateInfo & 0x1F;
        int j = (dateInfo >>> 5) - 1 & 0xF;
        int k = (dateInfo >>> 9) + 80;
        int m = (timeInfo & 0x1F) << 1;
        int n = timeInfo >>> 5 & 0x3F;
        int i1 = timeInfo >>> 11 & 0x1F;
        return new Date(k, j, i, i1, n, m);
    }

    public Object getApplicationData() {
        return this.objectOrSomething;
    }

    public void setApplicationData(Object obj) {
        this.objectOrSomething = obj;
    }

    public String toString() {
        return this.szName;
    }

    private static String readUtfString(byte[] stringBytes) {
        int j = 0;
        int stringSize = 0;
        int k = 0;
        stringSize = 0;
        while (stringBytes[stringSize] != 0) {
            ++stringSize;
        }
        char[] stringChars = new char[stringSize];
        k = 0;
        while (stringBytes[j] != 0) {
            char m;
            if ((m = (char)(stringBytes[j++] & 0xFF)) < '\u0080') {
                stringChars[k] = m;
            } else {
                if (m < '\u00c0') {
                    return null;
                }
                if (m < '\u00e0') {
                    stringChars[k] = (char)((m & 0x1F) << 6);
                    if ((m = (char)(stringBytes[j++] & 0xFF)) < '\u0080' || m > '\u00bf') {
                        return null;
                    }
                    stringChars[k] = (char)(stringChars[k] | (char)(m & 0x3F));
                } else if (m < '\u00f0') {
                    stringChars[k] = (char)((m & 0xF) << 12);
                    if ((m = (char)(stringBytes[j++] & 0xFF)) < '\u0080' || m > '\u00bf') {
                        return null;
                    }
                    stringChars[k] = (char)(stringChars[k] | (char)((m & 0x3F) << 6));
                    if ((m = (char)(stringBytes[j++] & 0xFF)) < '\u0080' || m > '\u00bf') {
                        return null;
                    }
                    stringChars[k] = (char)(stringChars[k] | (char)(m & 0x3F));
                } else {
                    return null;
                }
            }
            ++k;
        }
        return new String(stringChars, 0, k);
    }
}

