/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.cabParser.decompress.zip;

import dorkbox.cabParser.CabException;
import dorkbox.cabParser.CorruptCabException;
import dorkbox.cabParser.decompress.Decompressor;
import dorkbox.cabParser.decompress.zip.DecompressZipState;

public final class DecompressZip
implements Decompressor {
    private static final int[] ar1 = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    private static final int[] ar2 = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] ar3 = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private byte[] bytes = new byte[320];
    private byte[] inputBytes;
    private byte[] outputBytes;
    private int index;
    private int inputPlus4;
    int int1;
    private int int2;
    private int int3;
    private int outputLength;
    private DecompressZipState state1;
    private DecompressZipState state2;
    private DecompressZipState state3;

    @Override
    public void init(int windowBits) {
        this.state1 = new DecompressZipState(288, 9, this);
        this.state2 = new DecompressZipState(32, 7, this);
        this.state3 = new DecompressZipState(19, 7, this);
    }

    @Override
    public void decompress(byte[] inputBytes, byte[] outputBytes, int inputLength, int outputLength) throws CabException {
        this.inputBytes = inputBytes;
        this.outputBytes = outputBytes;
        if (this.inputBytes[0] != 67 || this.inputBytes[1] != 75) {
            throw new CorruptCabException();
        }
        if (outputBytes.length < 33027) {
            throw new CabException();
        }
        if (inputBytes.length < 28) {
            throw new CabException();
        }
        this.index = 2;
        this.inputPlus4 = inputLength + 4;
        this.outputLength = outputLength;
        this.int3 = 0;
        this.maybeDecompress();
        while (this.int3 < this.outputLength) {
            this.decompressMore();
        }
    }

    @Override
    public int getMaxGrowth() {
        return 28;
    }

    @Override
    public void reset(int windowBits) {
    }

    private void maybeDecompress() throws CabException {
        if (this.index + 4 > this.inputPlus4) {
            throw new CorruptCabException();
        }
        this.int1 = this.readShort() | this.readShort() << 16;
        this.int2 = 16;
    }

    void add(int paramInt) {
        this.int1 >>>= paramInt;
        this.int2 -= paramInt;
        if (this.int2 <= 0) {
            this.int2 += 16;
            this.int1 |= (this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8) << this.int2;
            this.index += 2;
        }
    }

    private void check() throws CabException {
        if (this.index > this.inputPlus4) {
            throw new CorruptCabException();
        }
    }

    private void bits() throws CabException {
        int i = this.int3;
        int j = this.outputLength;
        byte[] arrayOfByte1 = this.outputBytes;
        int[] arrayOfInt1 = this.state1.intA2;
        int[] arrayOfInt2 = this.state1.intA3;
        int[] arrayOfInt3 = this.state1.intA4;
        byte[] arrayOfByte2 = this.state1.byteA;
        int[] arrayOfInt4 = this.state2.intA2;
        int[] arrayOfInt5 = this.state2.intA3;
        int[] arrayOfInt6 = this.state2.intA4;
        byte[] arrayOfByte3 = this.state2.byteA;
        int k = this.int1;
        int m = this.int2;
        while (this.index <= this.inputPlus4) {
            int i2;
            int n = arrayOfInt1[k & 0x1FF];
            while (n < 0) {
                i2 = 512;
                do {
                    n = -n;
                    n = (k & i2) == 0 ? arrayOfInt2[n] : arrayOfInt3[n];
                    i2 <<= 1;
                } while (n < 0);
            }
            byte i1 = arrayOfByte2[n];
            k >>>= i1;
            if ((m -= i1) <= 0) {
                k |= (this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8) << (m += 16);
                this.index += 2;
            }
            if (n < 256) {
                arrayOfByte1[i++] = (byte)n;
            } else {
                int i3;
                int i4;
                if ((n -= 257) < 0) break;
                if (n < 8) {
                    n += 3;
                } else if (n != 28) {
                    i4 = n - 4 >>> 2;
                    n = ar1[n] + (k & (1 << i4) - 1);
                    k >>>= i4;
                    if ((m -= i4) <= 0) {
                        k |= (this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8) << (m += 16);
                        this.index += 2;
                    }
                } else {
                    n = 258;
                }
                i2 = arrayOfInt4[k & 0x7F];
                while (i2 < 0) {
                    int i5 = 128;
                    do {
                        i2 = -i2;
                        i2 = (k & i5) == 0 ? arrayOfInt5[i2] : arrayOfInt6[i2];
                        i5 <<= 1;
                    } while (i2 < 0);
                }
                i1 = arrayOfByte3[i2];
                k >>>= i1;
                if ((m -= i1) <= 0) {
                    k |= (this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8) << (m += 16);
                    this.index += 2;
                }
                if ((i4 = i2 - 2 >> 1) > 0) {
                    i3 = ar2[i2] + (k & (1 << i4) - 1);
                    k >>>= i4;
                    if ((m -= i4) <= 0) {
                        k |= (this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8) << (m += 16);
                        this.index += 2;
                    }
                } else {
                    i3 = i2 + 1;
                }
                do {
                    arrayOfByte1[i] = arrayOfByte1[i - i3 & Short.MAX_VALUE];
                    ++i;
                } while (--n != 0);
            }
            if (i <= j) continue;
        }
        this.int3 = i;
        this.int1 = k;
        this.int2 = m;
        this.check();
    }

    private void readStuffcommon() throws CabException {
        this.state1.main();
        this.state2.main();
    }

    private void setup() {
        int i = 0;
        do {
            this.state1.byteA[i] = 8;
        } while (++i <= 143);
        i = 144;
        do {
            this.state1.byteA[i] = 9;
        } while (++i <= 255);
        i = 256;
        do {
            this.state1.byteA[i] = 7;
        } while (++i <= 279);
        i = 280;
        do {
            this.state1.byteA[i] = 8;
        } while (++i <= 287);
        i = 0;
        do {
            this.state2.byteA[i] = 5;
        } while (++i < 32);
    }

    private int makeShort(byte byte1, byte byte2) {
        return byte1 & 0xFF | (byte2 & 0xFF) << 8;
    }

    private void expand() throws CabException {
        int n;
        this.check();
        int i = this.calc(5) + 257;
        int j = this.calc(5) + 1;
        int k = this.calc(4) + 4;
        for (n = 0; n < k; ++n) {
            this.state3.byteA[DecompressZip.ar3[n]] = (byte)this.calc(3);
            this.check();
        }
        for (n = k; n < ar3.length; ++n) {
            this.state3.byteA[DecompressZip.ar3[n]] = 0;
        }
        this.state3.main();
        int m = i + j;
        int n2 = 0;
        while (n2 < m) {
            int i2;
            int i3;
            this.check();
            byte i1 = (byte)this.state3.read();
            if (i1 <= 15) {
                this.bytes[n2++] = i1;
                continue;
            }
            if (i1 == 16) {
                if (n2 == 0) {
                    throw new CorruptCabException();
                }
                i3 = this.bytes[n2 - 1];
                i2 = this.calc(2) + 3;
                if (n2 + i2 > m) {
                    throw new CorruptCabException();
                }
                for (int i4 = 0; i4 < i2; ++i4) {
                    this.bytes[n2++] = (byte)i3;
                }
                continue;
            }
            if (i1 == 17) {
                i2 = this.calc(3) + 3;
                if (n2 + i2 > m) {
                    throw new CorruptCabException();
                }
                for (i3 = 0; i3 < i2; ++i3) {
                    this.bytes[n2++] = 0;
                }
                continue;
            }
            i2 = this.calc(7) + 11;
            if (n2 + i2 > m) {
                throw new CorruptCabException();
            }
            for (i3 = 0; i3 < i2; ++i3) {
                this.bytes[n2++] = 0;
            }
        }
        System.arraycopy(this.bytes, 0, this.state1.byteA, 0, i);
        for (n2 = i; n2 < 288; ++n2) {
            this.state1.byteA[n2] = 0;
        }
        for (n2 = 0; n2 < j; ++n2) {
            this.state2.byteA[n2] = this.bytes[n2 + i];
        }
        for (n2 = j; n2 < 32; ++n2) {
            this.state2.byteA[n2] = 0;
        }
        if (this.state1.byteA[256] == 0) {
            throw new CorruptCabException();
        }
    }

    private int readShort() {
        int i = this.inputBytes[this.index] & 0xFF | (this.inputBytes[this.index + 1] & 0xFF) << 8;
        this.index += 2;
        return i;
    }

    private int calc(int paramInt) {
        int i = this.int1 & (1 << paramInt) - 1;
        this.add(paramInt);
        return i;
    }

    private void decompressMore() throws CabException {
        int i = this.calc(1);
        int j = this.calc(2);
        if (j == 2) {
            this.expand();
            this.readStuffcommon();
            this.bits();
            return;
        }
        if (j == 1) {
            this.setup();
            this.readStuffcommon();
            this.bits();
            return;
        }
        if (j == 0) {
            this.verify();
            return;
        }
        throw new CabException();
    }

    private void verify() throws CabException {
        int j;
        this.mod();
        if (this.index >= this.inputPlus4) {
            throw new CorruptCabException();
        }
        int i = this.makeShort(this.inputBytes[this.index], this.inputBytes[this.index + 1]);
        if ((short)i != (short)(~(j = this.makeShort(this.inputBytes[this.index + 2], this.inputBytes[this.index + 3])))) {
            throw new CorruptCabException();
        }
        if (this.index + i > this.inputPlus4 || this.int3 + i > this.outputLength) {
            throw new CorruptCabException();
        }
        this.maybeDecompress();
        System.arraycopy(this.inputBytes, this.index, this.outputBytes, this.int3, i);
        this.int3 += i;
        if (this.int3 < this.outputLength) {
            this.maybeDecompress();
        }
    }

    private void mod() {
        this.index = this.int2 == 16 ? (this.index -= 4) : (this.int2 >= 8 ? (this.index -= 3) : (this.index -= 2));
        if (this.index < 0) {
            this.index = 0;
        }
        this.int2 = 0;
    }
}

