/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import net.htmlparser.jericho.LoggerQueue;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StreamEncodingDetector;

final class EncodingDetector {
    private final InputStream inputStream;
    private String encoding = null;
    private String encodingSpecificationInfo = null;
    private final String preliminaryEncoding;
    private final Integer preliminaryEncodingCodeUnitSize;
    private final String preliminaryEncodingSpecificationInfo;
    private final String alternativePreliminaryEncoding;
    private LoggerQueue logger = new LoggerQueue();
    private static final int PREVIEW_BYTE_COUNT = 2048;
    private static final String UTF_8 = "UTF-8";
    private static final String ISO_8859_1 = "ISO-8859-1";

    public EncodingDetector(URLConnection urlConnection) throws IOException {
        this(new StreamEncodingDetector(urlConnection));
    }

    public EncodingDetector(InputStream inputStream) throws IOException {
        this(new StreamEncodingDetector(inputStream));
    }

    public EncodingDetector(InputStream inputStream, String preliminaryEncoding) throws IOException {
        this(inputStream, preliminaryEncoding, "preliminary encoding set explicitly", null);
        this.logger = new LoggerQueue();
        if (!EncodingDetector.isEncodingSupported(preliminaryEncoding)) {
            throw new UnsupportedEncodingException(preliminaryEncoding + " specified as preliminaryEncoding constructor argument");
        }
        this.detectDocumentSpecifiedEncoding();
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector) throws IOException {
        this(streamEncodingDetector, ISO_8859_1);
    }

    private EncodingDetector(StreamEncodingDetector streamEncodingDetector, String alternativePreliminaryEncoding) throws IOException {
        this(streamEncodingDetector.getInputStream(), streamEncodingDetector.getEncoding(), streamEncodingDetector.getEncodingSpecificationInfo(), alternativePreliminaryEncoding);
        this.logger = streamEncodingDetector.getLoggerQueue();
        if (streamEncodingDetector.isDifinitive() || !streamEncodingDetector.isDocumentSpecifiedEncodingPossible()) {
            this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo);
        } else {
            this.detectDocumentSpecifiedEncoding();
        }
    }

    private EncodingDetector(InputStream inputStream, String preliminaryEncoding, String preliminaryEncodingSpecificationInfo, String alternativePreliminaryEncoding) throws IOException {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.preliminaryEncoding = preliminaryEncoding;
        this.preliminaryEncodingCodeUnitSize = StreamEncodingDetector.codeUnitSizeMap.get(preliminaryEncoding == null ? null : preliminaryEncoding.toUpperCase());
        this.preliminaryEncodingSpecificationInfo = preliminaryEncodingSpecificationInfo;
        this.alternativePreliminaryEncoding = alternativePreliminaryEncoding;
        if (alternativePreliminaryEncoding != null && !EncodingDetector.isEncodingSupported(alternativePreliminaryEncoding)) {
            throw new UnsupportedEncodingException(alternativePreliminaryEncoding + " specified as alternativePreliminaryEncoding constructor argument");
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncoding() {
        return this.preliminaryEncoding;
    }

    public String getPreliminaryEncodingSpecificationInfo() {
        return this.preliminaryEncodingSpecificationInfo;
    }

    public LoggerQueue getLoggerQueue() {
        return this.logger;
    }

    public Reader openReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.inputStream, ISO_8859_1);
        }
        if (!EncodingDetector.isEncodingSupported(this.encoding)) {
            throw new UnsupportedEncodingException(this.encoding + ": " + this.encodingSpecificationInfo);
        }
        return new InputStreamReader(this.inputStream, this.encoding);
    }

    private boolean setEncoding(String encoding, String encodingSpecificationInfo) {
        this.encoding = encoding;
        this.encodingSpecificationInfo = encodingSpecificationInfo;
        return true;
    }

    private boolean detectDocumentSpecifiedEncoding() throws IOException {
        String documentSpecifiedEncodingInfoSuffix;
        String safePreliminaryEncoding;
        block12: {
            String documentSpecifiedEncoding;
            this.inputStream.mark(2048);
            if (EncodingDetector.isEncodingSupported(this.preliminaryEncoding)) {
                safePreliminaryEncoding = this.preliminaryEncoding;
            } else {
                if (this.alternativePreliminaryEncoding == null) {
                    throw new UnsupportedEncodingException(this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
                }
                safePreliminaryEncoding = this.alternativePreliminaryEncoding;
            }
            Source previewSource = this.getPreviewSource(safePreliminaryEncoding);
            this.inputStream.reset();
            previewSource.setLogger(null);
            if (this.preliminaryEncoding != safePreliminaryEncoding && this.logger.isWarnEnabled()) {
                this.logger.warn("Alternative encoding " + safePreliminaryEncoding + " substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo);
            }
            if ((documentSpecifiedEncoding = previewSource.getDocumentSpecifiedEncoding(this)) == null) {
                if (previewSource.isXML()) {
                    return this.setEncoding(UTF_8, "mandatory XML encoding when no BOM or encoding declaration is present");
                }
                documentSpecifiedEncodingInfoSuffix = "no encoding specified in document";
            } else {
                try {
                    if (EncodingDetector.isEncodingSupported(documentSpecifiedEncoding)) {
                        return this.setEncoding(documentSpecifiedEncoding, previewSource.getEncodingSpecificationInfo());
                    }
                    documentSpecifiedEncodingInfoSuffix = "encoding " + documentSpecifiedEncoding + " specified in document is not supported";
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Unsupported encoding " + documentSpecifiedEncoding + " specified in document, using preliminary encoding " + safePreliminaryEncoding + " instead");
                    }
                }
                catch (IllegalCharsetNameException ex) {
                    documentSpecifiedEncodingInfoSuffix = "illegal encoding " + documentSpecifiedEncoding + " specified in document";
                    if (!this.logger.isWarnEnabled()) break block12;
                    this.logger.warn("Illegal encoding " + documentSpecifiedEncoding + " specified in document, using preliminary encoding " + safePreliminaryEncoding + " instead");
                }
            }
        }
        if (this.preliminaryEncoding != safePreliminaryEncoding) {
            return this.setEncoding(safePreliminaryEncoding, "alternative encoding substituted for unsupported preliminary encoding " + this.preliminaryEncoding + ": " + this.preliminaryEncodingSpecificationInfo + ", " + documentSpecifiedEncodingInfoSuffix);
        }
        return this.setEncoding(this.preliminaryEncoding, this.preliminaryEncodingSpecificationInfo + ", " + documentSpecifiedEncodingInfoSuffix);
    }

    boolean isIncompatibleWithPreliminaryEncoding(String encoding) {
        if (this.preliminaryEncodingCodeUnitSize == null || encoding == null) {
            return false;
        }
        Integer specifiedCodeUnitSize = StreamEncodingDetector.codeUnitSizeMap.get(encoding.toUpperCase());
        if (specifiedCodeUnitSize == null) {
            return false;
        }
        return !this.preliminaryEncodingCodeUnitSize.equals(specifiedCodeUnitSize);
    }

    private Source getPreviewSource(String previewEncoding) throws IOException {
        int nextByte;
        int i;
        byte[] bytes = new byte[2048];
        for (i = 0; i < 2048 && (nextByte = this.inputStream.read()) != -1; ++i) {
            bytes[i] = (byte)nextByte;
        }
        return new Source(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes, 0, i), previewEncoding), null);
    }

    static boolean isEncodingSupported(String encoding) {
        try {
            return Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException ex) {
            return false;
        }
    }
}

