/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.nodoc.ListSegment;

public final class Attributes
extends ListSegment<Attribute> {
    private final ArrayList<Attribute> attributeList;
    final boolean containsServerTagOutsideOfAttributeValue;
    private static int defaultMaxErrorCount = 2;

    private Attributes(Source source, int begin, int end, ArrayList<Attribute> attributeList, boolean containsServerTagOutsideOfAttributeValue) {
        super(source, begin, end);
        this.attributeList = attributeList;
        this.containsServerTagOutsideOfAttributeValue = containsServerTagOutsideOfAttributeValue;
    }

    static Attributes construct(Source source, int startTagBegin, StartTagType startTagType, String tagName) {
        return Attributes.construct(source, "StartTag", ParsingState.AFTER_TAG_NAME, startTagBegin, -1, -1, startTagType, tagName, defaultMaxErrorCount);
    }

    static Attributes construct(Source source, int startTagBegin, int attributesBegin, int maxEnd, StartTagType startTagType, String tagName, int maxErrorCount) {
        return Attributes.construct(source, "Attributes for StartTag", ParsingState.BETWEEN_ATTRIBUTES, startTagBegin, attributesBegin, maxEnd, startTagType, tagName, maxErrorCount);
    }

    static Attributes construct(Source source, int begin, int maxEnd, int maxErrorCount) {
        return Attributes.construct(source, "Attributes", ParsingState.BETWEEN_ATTRIBUTES, begin, -1, maxEnd, StartTagType.NORMAL, null, maxErrorCount);
    }

    /*
     * Unable to fully structure code
     */
    private static Attributes construct(Source source, String logType, ParsingState parsingState, int logBegin, int attributesBegin, int maxEnd, StartTagType startTagType, String tagName, int maxErrorCount) {
        isClosingSlashIgnored = false;
        if (tagName != null) {
            if (attributesBegin == -1) {
                attributesBegin = logBegin + 1 + tagName.length();
            }
            if (startTagType == StartTagType.NORMAL && HTMLElements.isClosingSlashIgnored(tagName)) {
                isClosingSlashIgnored = true;
            }
        } else {
            attributesBegin = logBegin;
        }
        attributesEnd = attributesBegin;
        attributeList = new ArrayList<Attribute>();
        containsServerTagOutsideOfAttributeValue = false;
        parseText = source.getParseText();
        i = attributesBegin;
        quote = ' ';
        nameSegment = null;
        key = null;
        currentBegin = -1;
        isTerminatingCharacter = false;
        errorCount = 0;
        try {
            while (!isTerminatingCharacter) {
                if (i == maxEnd || startTagType.atEndOfAttributes(source, i, isClosingSlashIgnored)) {
                    isTerminatingCharacter = true;
                }
                if ((ch = parseText.charAt(i)) == '<' && (interlopingTag = Tag.getTagAt(source, i, true)) != null) {
                    if (parsingState == ParsingState.START_VALUE) {
                        currentBegin = i;
                        quote = ' ';
                        parsingState = ParsingState.IN_VALUE;
                    }
                    i = attributesEnd = interlopingTag.end;
                    if (parsingState == ParsingState.IN_VALUE) continue;
                    containsServerTagOutsideOfAttributeValue = true;
                    continue;
                }
                switch (1.$SwitchMap$net$htmlparser$jericho$Attributes$ParsingState[parsingState.ordinal()]) {
                    case 1: {
                        if (!isTerminatingCharacter && ch != quote && (quote != 32 || !Attributes.isWhiteSpace(ch))) ** GOTO lbl57
                        if (quote != ' ') ** GOTO lbl39
                        valueSegment = valueSegmentIncludingQuotes = new Segment(source, currentBegin, i);
                        ** GOTO lbl52
lbl39:
                        // 1 sources

                        if (!isTerminatingCharacter) ** GOTO lbl50
                        if (i == maxEnd) {
                            if (source.logger.isErrorEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "terminated in the middle of a quoted attribute value", i);
                            }
                            if (Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                            valueSegment = new Segment(source, currentBegin, i);
                            valueSegmentIncludingQuotes = new Segment(source, currentBegin - 1, i);
                        } else {
                            isTerminatingCharacter = false;
                            break;
lbl50:
                            // 1 sources

                            valueSegment = new Segment(source, currentBegin, i);
                            valueSegmentIncludingQuotes = new Segment(source, currentBegin - 1, i + 1);
                        }
lbl52:
                        // 3 sources

                        attributeList.add(new Attribute(source, key, nameSegment, valueSegment, valueSegmentIncludingQuotes));
                        attributesEnd = valueSegmentIncludingQuotes.getEnd();
                        parsingState = ParsingState.BETWEEN_ATTRIBUTES;
                        break;
lbl57:
                        // 1 sources

                        if (ch != '<' || quote != 32) break;
                        if (source.logger.isErrorEnabled()) {
                            Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character in unquoted attribute value", i);
                        }
                        return null;
                    }
                    case 2: {
                        if (isTerminatingCharacter || ch == '=' || Attributes.isWhiteSpace(ch)) {
                            nameSegment = new Segment(source, currentBegin, i);
                            key = nameSegment.toString().toLowerCase();
                            if (isTerminatingCharacter) {
                                attributeList.add(new Attribute(source, key, nameSegment));
                                attributesEnd = i;
                                break;
                            }
                            parsingState = ch == '=' ? ParsingState.START_VALUE : ParsingState.AFTER_NAME;
                            break;
                        }
                        if (Tag.isXMLNameChar(ch)) break;
                        if (ch == '<') {
                            if (source.logger.isErrorEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character in attribute name", i);
                            }
                            return null;
                        }
                        if (Attributes.isInvalidEmptyElementTag(startTagType, source, i, logType, tagName, logBegin)) break;
                        if (source.logger.isErrorEnabled()) {
                            Attributes.log(source, logType, tagName, logBegin, "contains attribute name with invalid character", i);
                        }
                        if (!Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) break;
                        return null;
                    }
                    case 3: {
                        if (isTerminatingCharacter || ch != '=' && !Attributes.isWhiteSpace(ch)) {
                            attributeList.add(new Attribute(source, key, nameSegment));
                            attributesEnd = nameSegment.getEnd();
                            if (isTerminatingCharacter) break;
                            parsingState = ParsingState.BETWEEN_ATTRIBUTES;
                            --i;
                            break;
                        }
                        if (ch == '=') {
                            parsingState = ParsingState.START_VALUE;
                            break;
                        }
                        if (ch != '<') break;
                        if (source.logger.isErrorEnabled()) {
                            Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character after attribute name", i);
                        }
                        return null;
                    }
                    case 4: {
                        if (isTerminatingCharacter) break;
                        if (Attributes.isWhiteSpace(ch)) {
                            quote = ' ';
                            break;
                        }
                        if (quote != ' ') {
                            if (source.logger.isErrorEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "has missing whitespace after quoted attribute value", i);
                            }
                            if (errorCount > 0 && Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                        }
                        if (!Tag.isXMLNameStartChar(ch)) {
                            if (ch == '<') {
                                if (source.logger.isErrorEnabled()) {
                                    Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character", i);
                                }
                                return null;
                            }
                            if (Attributes.isInvalidEmptyElementTag(startTagType, source, i, logType, tagName, logBegin)) break;
                            if (startTagType == StartTagType.NORMAL && startTagType.atEndOfAttributes(source, i, false)) {
                                if (!source.logger.isErrorEnabled()) break;
                                Attributes.log(source, logType, tagName, logBegin, "contains a '/' character before the closing '>', which is ignored because tags of this name cannot be empty-element tags");
                                break;
                            }
                            if (source.logger.isErrorEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "contains attribute name with invalid first character", i);
                            }
                            if (Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                        }
                        parsingState = ParsingState.IN_NAME;
                        currentBegin = i;
                        break;
                    }
                    case 5: {
                        currentBegin = i;
                        if (isTerminatingCharacter) {
                            if (source.logger.isErrorEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "has missing attribute value after '=' sign", i);
                            }
                            if (errorCount > 0 && Attributes.reachedMaxErrorCount(++errorCount, source, logType, tagName, logBegin, maxErrorCount)) {
                                return null;
                            }
                            valueSegment = new Segment(source, i, i);
                            attributeList.add(new Attribute(source, key, nameSegment, valueSegment, valueSegment));
                            attributesEnd = i;
                            parsingState = ParsingState.BETWEEN_ATTRIBUTES;
                            break;
                        }
                        if (ch == '\'' || ch == '\"') {
                            quote = ch;
                            ++currentBegin;
                        } else {
                            if (Attributes.isWhiteSpace(ch)) break;
                            if (ch == '<') {
                                if (source.logger.isErrorEnabled()) {
                                    Attributes.log(source, logType, tagName, logBegin, "rejected because of '<' character at the start of an attribute value", i);
                                }
                                return null;
                            }
                            quote = ' ';
                        }
                        parsingState = ParsingState.IN_VALUE;
                        break;
                    }
                    case 6: {
                        if (isTerminatingCharacter) break;
                        if (!Attributes.isWhiteSpace(ch)) {
                            if (Attributes.isInvalidEmptyElementTag(startTagType, source, i, logType, tagName, logBegin)) break;
                            if (source.logger.isErrorEnabled()) {
                                Attributes.log(source, logType, tagName, logBegin, "rejected because the name contains an invalid character", i);
                            }
                            return null;
                        }
                        parsingState = ParsingState.BETWEEN_ATTRIBUTES;
                    }
                }
                ++i;
            }
            return new Attributes(source, attributesBegin, attributesEnd, attributeList, containsServerTagOutsideOfAttributeValue);
        }
        catch (IndexOutOfBoundsException ex) {
            if (source.logger.isErrorEnabled()) {
                Attributes.log(source, logType, tagName, logBegin, "rejected because it has no closing '>' character");
            }
            return null;
        }
    }

    private static boolean reachedMaxErrorCount(int errorCount, Source source, String logType, String tagName, int logBegin, int maxErrorCount) {
        if (errorCount <= maxErrorCount) {
            return false;
        }
        if (source.logger.isErrorEnabled()) {
            Attributes.log(source, logType, tagName, logBegin, "rejected because it contains too many errors");
        }
        return true;
    }

    private static boolean isInvalidEmptyElementTag(StartTagType startTagType, Source source, int i, String logType, String tagName, int logBegin) {
        if (startTagType != StartTagType.NORMAL || !startTagType.atEndOfAttributes(source, i, false)) {
            return false;
        }
        if (source.logger.isErrorEnabled()) {
            Attributes.log(source, logType, tagName, logBegin, "contains a '/' character before the closing '>', which is ignored because tags of this name cannot be empty-element tags");
        }
        return true;
    }

    @Override
    public Attribute get(int index) {
        return this.attributeList.get(index);
    }

    public Attribute get(String name) {
        int size = this.attributeList.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute = this.attributeList.get(i);
            if (!attribute.getKey().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        return null;
    }

    public String getValue(String name) {
        Attribute attribute = this.get(name);
        return attribute == null ? null : attribute.getValue();
    }

    String getRawValue(String name) {
        Attribute attribute = this.get(name);
        return attribute == null || !attribute.hasValue() ? null : attribute.getValueSegment().toString();
    }

    @Override
    public int getCount() {
        return this.attributeList.size();
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Attribute> listIterator(int index) {
        return this.attributeList.listIterator(index);
    }

    public Map<String, String> populateMap(Map<String, String> attributesMap, boolean convertNamesToLowerCase) {
        for (Attribute attribute : this) {
            attributesMap.put(convertNamesToLowerCase ? attribute.getKey() : attribute.getName(), attribute.getValue());
        }
        return attributesMap;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Attributes ").append(super.getDebugInfo()).append(": ");
        if (this.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append(Config.NewLine);
            for (Attribute attribute : this) {
                sb.append("  ").append(attribute.getDebugInfo());
            }
        }
        return sb.toString();
    }

    public static int getDefaultMaxErrorCount() {
        return defaultMaxErrorCount;
    }

    public static void setDefaultMaxErrorCount(int value) {
        defaultMaxErrorCount = value;
    }

    public static String generateHTML(Map<String, String> attributesMap) {
        StringBuilder sb = new StringBuilder();
        try {
            Attributes.appendHTML(sb, attributesMap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    static void appendHTML(Appendable appendable, Map<String, String> attributesMap) throws IOException {
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            Attribute.appendHTML(appendable, entry.getKey(), entry.getValue());
        }
    }

    Appendable appendTidy(Appendable appendable, Tag nextTag) throws IOException {
        for (Attribute attribute : this) {
            nextTag = attribute.appendTidy(appendable, nextTag);
        }
        return appendable;
    }

    Map<String, String> getMap(boolean convertNamesToLowerCase) {
        return this.populateMap(new LinkedHashMap<String, String>(this.getCount() * 2, 1.0f), convertNamesToLowerCase);
    }

    void setStartTag(StartTag startTag) {
        int size = this.attributeList.size();
        for (int i = 0; i < size; ++i) {
            this.attributeList.get((int)i).startTag = startTag;
        }
    }

    private static void log(Source source, String part1, CharSequence part2, int begin, String part3, int pos) {
        source.logger.error(source.getRowColumnVector(pos).appendTo(source.getRowColumnVector(begin).appendTo(new StringBuilder(200).append(part1).append(' ').append(part2).append(" at ")).append(' ').append(part3).append(" at position ")).toString());
    }

    private static void log(Source source, String part1, CharSequence part2, int begin, String part3) {
        source.logger.error(source.getRowColumnVector(begin).appendTo(new StringBuilder(200).append(part1).append(' ').append(part2).append(" at ")).append(' ').append(part3).toString());
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$htmlparser$jericho$Attributes$ParsingState;

        static {
            $SwitchMap$net$htmlparser$jericho$Attributes$ParsingState = new int[ParsingState.values().length];
            try {
                1.$SwitchMap$net$htmlparser$jericho$Attributes$ParsingState[ParsingState.IN_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$htmlparser$jericho$Attributes$ParsingState[ParsingState.IN_NAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$htmlparser$jericho$Attributes$ParsingState[ParsingState.AFTER_NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$htmlparser$jericho$Attributes$ParsingState[ParsingState.BETWEEN_ATTRIBUTES.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$htmlparser$jericho$Attributes$ParsingState[ParsingState.START_VALUE.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$htmlparser$jericho$Attributes$ParsingState[ParsingState.AFTER_TAG_NAME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum ParsingState {
        AFTER_TAG_NAME,
        BETWEEN_ATTRIBUTES,
        IN_NAME,
        AFTER_NAME,
        START_VALUE,
        IN_VALUE,
        AFTER_VALUE_FINAL_QUOTE;

    }
}

