/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.extras.plugins;

import jakarta.servlet.ServletException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleConfigVerifier
implements PlugIn {
    private final Logger log = LoggerFactory.getLogger(ModuleConfigVerifier.class);
    protected ModuleConfig config = null;
    protected ActionServlet servlet = null;
    private boolean fatal = true;

    public boolean isFatal() {
        return this.fatal;
    }

    public void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    public void destroy() {
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        this.config = config;
        boolean ok = true;
        this.log.atInfo().log(() -> servlet.getInternal().getMessage("configVerifying"));
        if (!this.verifyActionMappingClass()) {
            ok = false;
        }
        if (!this.verifyForwardConfigs()) {
            ok = false;
        }
        if (!this.verifyMessageResourcesConfigs()) {
            ok = false;
        }
        if (!this.verifyPlugInConfigs()) {
            ok = false;
        }
        this.log.atInfo().log(() -> servlet.getInternal().getMessage("configCompleted"));
        if (!ok && this.isFatal()) {
            throw new ServletException(servlet.getInternal().getMessage("configFatal"));
        }
    }

    protected boolean verifyActionMappingClass() {
        String amcName = this.config.getActionMappingClass();
        if (amcName == null) {
            this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyActionMappingClass.missing"));
            return false;
        }
        try {
            RequestUtils.applicationClass((String)amcName);
        }
        catch (ClassNotFoundException e) {
            this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyActionMappingClass.invalid", (Object)amcName));
            return false;
        }
        return true;
    }

    protected boolean verifyForwardConfigs() {
        ForwardConfig[] fcs;
        boolean ok = true;
        for (ForwardConfig fc : fcs = this.config.findForwardConfigs()) {
            String path = fc.getPath();
            if (path == null) {
                this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyForwardConfigs.missing", (Object)fc.getName()));
                ok = false;
                continue;
            }
            if (path.startsWith("/")) continue;
            this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyForwardConfigs.invalid", (Object)path, (Object)fc.getName()));
        }
        return ok;
    }

    protected boolean verifyMessageResourcesConfigs() {
        boolean ok = true;
        MessageResourcesConfig[] mrcs = this.config.findMessageResourcesConfigs();
        for (int i = 0; i < mrcs.length; ++i) {
            String factory = mrcs[i].getFactory();
            if (factory == null) {
                this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.missing"));
                ok = false;
            } else {
                try {
                    RequestUtils.applicationClass((String)factory);
                }
                catch (ClassNotFoundException e) {
                    this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.invalid", (Object)factory));
                    ok = false;
                }
            }
            String key = mrcs[i].getKey();
            if (key != null) continue;
            this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyMessageResourcesConfigs.key"));
        }
        return ok;
    }

    protected boolean verifyPlugInConfigs() {
        boolean ok = true;
        PlugInConfig[] pics = this.config.findPlugInConfigs();
        for (int i = 0; i < pics.length; ++i) {
            String className = pics[i].getClassName();
            if (className == null) {
                this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyPlugInConfigs.missing"));
                ok = false;
                continue;
            }
            try {
                RequestUtils.applicationClass((String)className);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log.atError().log(() -> this.servlet.getInternal().getMessage("verifyPlugInConfigs.invalid", (Object)className));
                ok = false;
            }
        }
        return ok;
    }
}

