/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.extras.plugins;

import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.RequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DigestingPlugIn
implements PlugIn {
    private final Logger log = LoggerFactory.getLogger(DigestingPlugIn.class);
    protected static final String SOURCE_CLASSPATH = "classpath";
    protected static final String SOURCE_FILE = "file";
    protected static final String SOURCE_SERVLET = "servlet";
    protected String configPath = null;
    protected String configSource = "servlet";
    protected String digesterPath = null;
    protected String digesterSource = "servlet";
    protected String key = null;
    protected ModuleConfig moduleConfig = null;
    protected String rulesets = null;
    protected ActionServlet servlet = null;
    protected boolean push = false;

    public void destroy() {
        this.servlet = null;
        this.moduleConfig = null;
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        this.moduleConfig = config;
        Object obj = null;
        Digester digester = this.initializeDigester();
        if (this.push) {
            this.log.debug("push == true; pushing plugin onto digester stack");
            digester.push((Object)this);
        }
        try {
            this.log.debug("XML data file: [path: {}, source: {}]", (Object)this.configPath, (Object)this.configSource);
            URL configURL = this.getConfigURL(this.configPath, this.configSource);
            if (configURL == null) {
                throw new ServletException("Unable to locate XML data file at [path: " + this.configPath + ", source: " + this.configSource + "]");
            }
            URLConnection conn = configURL.openConnection();
            conn.setUseCaches(false);
            conn.connect();
            try (InputStream is = conn.getInputStream();){
                obj = digester.parse(is);
            }
        }
        catch (IOException e) {
            this.log.error("Exception processing config", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (SAXException e) {
            this.log.error("Exception processing config", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        this.storeGeneratedObject(obj);
    }

    protected Digester initializeDigester() throws ServletException {
        Digester digester = null;
        if (this.digesterPath != null && this.digesterSource != null) {
            try {
                this.log.debug("Initialize digester from XML [path: {}; source: {}]", (Object)this.digesterPath, (Object)this.digesterSource);
                digester = this.digesterFromXml(this.digesterPath, this.digesterSource);
            }
            catch (IOException e) {
                this.log.error("Exception instantiating digester from XML", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            this.log.debug("No XML rules for digester; call newDigesterInstance()");
            digester = this.newDigesterInstance();
        }
        try {
            digester.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            this.log.error("Exception configuring Digester instance", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        this.applyRuleSets(digester);
        return digester;
    }

    protected Digester newDigesterInstance() {
        return new Digester();
    }

    protected Digester digesterFromXml(String path, String source) throws IOException {
        URL configURL = this.getConfigURL(path, source);
        if (configURL == null) {
            throw new NullPointerException("No resource '" + path + "' found in '" + source + "'");
        }
        return DigesterLoader.createDigester((URL)configURL);
    }

    protected void applyRuleSets(Digester digester) throws ServletException {
        if (this.rulesets == null || this.rulesets.trim().length() == 0) {
            return;
        }
        this.rulesets = this.rulesets.trim();
        String ruleSet = null;
        while (this.rulesets.length() > 0) {
            int comma = this.rulesets.indexOf(",");
            if (comma < 0) {
                ruleSet = this.rulesets.trim();
                this.rulesets = "";
            } else {
                ruleSet = this.rulesets.substring(0, comma).trim();
                this.rulesets = this.rulesets.substring(comma + 1).trim();
            }
            this.log.debug("Configuring custom Digester Ruleset of type {}", (Object)ruleSet);
            try {
                RuleSet instance = (RuleSet)RequestUtils.applicationInstance((String)ruleSet);
                digester.addRuleSet(instance);
            }
            catch (Exception e) {
                this.log.error("Exception configuring custom Digester RuleSet", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected URL getConfigURL(String path, String source) throws IOException {
        if (SOURCE_CLASSPATH.equals(source)) {
            return this.getClassPathURL(path);
        }
        if (SOURCE_FILE.equals(source)) {
            return this.getFileURL(path);
        }
        if (SOURCE_SERVLET.equals(source)) {
            return this.getServletContextURL(path);
        }
        throw new IllegalArgumentException("ConfigSource " + source + " is not recognized");
    }

    protected URL getClassPathURL(String path) {
        return this.getClass().getClassLoader().getResource(path);
    }

    protected URL getServletContextURL(String path) throws IOException {
        return this.servlet.getServletContext().getResource(path);
    }

    protected URL getFileURL(String path) throws IOException {
        File file = new File(path);
        return file.toURI().toURL();
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigSource(String configSource) {
        this.configSource = configSource;
    }

    public String getConfigSource() {
        return this.configSource;
    }

    protected void storeGeneratedObject(Object obj) {
        this.log.debug("Put [{}] into application context [key:{}]", obj, (Object)this.key);
        this.servlet.getServletContext().setAttribute(this.getKey(), obj);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setRulesets(String ruleSets) {
        this.rulesets = ruleSets;
    }

    public String getRulesets() {
        return this.rulesets;
    }

    public void setDigesterPath(String digesterPath) {
        this.digesterPath = digesterPath;
    }

    public String getDigesterPath() {
        return this.digesterPath;
    }

    public void setDigesterSource(String digesterSource) {
        this.digesterSource = digesterSource;
    }

    public String getDigesterSource() {
        return this.digesterSource;
    }

    public void setPush(boolean push) {
        this.push = push;
    }

    public boolean getPush() {
        return this.push;
    }
}

